/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nominal2Date
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_DATE_TYPE = "date_type";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_TIME_ZONE = "time_zone";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    public static List<Locale> availableLocales;
    public static String[] availableLocaleNames;
    public static int defaultLocale;
    public static final String[] VALUE_TYPES;
    public static final int DATE = 0;
    public static final int TIME = 1;
    public static final int DATE_TIME = 2;

    static {
        Locale[] availableLocaleArray;
        availableLocales = new ArrayList<Locale>();
        Locale[] localeArray = availableLocaleArray = Locale.getAvailableLocales();
        int n = availableLocaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            availableLocales.add(l);
            ++n2;
        }
        Collections.sort(availableLocales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        availableLocaleNames = new String[availableLocales.size()];
        defaultLocale = -1;
        int i = 0;
        while (i < availableLocales.size()) {
            Locale currentLocale = availableLocales.get(i);
            Nominal2Date.availableLocaleNames[i] = currentLocale.getDisplayName();
            if (currentLocale.equals(Locale.US)) {
                defaultLocale = i;
            }
            ++i;
        }
        if (defaultLocale < 0) {
            defaultLocale = 0;
        }
        VALUE_TYPES = new String[]{"date", "time", "date_time"};
    }

    public Nominal2Date(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        Attribute oldAttribute = exampleSet.getAttributes().get(attributeName);
        if (oldAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        int dateType = this.getParameterAsInt(PARAMETER_DATE_TYPE);
        int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
        Locale selectedLocale = Locale.US;
        if (localeIndex >= 0 && localeIndex < availableLocales.size()) {
            selectedLocale = availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
        }
        int valueType = 9;
        if (dateType == 1) {
            valueType = 11;
        } else if (dateType == 0) {
            valueType = 10;
        }
        Attribute newAttribute = AttributeFactory.createAttribute(valueType);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        SimpleDateFormat parser = new SimpleDateFormat(dateFormat, selectedLocale);
        parser.setTimeZone(Tools.getTimeZone(this.getParameterAsInt(PARAMETER_TIME_ZONE)));
        int row = 1;
        for (Example e : exampleSet) {
            if (Double.isNaN(e.getValue(oldAttribute))) {
                e.setValue(newAttribute, Double.NaN);
            } else {
                String oldValue = e.getValueAsString(oldAttribute);
                Date date = null;
                try {
                    date = parser.parse(oldValue);
                }
                catch (ParseException e1) {
                    throw new UserError((Operator)this, 931, dateFormat, oldAttribute.getName(), row, e1.getMessage());
                }
                e.setValue(newAttribute, date.getTime());
            }
            ++row;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(oldAttribute);
        } else {
            oldAttribute.setName(String.valueOf(attributeName) + "_old");
        }
        newAttribute.setName(attributeName);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_DATE_TYPE, "The desired value type for the parsed attribute.", VALUE_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DATE_FORMAT, "The parse format of the date values, for example \"yyyy/MM/dd\".", false));
        type = new ParameterTypeCategory(PARAMETER_TIME_ZONE, "The time zone used for the date objects if not specified in the date string itself.", Tools.getAllTimeZones(), Tools.getPreferredTimeZoneIndex());
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", availableLocaleNames, defaultLocale);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }
}

