/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.Tools;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date2Numerical
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_TIME_UNIT = "time_unit";
    public static final String[] TIME_UNITS = new String[]{"millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "half year", "year"};
    public static final int MILLISECOND = 0;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final int WEEK = 5;
    public static final int MONTH = 6;
    public static final int QUARTER = 7;
    public static final int HALF_YEAR = 8;
    public static final int YEAR = 9;
    public static final String[] PARAMETERS_RELATIVE_TO = new String[]{"millisecond_relative_to", "second_relative_to", "minute_relative_to", "hour_relative_to", "day_relative_to", "week_relative_to", "month_relative_to", "quarter_relative_to", "half_year_relative_to", "year_relative_to"};
    public static final String[][] RELATIVE_TO_MODES = new String[][]{{"second", "epoch"}, {"minute", "hour", "day", "epoch"}, {"hour", "day", "epoch"}, {"day", "epoch"}, {"week", "month", "year", "epoch"}, {"month", "year", "epoch"}, {"quarter", "year", "epoch"}, {"year", "epoch"}, {"year", "epoch"}, {"epoch", "era"}};
    public static final int MILLISECOND_RELATIVE_TO_SECOND = 0;
    public static final int MILLISECOND_RELATIVE_TO_EPOCH = 1;
    public static final int SECOND_RELATIVE_TO_MINUTE = 0;
    public static final int SECOND_RELATIVE_TO_HOUR = 1;
    public static final int SECOND_RELATIVE_TO_DAY = 2;
    public static final int SECOND_RELATIVE_TO_EPOCH = 3;
    public static final int MINUTE_RELATIVE_TO_HOUR = 0;
    public static final int MINUTE_RELATIVE_TO_DAY = 1;
    public static final int MINUTE_RELATIVE_TO_EPOCH = 2;
    public static final int HOUR_RELATIVE_TO_DAY = 0;
    public static final int HOUR_RELATIVE_TO_EPOCH = 1;
    public static final int DAY_RELATIVE_TO_WEEK = 0;
    public static final int DAY_RELATIVE_TO_MONTH = 1;
    public static final int DAY_RELATIVE_TO_YEAR = 2;
    public static final int DAY_RELATIVE_TO_EPOCH = 3;
    public static final int WEEK_RELATIVE_TO_MONTH = 0;
    public static final int WEEK_RELATIVE_TO_YEAR = 1;
    public static final int WEEK_RELATIVE_TO_EPOCH = 2;
    public static final int MONTH_RELATIVE_TO_QUARTER = 0;
    public static final int MONTH_RELATIVE_TO_YEAR = 1;
    public static final int MONTH_RELATIVE_TO_EPOCH = 2;
    public static final int QUARTER_RELATIVE_TO_YEAR = 0;
    public static final int QUARTER_RELATIVE_TO_EPOCH = 1;
    public static final int HALF_YEAR_RELATIVE_TO_YEAR = 0;
    public static final int HALF_YEAR_RELATIVE_TO_EPOCH = 1;
    public static final int YEAR_RELATIVE_TO_EPOCH = 0;
    public static final int YEAR_RELATIVE_TO_ERA = 1;
    public static final int[] RELATIVE_TO_DEFAULTS;
    public static final String PARAMETER_KEEP_OLD_ATTRIBUTE = "keep_old_attribute";
    Calendar calendar = null;

    static {
        int[] nArray = new int[10];
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[9] = 1;
        RELATIVE_TO_DEFAULTS = nArray;
    }

    public Date2Numerical(OperatorDescription description) {
        super(description);
    }

    private double extract(long milliseconds, int timeUnit, int relativeTo) {
        this.calendar.setTimeInMillis(milliseconds);
        switch (timeUnit) {
            case 0: {
                switch (relativeTo) {
                    case 0: {
                        return milliseconds % 1000L;
                    }
                    case 1: {
                        return milliseconds;
                    }
                }
                break;
            }
            case 1: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(13);
                    }
                    case 1: {
                        return this.calendar.get(12) * 60 + this.calendar.get(13);
                    }
                    case 2: {
                        return this.calendar.get(11) * 3600 + this.calendar.get(12) * 60 + this.calendar.get(13);
                    }
                    case 3: {
                        return milliseconds / 1000L;
                    }
                }
                break;
            }
            case 2: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(12);
                    }
                    case 1: {
                        return this.calendar.get(11) * 60 + this.calendar.get(12);
                    }
                    case 2: {
                        return milliseconds / 60000L;
                    }
                }
            }
            case 3: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(11);
                    }
                    case 1: {
                        return milliseconds / 3600000L;
                    }
                }
                break;
            }
            case 4: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(7);
                    }
                    case 1: {
                        return this.calendar.get(5);
                    }
                    case 2: {
                        return this.calendar.get(6);
                    }
                    case 3: {
                        return milliseconds / 86400000L;
                    }
                }
                break;
            }
            case 5: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(4);
                    }
                    case 1: {
                        return this.calendar.get(3);
                    }
                    case 2: {
                        return milliseconds / 604800000L;
                    }
                }
                break;
            }
            case 6: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) % 3 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) + 1;
                    }
                    case 2: {
                        return this.calendar.get(2) + 1 + (this.calendar.get(1) - 1970) * 12;
                    }
                }
                break;
            }
            case 7: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) / 3 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) / 3 + 1 + (this.calendar.get(1) - 1970) * 4;
                    }
                }
                break;
            }
            case 8: {
                switch (relativeTo) {
                    case 0: {
                        return this.calendar.get(2) / 6 + 1;
                    }
                    case 1: {
                        return this.calendar.get(2) / 6 + 1 + (this.calendar.get(1) - 1970) * 2;
                    }
                }
                break;
            }
            case 9: {
                switch (relativeTo) {
                    case 1: {
                        return this.calendar.get(1);
                    }
                    case 0: {
                        return this.calendar.get(1) - 1970;
                    }
                }
                break;
            }
        }
        return Double.NaN;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        int timeUnit = this.getParameterAsInt(PARAMETER_TIME_UNIT);
        int relativeTo = this.getParameterAsInt(PARAMETERS_RELATIVE_TO[timeUnit]);
        Attribute dateAttribute = exampleSet.getAttributes().get(attributeName);
        if (dateAttribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        Attribute newAttribute = AttributeFactory.createAttribute(3);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        this.calendar = Tools.getPreferredCalendar();
        for (Example example : exampleSet) {
            example.setValue(newAttribute, this.extract((long)example.getValue(dateAttribute), timeUnit, relativeTo));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(dateAttribute);
            newAttribute.setName(attributeName);
        } else {
            newAttribute.setName(String.valueOf(attributeName) + "_" + TIME_UNITS[timeUnit]);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The attribute which should be parsed.", false));
        types.add(new ParameterTypeCategory(PARAMETER_TIME_UNIT, "The unit in which the time is measured.", TIME_UNITS, 0));
        ParameterTypeCategory type = null;
        int i = 0;
        while (i < TIME_UNITS.length) {
            type = new ParameterTypeCategory(PARAMETERS_RELATIVE_TO[i], "The unit the value is extracted relativ to.", RELATIVE_TO_MODES[i], RELATIVE_TO_DEFAULTS[i]);
            type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_TIME_UNIT, true, i++));
            types.add(type);
        }
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_OLD_ATTRIBUTE, "Indicates if the original date attribute should be kept.", false));
        return types;
    }
}

