/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.test;

import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.test.RapidMinerTestCase;

public abstract class CriterionTestCase
extends RapidMinerTestCase {
    public void assertAllValuesEqual(String message, PerformanceCriterion expected, PerformanceCriterion actual) {
        message = String.valueOf(message) + " " + expected.getName();
        CriterionTestCase.assertEquals((String)(String.valueOf(message) + " value"), (double)expected.getMikroAverage(), (double)actual.getMikroAverage(), (double)1.0E-9);
        this.assertEqualsNaN(String.valueOf(message) + " variance", expected.getMikroVariance(), actual.getMikroVariance());
        this.assertEqualsNaN(String.valueOf(message) + " makro value", expected.getMakroAverage(), actual.getMakroAverage());
        this.assertEqualsNaN(String.valueOf(message) + " makro variance", expected.getMakroVariance(), actual.getMakroVariance());
        CriterionTestCase.assertEquals((String)(String.valueOf(message) + " name"), (String)expected.getName(), (String)actual.getName());
        CriterionTestCase.assertEquals((String)(String.valueOf(message) + " class"), expected.getClass(), actual.getClass());
    }

    public void cloneTest(String message, PerformanceCriterion pc) {
        try {
            this.assertAllValuesEqual(message, pc, (PerformanceCriterion)pc.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

