/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.operator.learner.rules.Rule;
import com.rapidminer.report.Readable;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleModel
extends SimplePredictionModel
implements Readable {
    private static final long serialVersionUID = 7792658268037025366L;
    private List<Rule> rules = new ArrayList<Rule>();

    public RuleModel(ExampleSet exampleSet) {
        super(exampleSet);
    }

    @Override
    public String getName() {
        return "RuleModel";
    }

    @Override
    public double predict(Example example) {
        for (Rule rule : this.rules) {
            if (!rule.coversExample(example)) continue;
            double[] confidences = rule.getConfidences();
            int index = 0;
            while (index < confidences.length) {
                example.setConfidence(this.getLabel().getMapping().mapIndex(index), confidences[index]);
                ++index;
            }
            return this.getLabel().getMapping().getIndex(rule.getLabel());
        }
        return Double.NaN;
    }

    public double getPrediction(Example example) {
        for (Rule rule : this.rules) {
            if (!rule.coversExample(example)) continue;
            double label = this.getLabel().getMapping().getIndex(rule.getLabel());
            return label;
        }
        return Double.NaN;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addRules(Collection<Rule> newRules) {
        this.rules.addAll(newRules);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int correct = 0;
        int wrong = 0;
        for (Rule rule : this.rules) {
            buffer.append(rule.toString());
            buffer.append(Tools.getLineSeparator());
            int label = this.getLabel().getMapping().getIndex(rule.getLabel());
            int[] frequencies = rule.getFrequencies();
            if (frequencies == null) continue;
            int i = 0;
            while (i < frequencies.length) {
                if (i == label) {
                    correct += frequencies[i];
                } else {
                    wrong += frequencies[i];
                }
                ++i;
            }
        }
        buffer.append(Tools.getLineSeparator());
        buffer.append("correct: " + correct + " out of " + (correct + wrong) + " training examples.");
        return buffer.toString();
    }

    public int getNumberOfReadables() {
        return 1;
    }

    public Readable getReadable(int index) {
        return this;
    }
}

