/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.HeaderExampleSet;
import com.rapidminer.example.set.RemappedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;

public abstract class PredictionModel
extends AbstractModel {
    private static final long serialVersionUID = 6295359038239089617L;

    protected PredictionModel(ExampleSet trainingExampleSet) {
        super(trainingExampleSet);
    }

    public abstract ExampleSet performPrediction(ExampleSet var1, Attribute var2) throws OperatorException;

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        RemappedExampleSet mappedExampleSet = new RemappedExampleSet(exampleSet, this.getTrainingHeader());
        this.checkCompatibility(mappedExampleSet);
        Attribute predictedLabel = PredictionModel.createPredictedLabel(mappedExampleSet, this.getLabel());
        ExampleSet result = this.performPrediction(mappedExampleSet, predictedLabel);
        PredictionModel.copyPredictedLabel(result, exampleSet);
        return exampleSet;
    }

    public Attribute getLabel() {
        return this.getTrainingHeader().getAttributes().getLabel();
    }

    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        HeaderExampleSet trainingHeaderSet = this.getTrainingHeader();
        if (exampleSet.getAttributes().size() != trainingHeaderSet.getAttributes().size()) {
            this.logWarning("The number of regular attributes of the given example set does not fit the number of attributes of the training example set, training: " + trainingHeaderSet.getAttributes().size() + ", application: " + exampleSet.getAttributes().size());
        } else {
            Iterator<Attribute> trainingIt = trainingHeaderSet.getAttributes().iterator();
            Iterator<Attribute> applyIt = exampleSet.getAttributes().iterator();
            while (trainingIt.hasNext() && applyIt.hasNext()) {
                if (trainingIt.next().getName().equals(applyIt.next().getName())) continue;
                this.logWarning("The order of attributes is not equal for the training and the application example set. This might lead to problems for some models.");
                break;
            }
        }
        block1: for (Attribute trainingAttribute : trainingHeaderSet.getAttributes()) {
            String name = trainingAttribute.getName();
            Attribute attribute = exampleSet.getAttributes().getRegular(name);
            if (attribute == null) {
                this.logWarning("The given example set does not contain a regular attribute with name '" + name + "'. This might cause problems for some models depending on this particular attribute.");
                continue;
            }
            if (trainingAttribute.getValueType() != attribute.getValueType()) {
                this.logWarning("The value types between training and application differ for attribute '" + name + "', training: " + Ontology.VALUE_TYPE_NAMES[trainingAttribute.getValueType()] + ", application: " + Ontology.VALUE_TYPE_NAMES[attribute.getValueType()]);
                continue;
            }
            if (!trainingAttribute.isNominal()) continue;
            if (trainingAttribute.getMapping().size() != attribute.getMapping().size()) {
                this.logWarning("The number of nominal values is not the same for training and application for attribute '" + name + "', training: " + trainingAttribute.getMapping().size() + ", application: " + attribute.getMapping().size());
                continue;
            }
            for (String v : trainingAttribute.getMapping().getValues()) {
                int applicationIndex;
                int trainingIndex = trainingAttribute.getMapping().getIndex(v);
                if (trainingIndex == (applicationIndex = attribute.getMapping().getIndex(v))) continue;
                this.logWarning("The internal nominal mappings are not the same between training and application for attribute '" + name + "'. This will probably lead to wrong results during model application.");
                continue block1;
            }
        }
    }

    public static Attribute createPredictedLabel(ExampleSet exampleSet, Attribute label) {
        Attribute predictedLabel = AttributeFactory.createAttribute(label, "prediction");
        predictedLabel.clearTransformations();
        ExampleTable table = exampleSet.getExampleTable();
        table.addAttribute(predictedLabel);
        exampleSet.getAttributes().setPredictedLabel(predictedLabel);
        if (label.isNominal()) {
            for (String value : predictedLabel.getMapping().getValues()) {
                Attribute confidence = AttributeFactory.createAttribute("confidence(" + value + ")", 4);
                table.addAttribute(confidence);
                exampleSet.getAttributes().setSpecialAttribute(confidence, "confidence_" + value);
            }
        }
        return predictedLabel;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (prediction model for label " + this.getTrainingHeader().getAttributes().getLabel().getName() + ")";
    }

    public static void removePredictedLabel(ExampleSet exampleSet) {
        PredictionModel.removePredictedLabel(exampleSet, true, true);
    }

    public static void removePredictedLabel(ExampleSet exampleSet, boolean removePredictionFromTable, boolean removeConfidencesFromTable) {
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel != null) {
            if (predictedLabel.isNominal()) {
                for (String value : predictedLabel.getMapping().getValues()) {
                    Attribute currentConfidenceAttribute = exampleSet.getAttributes().getSpecial("confidence_" + value);
                    if (currentConfidenceAttribute == null) continue;
                    exampleSet.getAttributes().remove(currentConfidenceAttribute);
                    if (!removeConfidencesFromTable) continue;
                    exampleSet.getExampleTable().removeAttribute(currentConfidenceAttribute);
                }
            }
            exampleSet.getAttributes().remove(predictedLabel);
            if (removePredictionFromTable) {
                exampleSet.getExampleTable().removeAttribute(predictedLabel);
            }
        }
    }

    public static void copyPredictedLabel(ExampleSet source, ExampleSet destination) {
        Attribute costs;
        Attribute predictedLabel = source.getAttributes().getPredictedLabel();
        if (predictedLabel != null) {
            PredictionModel.removePredictedLabel(destination, true, true);
            if (predictedLabel.isNominal()) {
                for (String value : predictedLabel.getMapping().getValues()) {
                    Attribute currentConfidenceAttribute = source.getAttributes().getSpecial("confidence_" + value);
                    if (currentConfidenceAttribute == null) continue;
                    destination.getAttributes().setSpecialAttribute(currentConfidenceAttribute, "confidence_" + value);
                }
            }
            destination.getAttributes().setPredictedLabel(predictedLabel);
        }
        if ((costs = source.getAttributes().getCost()) != null) {
            destination.getAttributes().setSpecialAttribute(costs, "cost");
        }
    }
}

