/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusBasedFeatureWeighting
extends AbstractWeighting {
    private static final String PARAMETER_CLASS_TO_CHARACTERIZE = "class_to_characterize";

    public CorpusBasedFeatureWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet es) throws OperatorException {
        String targetValue = this.getParameterAsString(PARAMETER_CLASS_TO_CHARACTERIZE);
        double[] weights = this.generateWeightsForClass(es, targetValue);
        double maxWeight = Double.NEGATIVE_INFINITY;
        double[] dArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            maxWeight = Math.max(maxWeight, w);
            ++n2;
        }
        AttributeWeights attWeights = new AttributeWeights();
        int i = 0;
        for (Attribute attribute : es.getAttributes()) {
            if (maxWeight > 0.0) {
                attWeights.setWeight(attribute.getName(), 1.0 - weights[i++] / maxWeight);
                continue;
            }
            attWeights.setWeight(attribute.getName(), 0.0);
        }
        return attWeights;
    }

    private double[] generateWeightsForClass(ExampleSet es, String value) {
        double[] result = new double[es.getAttributes().size()];
        int i = 0;
        while (i < es.getAttributes().size()) {
            result[i] = 0.0;
            ++i;
        }
        Iterator er = es.iterator();
        Attribute labelAttribute = es.getAttributes().getLabel();
        while (er.hasNext()) {
            Example e = (Example)er.next();
            if (!e.getValueAsString(labelAttribute).equalsIgnoreCase(value)) continue;
            int index = 0;
            for (Attribute attribute : es.getAttributes()) {
                int n = index++;
                result[n] = result[n] + e.getValue(attribute);
            }
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_CLASS_TO_CHARACTERIZE, "The target class for which to find characteristic feature weights.", false));
        return types;
    }
}

