/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements BreakpointListener,
ProcessListener {
    private static final String INACTIVE_ICON_NAME = "24/bullet_ball_glass_grey.png";
    private static final String RUNNING_ICON_NAME = "24/bullet_ball_glass_green.png";
    private static final String STOPPED_ICON_NAME = "24/bullet_ball_glass_red.png";
    private static final String PENDING_ICON_NAME = "24/bullet_ball_glass_yellow.png";
    private static Icon inactiveIcon = null;
    private static Icon runningIcon = null;
    private static Icon stoppedIcon = null;
    private static Icon pendingIcon = null;
    public static final int TRAFFIC_LIGHT_INACTIVE = 0;
    public static final int TRAFFIC_LIGHT_RUNNING = 1;
    public static final int TRAFFIC_LIGHT_STOPPED = 2;
    public static final int TRAFFIC_LIGHT_PENDING = 3;
    private static final long serialVersionUID = 1189363377612273467L;
    private JLabel clockLabel = StatusBar.createLabel(StatusBar.getTime(), true);
    private JLabel operatorLabel = StatusBar.createLabel("                         ", false);
    private OperatorEntry rootOperator = null;
    private JLabel trafficLightLabel = new JLabel();
    private int breakpoint = -1;
    private String specialText = null;

    static {
        inactiveIcon = SwingTools.createIcon(INACTIVE_ICON_NAME);
        runningIcon = SwingTools.createIcon(RUNNING_ICON_NAME);
        stoppedIcon = SwingTools.createIcon(STOPPED_ICON_NAME);
        pendingIcon = SwingTools.createIcon(PENDING_ICON_NAME);
    }

    public StatusBar() {
        this(true, true);
    }

    public StatusBar(boolean showClock, boolean showTrafficLight) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        if (showTrafficLight) {
            this.trafficLightLabel.setIcon(inactiveIcon);
            this.trafficLightLabel.setToolTipText("Indicates the current running state.");
            constraints.weightx = 0.0;
            layout.setConstraints(this.trafficLightLabel, constraints);
            this.add(this.trafficLightLabel);
        }
        constraints.weightx = 1.0;
        constraints.gridwidth = -1;
        layout.setConstraints(this.operatorLabel, constraints);
        this.add(this.operatorLabel);
        if (showClock) {
            this.clockLabel.setToolTipText("The current system time.");
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            layout.setConstraints(this.clockLabel, constraints);
            this.add(this.clockLabel);
        }
    }

    public void startClockThread() {
        new Thread("StatusBar-Thread"){
            {
                this.setDaemon(true);
            }

            public void run() {
                this.setPriority(1);
                while (true) {
                    try {
                        while (true) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    StatusBar.this.clockLabel.setText(StatusBar.getTime());
                                    if (StatusBar.this.specialText != null) {
                                        StatusBar.this.setText(StatusBar.this.specialText);
                                    } else {
                                        StatusBar.this.setText();
                                    }
                                }
                            });
                            1.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private static Border createBorder() {
        return new Border(){

            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Color highlight = c.getBackground().brighter().brighter();
                Color shadow = c.getBackground().darker().darker();
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(shadow);
                g.drawLine(3, 0, 3, h - 2);
                g.drawLine(3, 0, w - 3, 0);
                g.setColor(highlight);
                g.drawLine(3, h - 2, w - 3, h - 2);
                g.drawLine(w - 3, 1, w - 3, h - 2);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(1, 4, 2, 3);
            }

            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    private static JLabel createLabel(String text, boolean border) {
        JLabel label = new JLabel(text);
        if (border) {
            label.setBorder(StatusBar.createBorder());
        }
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    private static String getTime() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public void breakpointReached(Process process, Operator op, IOContainer io, int location) {
        this.breakpoint = location;
        this.operatorLabel.setText("[" + op.getApplyCount() + "] " + op.getName() + ": breakpoint reached " + BreakpointListener.BREAKPOINT_POS_NAME[this.breakpoint] + " operator, press resume...");
        this.trafficLightLabel.setIcon(stoppedIcon);
    }

    public void resume() {
        this.breakpoint = -1;
        if (this.rootOperator != null) {
            this.setText();
        } else {
            this.operatorLabel.setText(" ");
        }
        this.trafficLightLabel.setIcon(runningIcon);
    }

    public void processStarts(Process process) {
        this.rootOperator = null;
        this.specialText = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.operatorLabel.setText("");
                StatusBar.this.trafficLightLabel.setIcon(runningIcon);
            }
        });
    }

    public void processStartedOperator(Process process, Operator op) {
        if (this.rootOperator == null) {
            this.rootOperator = new OperatorEntry(op);
        } else {
            this.rootOperator.addOperator(op);
        }
    }

    public void processFinishedOperator(Process process, Operator op) {
        if (this.rootOperator != null) {
            this.rootOperator.removeOperator(op);
        }
    }

    public void processEnded(Process process) {
        this.rootOperator = null;
        this.specialText = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.operatorLabel.setText("");
                StatusBar.this.trafficLightLabel.setIcon(inactiveIcon);
            }
        });
    }

    public void setTrafficLight(int trafficLightState) {
        switch (trafficLightState) {
            case 1: {
                this.trafficLightLabel.setIcon(runningIcon);
                break;
            }
            case 2: {
                this.trafficLightLabel.setIcon(stoppedIcon);
                break;
            }
            case 3: {
                this.trafficLightLabel.setIcon(pendingIcon);
                break;
            }
            default: {
                this.trafficLightLabel.setIcon(inactiveIcon);
            }
        }
    }

    public void setSpecialText(String specialText) {
        this.specialText = specialText;
        this.setText(this.specialText);
    }

    public void clearSpecialText() {
        this.specialText = null;
        this.setText("");
    }

    private synchronized void setText(String text) {
        this.operatorLabel.setText(text);
    }

    private void setText() {
        if (this.rootOperator != null) {
            this.setText(this.rootOperator.toString(this.rootOperator, System.currentTimeMillis()));
        } else {
            this.setText("");
        }
    }

    private static class OperatorEntry {
        private Collection<OperatorEntry> children = new LinkedList<OperatorEntry>();
        private Operator operator;

        public OperatorEntry(Operator operator) {
            this.operator = operator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOperator(Operator operator) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                if (this.operator == operator.getParent()) {
                    this.children.add(new OperatorEntry(operator));
                } else {
                    for (OperatorEntry childEntry : this.children) {
                        childEntry.addOperator(operator);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOperator(Operator operator) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                Iterator<OperatorEntry> iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    OperatorEntry childEntry = iterator.next();
                    if (childEntry.getOperator() == operator) {
                        iterator.remove();
                        continue;
                    }
                    childEntry.removeOperator(operator);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString(OperatorEntry entry, long time) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                StringBuffer buffer = new StringBuffer();
                Operator currentOperator = entry.getOperator();
                buffer.append("[" + currentOperator.getApplyCount() + "] " + currentOperator.getName() + "  " + Tools.formatDuation(time - currentOperator.getStartTime()));
                Iterator<OperatorEntry> iterator = this.children.iterator();
                if (iterator.hasNext()) {
                    buffer.append("  >  ");
                }
                while (iterator.hasNext()) {
                    OperatorEntry childEntry = iterator.next();
                    if (this.children.size() > 1) {
                        buffer.append("  ( ");
                    }
                    buffer.append(childEntry.toString(childEntry, time));
                    if (this.children.size() > 1) {
                        buffer.append(" )  ");
                    }
                    if (!iterator.hasNext()) continue;
                    buffer.append("  |  ");
                }
                return buffer.toString();
            }
        }

        public Operator getOperator() {
            return this.operator;
        }
    }
}

