/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class MultipleSeriesChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -8763693366081949249L;
    private transient DataTable dataTable;
    private int indexAxis = -1;
    private boolean[] columns;
    private ChartPanel panel = new ChartPanel(null);

    public MultipleSeriesChartPlotter() {
        this.setBackground(Color.white);
    }

    public MultipleSeriesChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        if (this.indexAxis >= 0 && !this.dataTable.isNominal(this.indexAxis)) {
            if (this.dataTable.isDate(this.indexAxis) || this.dataTable.isDateTime(this.indexAxis)) {
                DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.indexAxis));
                domainAxis.setTimeZone(Tools.getPreferredTimeZone());
                chart.getXYPlot().setDomainAxis((ValueAxis)domainAxis);
            }
        } else {
            plot.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits((Locale)Locale.US));
            ((NumberAxis)plot.getDomainAxis()).setAutoRangeStickyZero(false);
            ((NumberAxis)plot.getDomainAxis()).setAutoRangeIncludesZero(false);
        }
        ValueAxis xAxis = plot.getDomainAxis();
        xAxis.setAutoRange(true);
        xAxis.setLabelFont(LABEL_FONT_BOLD);
        xAxis.setTickLabelFont(LABEL_FONT);
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            int numberOfSelectedColumns = 0;
            int c = 0;
            while (c < this.dataTable.getNumberOfColumns()) {
                if (this.getPlotColumn(c) && this.dataTable.isNumerical(c)) {
                    ++numberOfSelectedColumns;
                }
                ++c;
            }
            int columnCount = 0;
            int c2 = 0;
            while (c2 < this.dataTable.getNumberOfColumns()) {
                if (this.getPlotColumn(c2) && this.dataTable.isNumerical(c2)) {
                    XYSeriesCollection dataset = new XYSeriesCollection();
                    XYSeries series = new XYSeries((Comparable)((Object)this.dataTable.getColumnName(c2)));
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    int index = 1;
                    while (i.hasNext()) {
                        DataTableRow row = i.next();
                        double value = row.getValue(c2);
                        if (this.indexAxis >= 0 && !this.dataTable.isNominal(this.indexAxis)) {
                            double indexValue = row.getValue(this.indexAxis);
                            series.add(indexValue, value);
                            continue;
                        }
                        series.add((double)index++, value);
                    }
                    dataset.addSeries(series);
                    XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
                    Color color = this.getColorProvider().getPointColor(1.0);
                    if (numberOfSelectedColumns > 1) {
                        color = this.getColorProvider().getPointColor((double)columnCount / (double)(numberOfSelectedColumns - 1));
                    }
                    renderer.setSeriesPaint(0, (Paint)color);
                    renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f, 1, 1));
                    renderer.setSeriesShapesVisible(0, false);
                    NumberAxis yAxis = new NumberAxis(this.dataTable.getColumnName(c2));
                    yAxis.setAutoRange(true);
                    yAxis.setAutoRangeStickyZero(false);
                    yAxis.setAutoRangeIncludesZero(false);
                    yAxis.setLabelFont(LABEL_FONT_BOLD);
                    yAxis.setTickLabelFont(LABEL_FONT);
                    if (numberOfSelectedColumns > 1) {
                        yAxis.setAxisLinePaint((Paint)color);
                        yAxis.setTickMarkPaint((Paint)color);
                        yAxis.setLabelPaint((Paint)color);
                        yAxis.setTickLabelPaint((Paint)color);
                    }
                    plot.setRangeAxis(columnCount, (ValueAxis)yAxis);
                    plot.setRangeAxisLocation(columnCount, AxisLocation.TOP_OR_LEFT);
                    plot.setDataset(columnCount, (XYDataset)dataset);
                    plot.setRenderer(columnCount, (XYItemRenderer)renderer);
                    plot.mapDatasetToRangeAxis(columnCount, columnCount);
                    ++columnCount;
                }
                ++c2;
            }
        }
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
        this.updatePlotter();
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public void setPlotColumn(int index, boolean plot) {
        if (index >= 0 && index < this.columns.length) {
            this.columns[index] = plot;
        }
        this.updatePlotter();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public String getPlotName() {
        return "Plot Series";
    }

    public int getNumberOfAxes() {
        return 1;
    }

    public String getAxisName(int index) {
        if (index == 0) {
            return "Index Dimension";
        }
        return "none";
    }

    public int getAxis(int index) {
        if (index == 0) {
            return this.indexAxis;
        }
        return -1;
    }

    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.indexAxis = dimension;
            this.updatePlotter();
        }
    }

    public JComponent getPlotter() {
        return this.panel;
    }

    private void updatePlotter() {
        JFreeChart chart = this.createChart();
        if (this.panel instanceof CtrlChartPanel) {
            this.panel.setChart(chart);
        } else {
            this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
            ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
            this.panel.addMouseListener((MouseListener)controller);
            this.panel.addMouseMotionListener((MouseMotionListener)controller);
        }
        this.panel.getChartRenderingInfo().setEntityCollection(null);
    }
}

