/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.ConditionalAction;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.NewBuildingBlockDialog;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UnknownParameterInformation;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class NewBuildingBlockAction
extends ConditionalAction {
    private static final long serialVersionUID = 3466426013029085115L;
    private static final String ICON_NAME = "box_new.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private OperatorTree operatorTree;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            NewBuildingBlockAction.ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + ICON_NAME);
            ++n2;
        }
    }

    public NewBuildingBlockAction(OperatorTree operatorTree, IconSize size) {
        super("New BB...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Insert a new building block");
        this.putValue("MnemonicKey", 66);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        this.setCondition(0, 1);
        this.operatorTree = operatorTree;
    }

    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.operatorTree.getSelectedOperator();
        if (selectedOperator != null) {
            NewBuildingBlockDialog dialog = new NewBuildingBlockDialog(RapidMinerGUI.getMainFrame());
            dialog.setVisible(true);
            if (dialog.isOk()) {
                try {
                    BuildingBlock buildingBlock = dialog.getSelectedBuildingBlock();
                    if (buildingBlock != null) {
                        String xmlDescription = buildingBlock.getXML();
                        try {
                            InputSource source = new InputSource(new StringReader(xmlDescription));
                            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                            Element element = document.getDocumentElement();
                            Operator operator = Operator.createFromXML(element, new LinkedList<UnknownParameterInformation>());
                            RapidMinerGUI.getMainFrame().getOperatorTree().insert(operator);
                        }
                        catch (Exception ex) {
                            SwingTools.showSimpleErrorMessage("Cannot instantiate building block '" + buildingBlock.getName() + "'.", ex);
                        }
                    }
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage("Cannot create building block:", ex);
                }
            }
        }
    }
}

