/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.tools.LogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryExampleTable
extends AbstractExampleTable {
    private static final long serialVersionUID = -3000023475208774934L;
    private List<DataRow> dataList = new ArrayList<DataRow>();
    private int columns;
    private static final int INCREMENT = 10;

    public MemoryExampleTable(List<Attribute> attributes) {
        super(attributes);
        this.columns = attributes.size();
    }

    public MemoryExampleTable(List<Attribute> attributes, DataRowFactory factory, int size) {
        this(attributes);
        this.dataList = new ArrayList<DataRow>(size);
        int i = 0;
        while (i < size) {
            DataRow dataRow = factory.create(attributes.size());
            for (Attribute attribute : attributes) {
                dataRow.set(attribute, Double.NaN);
            }
            this.dataList.add(dataRow);
            ++i;
        }
    }

    public MemoryExampleTable(List<Attribute> attributes, DataRowReader i) {
        this(attributes, i, false);
    }

    public MemoryExampleTable(List<Attribute> attributes, DataRowReader i, boolean permutate) {
        this(attributes);
        this.readExamples(i, permutate);
    }

    public void readExamples(DataRowReader i) {
        this.readExamples(i, false);
    }

    public void readExamples(DataRowReader i, boolean permutate) {
        this.readExamples(i, false, null);
    }

    public void readExamples(DataRowReader i, boolean permutate, Random random) {
        this.dataList.clear();
        while (i.hasNext()) {
            if (permutate) {
                int index = random.nextInt(this.dataList.size() + 1);
                this.dataList.add(index, (DataRow)i.next());
                continue;
            }
            this.dataList.add((DataRow)i.next());
        }
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new ListDataRowReader(this.dataList.iterator());
    }

    @Override
    public DataRow getDataRow(int index) {
        return this.dataList.get(index);
    }

    @Override
    public int size() {
        return this.dataList.size();
    }

    public void addDataRow(DataRow dataRow) {
        this.dataList.add(dataRow);
    }

    public boolean removeDataRow(DataRow dataRow) {
        return this.dataList.remove(dataRow);
    }

    public DataRow removeDataRow(int index) {
        return this.dataList.remove(index);
    }

    public void clear() {
        this.dataList.clear();
    }

    @Override
    public void addAttributes(Collection<Attribute> newAttributes) {
        Iterator<Serializable> i;
        if (this.dataList != null && this.getNumberOfAttributes() + newAttributes.size() > this.columns) {
            this.columns = this.getNumberOfAttributes() + newAttributes.size();
            i = this.dataList.iterator();
            while (i.hasNext()) {
                ((DataRow)i.next()).ensureNumberOfColumns(this.columns);
            }
        }
        i = newAttributes.iterator();
        while (i.hasNext()) {
            this.addAttribute(i.next());
        }
    }

    @Override
    public synchronized int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.dataList == null) {
            return index;
        }
        int n = this.getNumberOfAttributes();
        if (n <= this.columns) {
            return index;
        }
        int newSize = n + 10;
        LogService.getGlobal().log("Resizing example table from " + this.columns + " to " + newSize + " columns.", 2);
        this.columns = newSize;
        if (this.dataList != null) {
            Iterator<DataRow> i = this.dataList.iterator();
            while (i.hasNext()) {
                i.next().ensureNumberOfColumns(this.columns);
            }
        }
        return index;
    }

    public static MemoryExampleTable createCompleteCopy(ExampleTable oldTable) {
        MemoryExampleTable table = new MemoryExampleTable(Arrays.asList(oldTable.getAttributes()));
        DataRowReader reader = oldTable.getDataRowReader();
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            double[] newDataRowData = new double[oldTable.getNumberOfAttributes()];
            int a = 0;
            while (a < oldTable.getNumberOfAttributes()) {
                Attribute attribute = oldTable.getAttribute(a);
                newDataRowData[a] = attribute != null ? dataRow.get(attribute) : Double.NaN;
                ++a;
            }
            table.addDataRow(new DoubleArrayDataRow(newDataRowData));
        }
        return table;
    }
}

