/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Statistics;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataViewer;
import com.rapidminer.gui.viewer.MetaDataViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleSet
extends ResultObjectAdapter
implements ExampleSet {
    private static final long serialVersionUID = 8596141056047402798L;
    private static final String RESULT_ICON_NAME = "data.png";
    private static Icon resultIcon = null;
    private Map<String, List<Statistics>> statisticsMap = new HashMap<String, List<Statistics>>();
    private Map<Double, int[]> idMap = new HashMap<Double, int[]>();

    static {
        resultIcon = SwingTools.createIcon("16/data.png");
    }

    @Override
    public String getName() {
        return "ExampleSet";
    }

    @Override
    public Example getExampleFromId(double id) {
        int[] indices = this.idMap.get(id);
        if (indices != null && indices.length > 0) {
            return this.getExample(indices[0]);
        }
        return null;
    }

    @Override
    public int[] getExampleIndicesFromId(double id) {
        return this.idMap.get(id);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(String.valueOf(Tools.classNameWOPackage(this.getClass())) + ":" + Tools.getLineSeparator());
        str.append(String.valueOf(this.size()) + " examples," + Tools.getLineSeparator());
        str.append(String.valueOf(this.getAttributes().size()) + " regular attributes," + Tools.getLineSeparator());
        boolean first = true;
        Iterator<AttributeRole> s = this.getAttributes().specialAttributes();
        while (s.hasNext()) {
            if (first) {
                str.append("special attributes = {" + Tools.getLineSeparator());
                first = false;
            }
            AttributeRole special = s.next();
            str.append("    " + special.getSpecialName() + " = " + special.getAttribute() + Tools.getLineSeparator());
        }
        if (!first) {
            str.append("}");
        } else {
            str.append("no special attributes" + Tools.getLineSeparator());
        }
        return str.toString();
    }

    public DataTable createDataTable(IOContainer container) {
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : this.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException missingIOObjectException) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(this, weights);
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        return this.getVisualizationComponent(container, true);
    }

    public Component getVisualizationComponent(IOContainer container, boolean showOptions) {
        JPanel borderPanel = new JPanel(new BorderLayout());
        MetaDataViewer metaDataViewer = new MetaDataViewer(this, showOptions);
        DataViewer dataViewer = new DataViewer(this, showOptions);
        DataTable dataTable = this.createDataTable(container);
        PlotterPanel plotterComponent = new PlotterPanel(dataTable);
        final CardLayout cardLayout = new CardLayout();
        final JPanel mainPanel = new JPanel(cardLayout);
        String metaString = "META";
        String dataString = "DATA";
        String plotString = "PLOT";
        mainPanel.add((Component)metaDataViewer, "META");
        mainPanel.add((Component)dataViewer, "DATA");
        mainPanel.add((Component)plotterComponent, "PLOT");
        final JRadioButton metaDataButton = new JRadioButton("Meta Data View", true);
        metaDataButton.setToolTipText("Changes to a table showing information about all attributes.");
        metaDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (metaDataButton.isSelected()) {
                    cardLayout.show(mainPanel, "META");
                }
            }
        });
        final JRadioButton dataButton = new JRadioButton("Data View", true);
        dataButton.setToolTipText("Changes to a table showing the complete example set.");
        dataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dataButton.isSelected()) {
                    cardLayout.show(mainPanel, "DATA");
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("Plot View", false);
        plotButton.setToolTipText("Changes to a plot view of the example data.");
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    cardLayout.show(mainPanel, "PLOT");
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(metaDataButton);
        group.add(dataButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(metaDataButton);
        togglePanel.add(dataButton);
        togglePanel.add(plotButton);
        borderPanel.add((Component)togglePanel, "North");
        borderPanel.add((Component)mainPanel, "Center");
        return borderPanel;
    }

    @Override
    public Icon getResultIcon() {
        return resultIcon;
    }

    @Override
    public List<Action> getActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add(new AbstractAction("Save..."){
            private static final long serialVersionUID = 763183727596275786L;

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "In the following, you can save both a data file and an attribute description file.", "Save data and meta data", 1);
                File dataFile = SwingTools.chooseFile(null, null, false, "dat", "example set data file");
                try {
                    if (dataFile != null) {
                        Charset encoding = RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getEncoding();
                        AbstractExampleSet.this.writeDataFile(dataFile, -2, true, false, false, encoding);
                        File attFile = SwingTools.chooseFile(null, dataFile, false, "aml", "attribute description file");
                        if (attFile != null) {
                            AbstractExampleSet.this.writeAttributeFile(attFile, dataFile, encoding);
                        }
                    }
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage("Cannot write example set to file '" + dataFile + "'", ex);
                }
            }
        });
        return result;
    }

    @Override
    public void writeDataFile(File dataFile, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws IOException {
        PrintWriter out = null;
        OutputStream outStream = null;
        try {
            outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            out = new PrintWriter(new OutputStreamWriter(outStream, encoding));
            Iterator reader = this.iterator();
            while (reader.hasNext()) {
                out.println(((Example)reader.next()).toDenseString(fractionDigits, quoteNominal));
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    @Override
    public void writeSparseDataFile(File dataFile, int format, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws IOException {
        PrintWriter out = null;
        OutputStream outStream = null;
        try {
            outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            out = new PrintWriter(new OutputStreamWriter(outStream, encoding));
            Iterator reader = this.iterator();
            while (reader.hasNext()) {
                out.println(((Example)reader.next()).toSparseString(format, fractionDigits, quoteNominal));
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    @Override
    public void writeAttributeFile(File attFile, File dataFile, Charset encoding) throws IOException {
        if (dataFile == null) {
            throw new IOException("ExampleSet writing: cannot determine path to data file: data file was not given!");
        }
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        PrintWriter aout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
        aout.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        aout.println("<attributeset default_source=\"" + relativePath + "\">" + Tools.getLineSeparator());
        int sourcecol = 1;
        Iterator<AttributeRole> i = this.getAttributes().allAttributeRoles();
        while (i.hasNext()) {
            if (sourcecol != 1) {
                aout.println();
            }
            this.writeAttributeMetaData(i.next(), sourcecol, aout, false);
            ++sourcecol;
        }
        aout.println(String.valueOf(Tools.getLineSeparator()) + "</attributeset>");
        aout.close();
    }

    @Override
    public void writeSparseAttributeFile(File attFile, File dataFile, int format, Charset encoding) throws IOException {
        AttributeRole weightRole;
        AttributeRole idRole;
        if (dataFile == null) {
            throw new IOException("ExampleSet sparse writing: cannot determine path to data file: data file was not given!");
        }
        PrintWriter aout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        aout.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        aout.println("<attributeset default_source=\"" + relativePath + "\">");
        AttributeRole labelRole = this.getAttributes().getRole("label");
        if (labelRole != null && format != 4) {
            this.writeAttributeMetaData(labelRole, 0, aout, true);
        }
        if ((idRole = this.getAttributes().getRole("id")) != null) {
            this.writeAttributeMetaData(idRole, 0, aout, true);
        }
        if ((weightRole = this.getAttributes().getRole("weight")) != null) {
            this.writeAttributeMetaData(weightRole, 0, aout, true);
        }
        int sourcecol = 1;
        for (Attribute attribute : this.getAttributes()) {
            this.writeAttributeMetaData("attribute", attribute, sourcecol, aout, true);
            ++sourcecol;
        }
        aout.println("</attributeset>");
        aout.close();
    }

    private void writeAttributeMetaData(AttributeRole attributeRole, int sourcecol, PrintWriter aout, boolean sparse) {
        String tag = "attribute";
        if (attributeRole.isSpecial()) {
            tag = attributeRole.getSpecialName();
        }
        Attribute attribute = attributeRole.getAttribute();
        this.writeAttributeMetaData(tag, attribute, sourcecol, aout, sparse);
    }

    private void writeAttributeMetaData(String tag, Attribute attribute, int sourcecol, PrintWriter aout, boolean sparse) {
        aout.println("  <" + Tools.escapeXML(tag));
        aout.println("    name         = \"" + Tools.escapeXML(attribute.getName()) + "\"");
        if (!sparse || tag.equals("attribute")) {
            aout.println("    sourcecol    = \"" + sourcecol + "\"");
        }
        aout.print("    valuetype    = \"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType()) + "\"");
        if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 1)) {
            aout.print(String.valueOf(Tools.getLineSeparator()) + "    blocktype  = \"" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType()) + "\"");
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1) && !tag.equals(Attributes.KNOWN_ATTRIBUTE_TYPES[2])) {
            aout.println(">");
            Iterator<String> i = attribute.getMapping().getValues().iterator();
            while (i.hasNext()) {
                aout.println("       <value>" + Tools.escapeXML(i.next()) + "</value>");
            }
            aout.println("  </" + Tools.escapeXML(tag) + ">");
        } else {
            aout.println("/>");
        }
    }

    @Override
    public String getExtension() {
        return "aml";
    }

    @Override
    public String getFileDescription() {
        return "attribute description file";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExampleSet)) {
            return false;
        }
        ExampleSet es = (ExampleSet)o;
        return this.getAttributes().equals(es.getAttributes());
    }

    @Override
    public int hashCode() {
        return this.getAttributes().hashCode();
    }

    @Override
    public IOObject copy() {
        return (IOObject)this.clone();
    }

    @Override
    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cloneConstructor = clazz.getConstructor(clazz);
            AbstractExampleSet result = (AbstractExampleSet)cloneConstructor.newInstance(this);
            result.idMap = this.idMap;
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot clone ExampleSet: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("'" + this.getClass().getName() + "' does not implement clone constructor!");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e + ". Target: " + e.getTargetException() + ". Cause: " + e.getCause() + ".");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e);
        }
    }

    @Override
    public void remapIds() {
        this.idMap = new HashMap<Double, int[]>();
        Attribute idAttribute = this.getAttributes().getSpecial("id");
        if (idAttribute != null) {
            int index = 0;
            for (Example example : this) {
                double value = example.getValue(idAttribute);
                if (!Double.isNaN(value)) {
                    if (this.idMap.containsKey(value)) {
                        int[] indices = this.idMap.get(value);
                        int[] newIndices = new int[indices.length + 1];
                        int i = 0;
                        while (i < indices.length) {
                            newIndices[i] = indices[i];
                            ++i;
                        }
                        newIndices[newIndices.length - 1] = index;
                        this.idMap.put(value, newIndices);
                    } else {
                        this.idMap.put(value, new int[]{index});
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public void recalculateAllAttributeStatistics() {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> a = this.getAttributes().allAttributes();
        while (a.hasNext()) {
            allAttributes.add(a.next());
        }
        this.recalculateAttributeStatistics(allAttributes);
    }

    @Override
    public void recalculateAttributeStatistics(Attribute attribute) {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        allAttributes.add(attribute);
        this.recalculateAttributeStatistics(allAttributes);
    }

    private void recalculateAttributeStatistics(List<Attribute> attributeList) {
        if (attributeList.size() == 0) {
            return;
        }
        for (Attribute attribute : attributeList) {
            Iterator<Statistics> stats = attribute.getAllStatistics();
            while (stats.hasNext()) {
                Statistics statistics = stats.next();
                statistics.startCounting(attribute);
            }
        }
        Attribute weightAttribute = this.getAttributes().getWeight();
        if (weightAttribute != null && !weightAttribute.isNumerical()) {
            weightAttribute = null;
        }
        for (Example example : this) {
            for (Attribute attribute : attributeList) {
                double value = example.getValue(attribute);
                double weight = 1.0;
                if (weightAttribute != null) {
                    weight = example.getValue(weightAttribute);
                }
                Iterator<Statistics> stats = attribute.getAllStatistics();
                while (stats.hasNext()) {
                    Statistics statistics = stats.next();
                    statistics.count(value, weight);
                }
            }
        }
        for (Attribute attribute : attributeList) {
            List<Statistics> statisticsList = this.statisticsMap.get(attribute.getName());
            if (statisticsList == null) {
                statisticsList = new LinkedList<Statistics>();
                this.statisticsMap.put(attribute.getName(), statisticsList);
            }
            statisticsList.clear();
            Iterator<Statistics> stats = attribute.getAllStatistics();
            while (stats.hasNext()) {
                Statistics statistics = (Statistics)stats.next().clone();
                statisticsList.add(statistics);
            }
        }
    }

    @Override
    public double getStatistics(Attribute attribute, String statisticsName) {
        return this.getStatistics(attribute, statisticsName, null);
    }

    @Override
    public double getStatistics(Attribute attribute, String statisticsName, String statisticsParameter) {
        List<Statistics> statisticsList = this.statisticsMap.get(attribute.getName());
        if (statisticsList == null) {
            return Double.NaN;
        }
        for (Statistics statistics : statisticsList) {
            if (!statistics.handleStatistics(statisticsName)) continue;
            return statistics.getStatistics(attribute, statisticsName, statisticsParameter);
        }
        return Double.NaN;
    }
}

