/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesWriter;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateActionHandler
extends ActionHandler {
    GenerateActionHandler() {
    }

    @Override
    public void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> args = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.OUT_SEQS, CommandLineArguments.Arguments.IN_HMM);
        CommandLineArguments.checkArgs(args);
        InputStream hmmStream = CommandLineArguments.Arguments.IN_HMM.getAsInputStream();
        InputStreamReader hmmFileReader = new InputStreamReader(hmmStream);
        OutputStream seqsStream = CommandLineArguments.Arguments.OUT_SEQS.getAsOutputStream();
        OutputStreamWriter seqsFileWriter = new OutputStreamWriter(seqsStream);
        this.write(hmmFileReader, seqsFileWriter, Types.relatedObjs());
        ((Writer)seqsFileWriter).flush();
    }

    private <O extends Observation> void write(Reader hmmFileReader, Writer seqsFileWriter, RelatedObjs<O> relatedObjs) throws IOException, FileFormatException {
        ObservationWriter<O> obsWriter = relatedObjs.observationWriter();
        OpdfReader<Opdf<O>> opdfReader = relatedObjs.opdfReader();
        Hmm<O> hmm = HmmReader.read(hmmFileReader, opdfReader);
        MarkovGenerator<O> generator = relatedObjs.generator(hmm);
        ArrayList<List<O>> seqs = new ArrayList<List<O>>();
        int i = 0;
        while (i < 100) {
            seqs.add(generator.observationSequence(1000));
            ++i;
        }
        ObservationSequencesWriter.write(seqsFileWriter, obsWriter, seqs);
    }
}

