/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.test;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.test.OperatorDataSampleTest;

public class ExampleSetDataSampleTest
extends OperatorDataSampleTest {
    private String attributeName;
    private double[] values;
    private String[] stringValues;
    private boolean isDouble;
    private int amount = -1;
    private boolean isAmount = false;

    public ExampleSetDataSampleTest(String file, String attributeName, double[] values) {
        super(file);
        this.attributeName = attributeName;
        this.values = values;
        this.isDouble = true;
    }

    public ExampleSetDataSampleTest(String file, String attributeName, String[] stringValues) {
        super(file);
        this.attributeName = attributeName;
        this.stringValues = stringValues;
        this.isDouble = false;
    }

    public ExampleSetDataSampleTest(String file, int amount) {
        super(file);
        this.amount = amount;
        this.isAmount = true;
    }

    public void checkOutput(IOContainer output) throws MissingIOObjectException {
        ExampleSet exampleSet = output.get(ExampleSet.class);
        int counter = 0;
        if (this.isAmount) {
            ExampleSetDataSampleTest.assertEquals((int)this.amount, (int)exampleSet.size());
        } else if (this.isDouble) {
            Attribute attribute = exampleSet.getAttributes().get(this.attributeName);
            ExampleSetDataSampleTest.assertNotNull((Object)attribute);
            double value = 0.0;
            int i = 0;
            while (i < this.values.length) {
                value = exampleSet.getExample(i).getValue(attribute);
                ExampleSetDataSampleTest.assertEquals((Object)value, (Object)this.values[counter++]);
                ++i;
            }
        } else {
            Attribute attribute = exampleSet.getAttributes().get(this.attributeName);
            ExampleSetDataSampleTest.assertNotNull((Object)attribute);
            String value = "";
            int i = 0;
            while (i < this.stringValues.length) {
                value = exampleSet.getExample(i).getValueAsString(attribute);
                ExampleSetDataSampleTest.assertEquals((String)value, (String)this.stringValues[counter++]);
                ++i;
            }
        }
    }
}

