/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.Series2WindowExamples;

public class UnivariateSeries2WindowExamples
extends Series2WindowExamples {
    public UnivariateSeries2WindowExamples(OperatorDescription description) {
        super(description);
    }

    public int[] getValueTypes(ExampleSet exampleSet, int representation, int windowWidth) {
        int[] valueTypes = new int[windowWidth];
        Attribute seriesAttribute = exampleSet.getAttributes().iterator().next();
        int valueType = seriesAttribute.getValueType();
        int i = 0;
        while (i < valueTypes.length) {
            valueTypes[i] = valueType;
            ++i;
        }
        return valueTypes;
    }

    public Attribute createLabel(ExampleSet exampleSet, int representation) throws OperatorException {
        if (representation == 0) {
            Attribute seriesAttribute = exampleSet.getAttributes().iterator().next();
            int valueType = seriesAttribute.getValueType();
            return AttributeFactory.createAttribute("label", valueType);
        }
        return null;
    }

    public void performChecks(ExampleSet exampleSet, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (representation == 0) {
            if (exampleSet.getAttributes().size() != 1) {
                throw new UserError((Operator)this, 133, 1, exampleSet.getAttributes().size());
            }
            if (exampleSet.size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 110, "window width + horizon = " + (windowWidth + horizon));
            }
        } else {
            if (exampleSet.size() != 1) {
                this.logWarning("The sliding windows will be applied on each example of the example set, if you intended to perform a multivariate series to examples transformation, please use the corresponding operator");
            }
            if (exampleSet.getAttributes().size() < windowWidth + horizon) {
                throw new UserError((Operator)this, 125, exampleSet.getAttributes().size(), windowWidth + horizon);
            }
            int valueType = -1;
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (valueType < 0) {
                    valueType = attribute.getValueType();
                    continue;
                }
                if (attribute.getValueType() == valueType) continue;
                throw new UserError(this, 126);
            }
        }
    }

    public String getNameForAttribute(Attribute[] originalAttributeArray, int representation, int windowWidth, int horizon, int totalCounter) {
        if (representation == 0) {
            String baseName = originalAttributeArray[0].getName();
            return String.valueOf(baseName) + "-" + (windowWidth - totalCounter);
        }
        return "Series_" + (windowWidth - totalCounter);
    }

    public void fillSeriesExampleTable(MemoryExampleTable table, ExampleSet exampleSet, Attribute idAttribute, int representation, int windowWidth, int stepSize, int horizon) throws OperatorException {
        if (representation == 0) {
            Attribute seriesAttribute = exampleSet.getAttributes().iterator().next();
            int idOffset = idAttribute == null ? 0 : 1;
            int w = 0;
            while (w < exampleSet.size() - windowWidth - horizon) {
                int index;
                Attribute newAttribute;
                double[] data = new double[windowWidth + 1 + idOffset];
                int d = 0;
                while (d < data.length - 1) {
                    newAttribute = table.getAttribute(d);
                    data[d] = newAttribute.isNominal() ? (double)newAttribute.getMapping().mapString(seriesAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + d).getValue(seriesAttribute))) : exampleSet.getExample(w + d).getValue(seriesAttribute);
                    ++d;
                }
                data[index] = idAttribute != null ? ((newAttribute = table.getAttribute(index = data.length - 2)).isNominal() ? (double)newAttribute.getMapping().mapString(seriesAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + windowWidth + horizon).getValue(seriesAttribute))) : exampleSet.getExample(w + windowWidth + horizon).getValue(seriesAttribute)) : ((newAttribute = table.getAttribute(index = data.length - 1)).isNominal() ? (double)newAttribute.getMapping().mapString(seriesAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + windowWidth + horizon).getValue(seriesAttribute))) : exampleSet.getExample(w + windowWidth + horizon).getValue(seriesAttribute));
                if (idAttribute != null) {
                    index = data.length - 1;
                    newAttribute = table.getAttribute(index);
                    data[index] = newAttribute.isNominal() ? (double)newAttribute.getMapping().mapString(idAttribute.getMapping().mapIndex((int)exampleSet.getExample(w + windowWidth).getValue(idAttribute))) : exampleSet.getExample(w + windowWidth).getValue(idAttribute);
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                this.checkForStop();
                w += stepSize;
            }
        } else {
            Attribute[] attributeArray = exampleSet.getAttributes().createRegularAttributeArray();
            int lastAttribute = exampleSet.getAttributes().size() - windowWidth - horizon;
            for (Example example : exampleSet) {
                int w = 0;
                while (w < lastAttribute) {
                    double[] data = new double[windowWidth + 1];
                    int d = 0;
                    while (d < data.length - 1) {
                        data[d] = example.getValue(attributeArray[w + d]);
                        ++d;
                    }
                    data[data.length - 1] = example.getValue(attributeArray[w + windowWidth + horizon]);
                    table.addDataRow(new DoubleArrayDataRow(data));
                    this.checkForStop();
                    w += stepSize;
                }
            }
        }
    }
}

