/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.AssociationRules;
import com.rapidminer.operator.learner.associations.Item;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationRuleTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4323147898914632476L;
    private static final String[] COLUMN_NAMES = new String[]{"No.", "Premises", "Conclusion", "Support", "Confidence", "LaPlace", "Gain", "p-s", "Lift", "Conviction"};
    private static final int COLUMN_RULE_ID = 0;
    private static final int COLUMN_PREMISES = 1;
    private static final int COLUMN_CONCLUSION = 2;
    private static final int COLUMN_SUPPORT = 3;
    private static final int COLUMN_CONFIDENCE = 4;
    private static final int COLUMN_LA_PLACE = 5;
    private static final int COLUMN_GAIN = 6;
    private static final int COLUMN_PS = 7;
    private static final int COLUMN_LIFT = 8;
    private static final int COLUMN_CONVICTION = 9;
    private AssociationRules rules;
    private int[] mapping = null;

    public AssociationRuleTableModel(AssociationRules rules) {
        this.rules = rules;
        this.createCompleteMapping();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column != 1 && column != 2) {
            if (column == 0) {
                return Integer.class;
            }
            return Double.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.mapping.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AssociationRule rule = this.rules.getRule(this.mapping[rowIndex]);
        switch (columnIndex) {
            case 0: {
                return this.mapping[rowIndex] + 1;
            }
            case 1: {
                return this.getItemString(rule.getPremiseItems());
            }
            case 2: {
                return this.getItemString(rule.getConclusionItems());
            }
            case 3: {
                return rule.getTotalSupport();
            }
            case 4: {
                return rule.getConfidence();
            }
            case 9: {
                return rule.getConviction();
            }
            case 6: {
                return rule.getGain();
            }
            case 7: {
                return rule.getPs();
            }
            case 8: {
                return rule.getLift();
            }
            case 5: {
                return rule.getLaplace();
            }
        }
        return "?";
    }

    private String getItemString(Iterator<Item> iterator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                result.append(", ");
            }
            Item item = iterator.next();
            result.append(item.toString());
            first = false;
        }
        return result.toString();
    }

    public void setFilter(boolean[] filter) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        while (i < filter.length) {
            if (filter[i]) {
                indices.add(i);
            }
            ++i;
        }
        this.mapping = new int[indices.size()];
        Iterator k = indices.iterator();
        int counter = 0;
        while (k.hasNext()) {
            this.mapping[counter++] = (Integer)k.next();
        }
        this.fireTableStructureChanged();
    }

    private void createCompleteMapping() {
        this.mapping = new int[this.rules.getNumberOfRules()];
        int i = 0;
        while (i < this.mapping.length) {
            this.mapping[i] = i;
            ++i;
        }
    }
}

