/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.ScaledRAFileHybrid;
import org.hsqldb.persist.ScaledRAFileInJar;
import org.hsqldb.persist.ScaledRAInterface;

final class ScaledRAFile
implements ScaledRAInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final long MAX_NIO_LENGTH = 0x10000000L;
    final Database database;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    boolean isNio;
    boolean bufferDirty = true;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    long bufferOffset;
    long fileLength;
    long seekPosition;
    long realPosition;
    int cacheHit;

    static Storage newScaledRAFile(Database database, String string, boolean bl, int n) throws FileNotFoundException, IOException {
        if (n == 3) {
            try {
                String string2 = database.getURLProperties().getProperty("storage_class_name");
                String string3 = database.getURLProperties().getProperty("storage_key");
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(String.class, Boolean.class, Object.class);
                return (Storage)constructor.newInstance(string, new Boolean(bl), string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException();
            }
        }
        if (n == 2) {
            return new ScaledRAFileInJar(string);
        }
        if (n == 0) {
            return new ScaledRAFile(database, string, bl);
        }
        File file = new File(string);
        long l = file.length();
        if (l > 0x10000000L) {
            return new ScaledRAFile(database, string, bl);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            return new ScaledRAFileHybrid(database, string, bl);
        }
        catch (Exception exception) {
            return new ScaledRAFile(database, string, bl);
        }
    }

    ScaledRAFile(Database database, String string, boolean bl) throws FileNotFoundException, IOException {
        this.database = database;
        this.readOnly = bl;
        this.fileName = string;
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        int n = 4096;
        this.buffer = new byte[n];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long l) throws IOException {
        if (!this.readOnly && this.fileLength < l) {
            long l2 = l - this.fileLength;
            if (l2 > 65536L) {
                l2 = 65536L;
            }
            byte[] byArray = new byte[(int)l2];
            try {
                long l3;
                for (l3 = this.fileLength; l3 < l - l2; l3 += l2) {
                    this.file.seek(l3);
                    this.file.write(byArray, 0, (int)l2);
                }
                this.file.seek(l3);
                this.file.write(byArray, 0, (int)(l - l3));
                this.realPosition = l;
                this.fileLength = l;
            }
            catch (IOException iOException) {
                this.database.logger.logWarningEvent("seek failed", iOException);
                throw iOException;
            }
        }
        this.seekPosition = l;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition;
        long l2 = l % (long)this.buffer.length;
        long l3 = this.fileLength - (l - l2);
        try {
            if (l3 <= 0L) {
                throw new IOException("read beyond end of file");
            }
            if (l3 > (long)this.buffer.length) {
                l3 = this.buffer.length;
            }
            if (this.realPosition != l - l2) {
                this.file.seek(l - l2);
            }
            this.file.readFully(this.buffer, 0, (int)l3);
            this.bufferOffset = l - l2;
            this.realPosition = this.bufferOffset + l3;
            this.bufferDirty = false;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent(" " + this.realPosition + " " + l3, iOException);
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.seekPosition >= this.fileLength) {
                return -1;
            }
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            this.ba.skip(this.seekPosition - this.bufferOffset);
            int n = this.ba.read();
            ++this.seekPosition;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("read failed", iOException);
            throw iOException;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            long l;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                l = this.ba.readLong();
            }
            catch (EOFException eOFException) {
                this.file.seek(this.seekPosition);
                l = this.file.readLong();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 8L;
            return l;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed ot read a Long", iOException);
            throw iOException;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            int n;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                n = this.ba.readInt();
            }
            catch (EOFException eOFException) {
                this.file.seek(this.seekPosition);
                n = this.file.readInt();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 4L;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to read an Int", iOException);
            throw iOException;
        }
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int n3 = this.ba.read(byArray, n, n2);
            this.seekPosition += (long)n3;
            if (n3 < n2) {
                if (this.seekPosition != this.realPosition) {
                    this.file.seek(this.seekPosition);
                }
                this.file.readFully(byArray, n + n3, n2 - n3);
                this.seekPosition += (long)(n2 - n3);
                this.realPosition = this.seekPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("faeild to read a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)n2 > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.write(byArray, n, n2);
            this.seekPosition += (long)n2;
            this.realPosition = this.seekPosition;
            if (this.realPosition > this.fileLength) {
                this.fileLength = this.realPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + 4L > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.writeInt(n);
            this.seekPosition += 4L;
            this.realPosition = this.seekPosition;
            if (this.realPosition > this.fileLength) {
                this.fileLength = this.realPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write an int", iOException);
            throw iOException;
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + 8L > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.writeLong(l);
            this.seekPosition += 8L;
            this.realPosition = this.seekPosition;
            if (this.realPosition > this.fileLength) {
                this.fileLength = this.realPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a Long", iOException);
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean wasNio() {
        return false;
    }

    @Override
    public boolean canAccess(int n) {
        return true;
    }

    @Override
    public boolean canSeek(long l) {
        return true;
    }

    @Override
    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetPointer() {
        try {
            this.bufferDirty = true;
            this.file.seek(this.seekPosition);
            this.realPosition = this.seekPosition;
            this.fileLength = this.length();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

