/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.util.Iterator;
import java.util.Properties;
import marytts.cart.DecisionNode;
import marytts.cart.DirectedGraphNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.NodeIterator;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.select.Target;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class DirectedGraph {
    protected Logger logger = MaryUtils.getLogger(this.getClass().getName());
    protected Node rootNode;
    protected FeatureDefinition featDef;
    protected Properties properties;

    public DirectedGraph() {
    }

    public DirectedGraph(FeatureDefinition featDef) {
        this(null, featDef);
    }

    public DirectedGraph(Node rootNode, FeatureDefinition featDef) {
        this(rootNode, featDef, null);
    }

    public DirectedGraph(Node rootNode, FeatureDefinition featDef, Properties properties) {
        this.rootNode = rootNode;
        this.featDef = featDef;
        this.properties = properties;
    }

    public Object interpret(Target t) {
        return this.interpret(t.getFeatureVector());
    }

    public Object interpret(FeatureVector fv) {
        return this.interpret(this.rootNode, fv);
    }

    protected Object interpret(Node n, FeatureVector fv) {
        if (n == null) {
            return null;
        }
        if (n.isLeafNode()) {
            return n.getAllData();
        }
        if (n.isDecisionNode()) {
            Node next = ((DecisionNode)n).getNextNode(fv);
            return this.interpret(next, fv);
        }
        if (n.isDirectedGraphNode()) {
            DirectedGraphNode g = (DirectedGraphNode)n;
            Object data = this.interpret(g.getDecisionNode(), fv);
            if (data != null) {
                return data;
            }
            return this.interpret(g.getLeafNode(), fv);
        }
        throw new IllegalArgumentException("Unknown node type: " + n.getClass());
    }

    public Iterator<Node> getNodeIterator() {
        return new NodeIterator<Node>(this, true, true, true);
    }

    public Iterator<LeafNode> getLeafNodeIterator() {
        return new NodeIterator<LeafNode>(this, true, false, false);
    }

    public Iterator<DecisionNode> getDecisionNodeIterator() {
        return new NodeIterator<DecisionNode>(this, false, true, false);
    }

    public Iterator<DirectedGraphNode> getDirectedGraphNodeIterator() {
        return new NodeIterator<DirectedGraphNode>(this, false, false, true);
    }

    public Iterable<Node> getNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return DirectedGraph.this.getNodeIterator();
            }
        };
    }

    public Iterable<LeafNode> getLeafNodes() {
        return new Iterable<LeafNode>(){

            @Override
            public Iterator<LeafNode> iterator() {
                return DirectedGraph.this.getLeafNodeIterator();
            }
        };
    }

    public Iterable<DecisionNode> getDecisionNodes() {
        return new Iterable<DecisionNode>(){

            @Override
            public Iterator<DecisionNode> iterator() {
                return DirectedGraph.this.getDecisionNodeIterator();
            }
        };
    }

    public Iterable<DirectedGraphNode> getDirectedGraphNodes() {
        return new Iterable<DirectedGraphNode>(){

            @Override
            public Iterator<DirectedGraphNode> iterator() {
                return DirectedGraph.this.getDirectedGraphNodeIterator();
            }
        };
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rNode) {
        this.rootNode = rNode;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featDef;
    }

    public int getNumNodes() {
        if (this.rootNode == null) {
            return 0;
        }
        return this.rootNode.getNumberOfNodes();
    }

    public String toString() {
        return this.rootNode.toString("");
    }
}

