/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.set.NoMissingAttributesCondition;
import com.rapidminer.operator.OperatorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class RankStatistics {
    public static double rho(ExampleSet eSet, Attribute a, Attribute b, double f) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        double[] ranka = RankStatistics.rank(e, a, null, f);
        double[] rankb = RankStatistics.rank(e, b, a, f);
        int nObs = ranka.length;
        double mu2 = (double)nObs * ((double)nObs + 1.0) * ((double)nObs + 1.0) / 4.0;
        double prod = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        int i = 0;
        while (i < nObs) {
            prod += ranka[i] * rankb[i];
            a2 += ranka[i] * ranka[i];
            b2 += rankb[i] * rankb[i];
            ++i;
        }
        double value = Math.sqrt((a2 - mu2) * (b2 - mu2));
        if (value != 0.0) {
            return (prod - mu2) / value;
        }
        return 0.0;
    }

    public static double rho(ExampleSet eSet, Attribute a, Attribute b) throws OperatorException {
        return RankStatistics.rho(eSet, a, b, 0.0);
    }

    public static double[] rank(ExampleSet eSet, Attribute att, Attribute mappingAtt, double fuzz) {
        TreeMap map;
        if (fuzz == 0.0) {
            map = new TreeMap();
        } else {
            FuzzyComp fc = new FuzzyComp(fuzz);
            map = new TreeMap(fc);
        }
        double[] rank = new double[eSet.size()];
        Iterator reader = eSet.iterator();
        int i = 0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            double x = e.getValue(att);
            if (att.isNominal() && mappingAtt != null) {
                String xString = att.getMapping().mapIndex((int)x);
                x = mappingAtt.getMapping().getIndex(xString);
            }
            if (Double.isNaN(x)) {
                rank[i++] = Double.NaN;
                continue;
            }
            if (!map.containsKey(x)) {
                map.put(x, new ArrayList());
            }
            ((ArrayList)map.get(x)).add(i++);
        }
        double r = 0.0;
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            double x = (Double)iterator.next();
            ArrayList y = (ArrayList)map.get(x);
            double v = r + (1.0 + (double)y.size()) / 2.0;
            Iterator iterator2 = y.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                rank[j] = v;
            }
            r += (double)y.size();
        }
        return rank;
    }

    public static double[] rank(ExampleSet eSet, Attribute att, Attribute mappingAtt) {
        return RankStatistics.rank(eSet, att, mappingAtt, 0.0);
    }

    private static ExampleSet extract(ExampleSet eSet, Attribute a, Attribute b) {
        ExampleSet e = (ExampleSet)eSet.clone();
        e.getAttributes().clearRegular();
        e.getAttributes().clearSpecial();
        e.getAttributes().addRegular(a);
        e.getAttributes().addRegular(b);
        return new ConditionedExampleSet(e, new NoMissingAttributesCondition(e, null));
    }

    public static double tau_b(ExampleSet eSet, Attribute a, Attribute b) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        long c = 0L;
        long d = 0L;
        long ta = 0L;
        long tb = 0L;
        long tc = 0L;
        int n = 0;
        for (Example z1 : e) {
            ++n;
            double x = z1.getValue(a);
            double y = z1.getValue(b);
            if (b.isNominal() && a != null) {
                String yString = b.getMapping().mapIndex((int)y);
                y = a.getMapping().getIndex(yString);
            }
            Iterator j = e.iterator();
            int k = 0;
            while (k < n) {
                j.next();
                ++k;
            }
            while (j.hasNext()) {
                Example z2 = (Example)j.next();
                double xx = z2.getValue(a);
                double yy = z2.getValue(b);
                if (b.isNominal() && a != null) {
                    String yyString = b.getMapping().mapIndex((int)yy);
                    yy = a.getMapping().getIndex(yyString);
                }
                if (x == xx) {
                    if (y == yy) {
                        ++tc;
                        continue;
                    }
                    ++ta;
                    continue;
                }
                if (y == yy) {
                    ++tb;
                    continue;
                }
                if (x > xx && y > yy || x < xx && y < yy) {
                    ++c;
                    continue;
                }
                ++d;
            }
        }
        double num = c - d;
        double f1 = c + d + ta;
        double f2 = c + d + tb;
        double den = Math.sqrt(f1 * f2);
        if (den != 0.0) {
            return num / den;
        }
        return 0.0;
    }

    public static double tau_b(ExampleSet eSet, Attribute a, Attribute b, double fuzz) throws OperatorException {
        ExampleSet e = RankStatistics.extract(eSet, a, b);
        FuzzyComp fc = new FuzzyComp(fuzz);
        int c = 0;
        int d = 0;
        int ta = 0;
        int tb = 0;
        int tc = 0;
        int n = 0;
        for (Example z1 : e) {
            ++n;
            double x = z1.getValue(a);
            double y = z1.getValue(b);
            if (b.isNominal() && a != null) {
                String yString = b.getMapping().mapIndex((int)y);
                y = a.getMapping().getIndex(yString);
            }
            Iterator j = e.iterator();
            int k = 0;
            while (k < n) {
                j.next();
                ++k;
            }
            while (j.hasNext()) {
                Example z2 = (Example)j.next();
                double xx = z2.getValue(a);
                double yy = z2.getValue(b);
                if (b.isNominal() && a != null) {
                    String yyString = b.getMapping().mapIndex((int)yy);
                    yy = a.getMapping().getIndex(yyString);
                }
                int xc = fc.compare(x, xx);
                int yc = fc.compare(y, yy);
                if (xc == 0) {
                    if (yc == 0) {
                        ++tc;
                        continue;
                    }
                    ++ta;
                    continue;
                }
                if (yc == 0) {
                    ++tb;
                    continue;
                }
                if (xc == yc) {
                    ++c;
                    continue;
                }
                ++d;
            }
        }
        double num = c - d;
        double den = Math.sqrt((c + d + ta) * (c + d + tb));
        if (den != 0.0) {
            return num / den;
        }
        return 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FuzzyComp
    implements Comparator<Double>,
    Serializable {
        private static final long serialVersionUID = -7752907616633799595L;
        private double fuzz;

        FuzzyComp(double f) {
            this.fuzz = Math.abs(f);
        }

        @Override
        public int compare(Double x, Double y) {
            return x > y + this.fuzz ? 1 : (x < y - this.fuzz ? -1 : 0);
        }
    }
}

