/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import java.util.Iterator;

public class Margin
extends MeasuredPerformance {
    private static final long serialVersionUID = -2987795640706342168L;
    private double margin = Double.NaN;
    private double counter = 1.0;

    public Margin() {
    }

    public Margin(Margin m) {
        super(m);
        this.margin = m.margin;
        this.counter = m.counter;
    }

    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        Iterator reader = exampleSet.iterator();
        this.margin = 1.0;
        Attribute labelAttr = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            String trueLabel = example.getNominalValue(labelAttr);
            double confidence = example.getConfidence(trueLabel);
            this.margin = Math.min(this.margin, confidence);
        }
    }

    public void countExample(Example example) {
    }

    public double getExampleCount() {
        return this.counter;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getMikroAverage() {
        return this.margin / this.counter;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "margin";
    }

    public String getDescription() {
        return "The margin of a classifier, defined as the minimal confidence for the correct label.";
    }

    public void buildSingleAverage(Averagable performance) {
        Margin other = (Margin)performance;
        this.margin += other.margin;
        this.counter += other.counter;
    }

    public String toString() {
        return super.toString();
    }
}

