/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.postag.TrainingParameters;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POSTaggerTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "POSTaggerTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trains a model for the part-of-speech tagger";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + TrainingParameters.getParameterUsage() + " -data trainingData -model model\n" + TrainingParameters.getDescription();
    }

    static ObjectStream<POSSample> openSampleData(String sampleDataName, File sampleDataFile, Charset encoding) {
        CmdLineUtil.checkInputFile(sampleDataName + " Data", sampleDataFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(sampleDataFile);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), encoding);
        return new WordTagSampleStream(lineStream);
    }

    @Override
    public void run(String[] args) {
        POSModel model;
        if (args.length < 8) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainingParameters parameters = new TrainingParameters(args);
        if (!parameters.isValid()) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        File trainingDataInFile = new File(CmdLineUtil.getParameter("-data", args));
        File modelOutFile = new File(CmdLineUtil.getParameter("-model", args));
        CmdLineUtil.checkOutputFile("pos tagger model", modelOutFile);
        ObjectStream<POSSample> sampleStream = POSTaggerTrainerTool.openSampleData("Training", trainingDataInFile, parameters.getEncoding());
        try {
            POSDictionary tagdict = null;
            if (parameters.getDictionaryPath() != null) {
                tagdict = new POSDictionary(parameters.getDictionaryPath());
            }
            model = POSTaggerME.train(parameters.getLanguage(), sampleStream, parameters.getModel(), tagdict, null, parameters.getCutoff(), parameters.getNumberOfIterations());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("pos tagger", modelOutFile, model);
    }
}

