/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.model.MaxentModel;
import opennlp.model.TwoPassDataIndexer;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.HashSumEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    protected BeamSearch<String> beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator, ChunkerContextGenerator contextGenerator) {
        this.model = model.getChunkerModel();
        this.beam = new BeamSearch<String>(beamSize, contextGenerator, this.model, sequenceValidator, 0);
    }

    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator) {
        this(model, beamSize, sequenceValidator, new DefaultChunkerContextGenerator());
    }

    public ChunkerME(ChunkerModel model, int beamSize) {
        this(model, beamSize, null);
    }

    public ChunkerME(ChunkerModel model) {
        this(model, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod) {
        this(mod, new DefaultChunkerContextGenerator(), 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg) {
        this(mod, cg, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg, int beamSize) {
        this.beam = new BeamSearch<String>(beamSize, cg, mod);
        this.model = mod;
    }

    @Override
    @Deprecated
    public List<String> chunk(List<String> toks, List<String> tags) {
        this.bestSequence = this.beam.bestSequence((String[])toks.toArray(new String[toks.size()]), new Object[]{tags.toArray(new String[tags.size()])});
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] chunk(String[] toks, String[] tags) {
        this.bestSequence = this.beam.bestSequence((String[])toks, new Object[]{tags});
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    @Override
    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        String[] preds = this.chunk(toks, tags);
        return ChunkSample.phrasesAsSpanList(toks, tags, preds);
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> sentence, List<String> tags) {
        return this.topKSequences(sentence.toArray(new String[sentence.size()]), tags.toArray(new String[tags.size()]));
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.beam.bestSequences(10, (String[])sentence, new Object[]{tags});
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.beam.bestSequences(10, (String[])sentence, new Object[]{tags}, minSequenceScore);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, int cutoff, int iterations, ChunkerContextGenerator contextGenerator) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        ModelUtil.addCutoffAndIterations(manifestInfoEntries, cutoff, iterations);
        ChunkerEventStream es = new ChunkerEventStream(in, contextGenerator);
        HashSumEventStream hses = new HashSumEventStream(es);
        GISModel maxentModel = GIS.trainModel(iterations, new TwoPassDataIndexer(hses, cutoff));
        manifestInfoEntries.put("Training-Eventhash", hses.calculateHashSum().toString(16));
        return new ChunkerModel(lang, maxentModel, manifestInfoEntries);
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, int cutoff, int iterations) throws IOException, ObjectStreamException {
        return ChunkerME.train(lang, in, cutoff, iterations, new DefaultChunkerContextGenerator());
    }

    @Deprecated
    private static void usage() {
        System.err.println("Usage: ChunkerME [-encoding charset] trainingFile modelFile");
        System.err.println();
        System.err.println("Training file should be one word per line where each line consists of a ");
        System.err.println("space-delimited triple of \"word pos outcome\".  Sentence breaks are indicated by blank lines.");
        System.exit(1);
    }

    @Deprecated
    public static void main(String[] args) throws IOException, ObjectStreamException {
        if (args.length == 0) {
            ChunkerME.usage();
        }
        int ai = 0;
        String encoding = null;
        while (args[ai].startsWith("-")) {
            if (args[ai].equals("-encoding") && ai + 1 < args.length) {
                encoding = args[++ai];
            } else {
                System.err.println("Unknown option: " + args[ai]);
                ChunkerME.usage();
            }
            ++ai;
        }
        File inFile = null;
        File outFile = null;
        if (ai < args.length) {
            inFile = new File(args[ai++]);
        } else {
            ChunkerME.usage();
        }
        if (ai < args.length) {
            outFile = new File(args[ai++]);
        } else {
            ChunkerME.usage();
        }
        int iterations = 100;
        int cutoff = 5;
        if (args.length > ai) {
            iterations = Integer.parseInt(args[ai++]);
        }
        if (args.length > ai) {
            cutoff = Integer.parseInt(args[ai++]);
        }
        ChunkSampleStream es = encoding != null ? new ChunkSampleStream(new PlainTextByLineStream(new InputStreamReader((InputStream)new FileInputStream(inFile), encoding))) : new ChunkSampleStream(new PlainTextByLineStream(new FileReader(inFile)));
        ChunkerModel mod = ChunkerME.train("en", es, cutoff, iterations);
        System.out.println("Saving the model as: " + args[1]);
        FileOutputStream out = new FileOutputStream(outFile);
        mod.serialize(out);
        ((OutputStream)out).close();
    }
}

