/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.process.PsolaFrameProvider;
import marytts.signalproc.process.VocalTractModifier;
import marytts.signalproc.process.VoiceModificationParametersPreprocessor;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class FDPSOLAProcessorOld
extends VocalTractModifier {
    private DoubleDataSource input;
    private AudioInputStream inputAudio;
    private DDSAudioInputStream outputAudio;
    private VoiceModificationParametersPreprocessor modParams;
    private int numfrm;
    private int numfrmFixed;
    private int lpOrder;
    private String outputFile;
    private String tempOutBinaryFile;
    private int origLen;
    private PitchMarks pm;
    private PsolaFrameProvider psFrm;
    private double wsFixed;
    private double ssFixed;
    private int numPeriods;
    private static int NUM_PITCH_SYNC_PERIODS = 3;
    private boolean bSilent;
    private LEDataOutputStream dout;
    private LEDataInputStream din;
    private DynamicWindow windowIn;
    private DynamicWindow windowOut;
    private double[] wgt;
    private double[] wgty;
    private int frmSize;
    private int newFrmSize;
    private int newPeriod;
    private int synthFrmInd;
    private double localDurDiff;
    private int repeatSkipCount;
    private double localDurDiffSaved;
    private double sumLocalDurDiffs;
    private double nextAdd;
    private int synthSt;
    private int synthTotal;
    private int maxFrmSize;
    private int maxNewFrmSize;
    private int synthFrameInd;
    private boolean bLastFrame;
    private boolean bBroke;
    private int newFftSize;
    private int newMaxFreq;
    private int outBuffLen;
    private double[] outBuff;
    private int outBuffStart;
    private int totalWrittenToFile;
    private double[] ySynthBuff;
    private double[] wSynthBuff;
    private int ySynthInd;
    private double[] frm;
    private double[] frm2;
    private boolean bWarp;
    private double[] py;
    private double[] py2;
    private ComplexArray hy;
    private double[] frmy;
    private double frmEn;
    private double frmyEn;
    private double gain;
    private int newSkipSize;
    private int halfWin;
    private double[] newVScales;

    public FDPSOLAProcessorOld(String strInputFile, String strPitchFile, String strOutputFile, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws UnsupportedAudioFileException, IOException {
        this.inputAudio = AudioSystem.getAudioInputStream(new File(strInputFile));
        this.input = new AudioDoubleDataSource(this.inputAudio);
        this.origLen = (int)this.input.getDataLength();
        this.fs = (int)this.inputAudio.getFormat().getSampleRate();
        this.lpOrder = SignalProcUtils.getLPOrder(this.fs);
        this.wsFixed = 0.02;
        this.ssFixed = 0.01;
        this.numPeriods = NUM_PITCH_SYNC_PERIODS;
        PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
        this.pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, this.fs, this.origLen, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, 0);
        this.numfrm = this.pm.pitchMarks.length - this.numPeriods;
        this.numfrmFixed = (int)(Math.floor(((double)(this.origLen + this.pm.totalZerosToPadd) / (double)this.fs - 0.5 * this.wsFixed) / this.ssFixed + 0.5) + 2.0);
        this.modParams = new VoiceModificationParametersPreprocessor(this.fs, this.lpOrder, pscales, tscales, escales, vscales, this.pm.pitchMarks, this.wsFixed, this.ssFixed, this.numfrm, this.numfrmFixed, this.numPeriods, false);
        this.outputFile = strOutputFile;
        this.initialise();
    }

    public void initialise() throws FileNotFoundException {
        this.bSilent = false;
        this.psFrm = new PsolaFrameProvider(this.input, this.pm, this.modParams.fs, this.modParams.numPeriods);
        this.tempOutBinaryFile = this.outputFile + ".bin";
        this.dout = new LEDataOutputStream(this.tempOutBinaryFile);
        this.windowIn = new DynamicWindow(3);
        this.windowOut = new DynamicWindow(3);
        this.frmSize = 0;
        this.newFrmSize = 0;
        this.newPeriod = 0;
        this.synthFrmInd = 0;
        this.localDurDiff = 0.0;
        this.repeatSkipCount = 0;
        this.localDurDiffSaved = 0.0;
        this.sumLocalDurDiffs = 0.0;
        this.nextAdd = 0.0;
        this.synthSt = this.pm.pitchMarks[0];
        this.synthTotal = 0;
        this.maxFrmSize = (int)((double)(this.modParams.numPeriods * this.modParams.fs) / 40.0);
        if (this.maxFrmSize % 2 != 0) {
            ++this.maxFrmSize;
        }
        this.maxNewFrmSize = (int)Math.floor((double)this.maxFrmSize / MathUtils.min(this.modParams.pscalesVar) + 0.5);
        if (this.maxNewFrmSize % 2 != 0) {
            ++this.maxNewFrmSize;
        }
        this.synthFrameInd = 0;
        this.bLastFrame = false;
        this.bBroke = false;
        this.fftSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.maxFrmSize) / Math.log(2.0)));
        this.maxFreq = this.fftSize / 2 + 1;
        this.outBuffLen = 100;
        this.outBuff = MathUtils.zeros(this.outBuffLen);
        this.outBuffStart = 1;
        this.totalWrittenToFile = 0;
        this.ySynthBuff = MathUtils.zeros(this.maxNewFrmSize);
        this.wSynthBuff = MathUtils.zeros(this.maxNewFrmSize);
        this.ySynthInd = 1;
    }

    public void fdpsolaOnline() throws IOException {
        int kInd;
        int k;
        int i;
        double[] tmpvsc = new double[1];
        block0: for (i = 0; i < this.numfrm; ++i) {
            boolean isVoiced;
            this.frm2 = this.psFrm.getNextFrame();
            if (this.bBroke) break;
            this.repeatSkipCount = 0;
            this.frmSize = this.pm.pitchMarks[i + this.modParams.numPeriods] - this.pm.pitchMarks[i] + 1;
            if (this.frmSize % 2 != 0) {
                ++this.frmSize;
            }
            if (this.frmSize < 4) {
                this.frmSize = 4;
            }
            boolean bl = isVoiced = (double)this.pm.f0s[i] > 10.0;
            if (isVoiced) {
                this.newFrmSize = (int)Math.floor((double)this.frmSize / this.modParams.pscalesVar[i] + 0.5);
                if (this.newFrmSize % 2 != 0) {
                    ++this.newFrmSize;
                }
                if (this.newFrmSize < 4) {
                    this.newFrmSize = 4;
                }
            } else {
                this.newFrmSize = this.frmSize;
            }
            this.newPeriod = (int)Math.floor((double)this.newFrmSize / (double)this.modParams.numPeriods + 0.5);
            this.localDurDiff = this.nextAdd + ((double)this.frmSize * this.modParams.tscalesVar[i] - (double)this.newFrmSize) / (double)this.modParams.numPeriods;
            this.nextAdd = 0.0;
            if (this.localDurDiff < -0.1 * (double)this.newPeriod) {
                --this.repeatSkipCount;
                if (i < this.numfrm - 1) {
                    this.nextAdd = this.localDurDiff + (double)this.newPeriod;
                    this.localDurDiff = 0.0;
                }
            } else if (this.localDurDiff > 0.1 * (double)this.newPeriod) {
                while (this.localDurDiff > 0.1 * (double)this.newPeriod) {
                    ++this.repeatSkipCount;
                    this.localDurDiff -= (double)this.newPeriod;
                }
                if (i < this.numfrm - 1) {
                    this.nextAdd = this.localDurDiff;
                    this.localDurDiff = 0.0;
                }
            }
            this.sumLocalDurDiffs += this.localDurDiff;
            if (i == this.numfrm - 1) {
                this.localDurDiff = this.sumLocalDurDiffs;
                while (this.localDurDiff > 0.0) {
                    ++this.repeatSkipCount;
                    this.localDurDiff -= (double)this.newPeriod;
                }
            }
            if (i == this.numfrm - 1) {
                ++this.repeatSkipCount;
                this.bLastFrame = true;
            }
            if (this.repeatSkipCount > -1) {
                int j;
                this.frm = MathUtils.zeros(this.frmSize);
                System.arraycopy(this.frm2, 0, this.frm, 0, this.frmSize);
                this.wgt = this.windowIn.values(this.frmSize);
                this.bWarp = this.modParams.vscalesVar[i] != 1.0;
                if (isVoiced && this.modParams.pscalesVar[i] != 1.0 || this.bWarp) {
                    this.newMaxFreq = (int)Math.floor((double)this.maxFreq / this.modParams.pscalesVar[i] + 0.5);
                    if (this.newMaxFreq < 3) {
                        this.newMaxFreq = 3;
                    }
                    if (this.newMaxFreq % 2 != 1) {
                        ++this.newMaxFreq;
                    }
                    this.newFftSize = 2 * (this.newMaxFreq - 1);
                    this.frmEn = SignalProcUtils.getEnergy(this.frm);
                    this.initialise(this.modParams.lpOrder, this.modParams.fs, this.fftSize, true);
                    this.windowIn.applyInline(this.frm, 0, this.frmSize);
                    this.applyInline(this.frm, 0, this.frmSize);
                    this.py = MathUtils.interpolate(this.vtSpectrum, this.newMaxFreq);
                    if (this.bWarp) {
                        tmpvsc[0] = this.modParams.vscalesVar[i];
                        this.newVScales = MathUtils.modifySize(tmpvsc, this.newMaxFreq);
                        for (k = 0; k < this.newVScales.length; ++k) {
                            if (!(this.newVScales[k] < 0.05)) continue;
                            this.newVScales[k] = 0.05;
                        }
                        this.py2 = new double[this.newMaxFreq];
                        for (k = 0; k < this.newMaxFreq; ++k) {
                            int wInd = (int)Math.floor((double)(k + 1) / this.newVScales[k] + 0.5);
                            if (wInd < 1) {
                                wInd = 1;
                            }
                            if (wInd > this.newMaxFreq) {
                                wInd = this.newMaxFreq;
                            }
                            this.py2[k] = this.py[wInd - 1];
                        }
                        System.arraycopy(this.py2, 0, this.py, 0, this.newMaxFreq);
                    }
                    this.hy = new ComplexArray(this.newFftSize);
                    this.hy.real = MathUtils.zeros(this.newFftSize);
                    this.hy.imag = MathUtils.zeros(this.newFftSize);
                    System.arraycopy(this.h.real, 0, this.hy.real, 0, Math.min(this.maxFreq, this.newFftSize));
                    System.arraycopy(this.h.imag, 0, this.hy.imag, 0, Math.min(this.maxFreq, this.newFftSize));
                    int kMax = 1;
                    while (this.newMaxFreq > (kMax + 1) * (this.maxFreq - 2)) {
                        ++kMax;
                    }
                    for (k = 1; k <= kMax; ++k) {
                        int tmpMul;
                        int tmpAdd;
                        int tmpFix = (this.maxFreq - 2) * k;
                        if (k % 2 == 1) {
                            tmpAdd = this.maxFreq + 2;
                            tmpMul = 1;
                        } else {
                            tmpAdd = -1;
                            tmpMul = -1;
                        }
                        for (j = tmpFix + 3; j <= Math.min(this.newMaxFreq, this.maxFreq + tmpFix); ++j) {
                            this.hy.real[j - 1] = this.h.real[tmpMul * (tmpFix - j) + tmpAdd - 1];
                            this.hy.imag[j - 1] = this.h.imag[tmpMul * (tmpFix - j) + tmpAdd - 1];
                        }
                    }
                    this.hy.real[this.newMaxFreq - 1] = Math.sqrt(this.hy.real[this.newMaxFreq - 1] * this.hy.real[this.newMaxFreq - 1] + this.hy.imag[this.newMaxFreq - 1] * this.hy.imag[this.newMaxFreq - 1]);
                    this.hy.imag[this.newMaxFreq - 1] = 0.0;
                    for (k = 1; k <= this.newMaxFreq; ++k) {
                        int n = k - 1;
                        this.hy.real[n] = this.hy.real[n] * this.py[k - 1];
                        int n2 = k - 1;
                        this.hy.imag[n2] = this.hy.imag[n2] * this.py[k - 1];
                    }
                    for (k = this.newMaxFreq + 1; k <= this.newFftSize; ++k) {
                        this.hy.real[k - 1] = this.hy.real[2 * this.newMaxFreq - 1 - k];
                        this.hy.imag[k - 1] = -this.hy.imag[2 * this.newMaxFreq - 1 - k];
                    }
                    this.hy = FFTMixedRadix.ifft(this.hy);
                    this.frmy = new double[this.newFrmSize];
                    System.arraycopy(this.hy.real, 0, this.frmy, 0, this.newFrmSize);
                    this.frmyEn = SignalProcUtils.getEnergy(this.frmy);
                    this.gain = this.frmEn / Math.sqrt(this.frmSize) / (this.frmyEn / Math.sqrt(this.newFrmSize)) * this.modParams.escalesVar[i];
                } else {
                    if (this.frmSize < this.newFrmSize) {
                        this.newFrmSize = this.frmSize;
                    }
                    this.frmy = new double[this.newFrmSize];
                    for (k = 0; k < this.frmSize; ++k) {
                        this.frmy[k] = this.frm[k] * this.wgt[k];
                    }
                    this.gain = this.modParams.escalesVar[i];
                }
                k = 0;
                while (k < this.newFrmSize) {
                    int n = k++;
                    this.frmy[n] = this.frmy[n] * this.gain;
                }
                for (j = 1; j <= this.repeatSkipCount + 1; ++j) {
                    this.newSkipSize = isVoiced ? (int)Math.floor((double)(this.pm.pitchMarks[i + 1] - this.pm.pitchMarks[i]) / this.modParams.pscalesVar[i] + 0.5) : (int)Math.floor((double)(this.pm.pitchMarks[i + 1] - this.pm.pitchMarks[i]) + 0.5);
                    this.bLastFrame = i == this.numfrm - 1 && j == this.repeatSkipCount + 1;
                    ++this.synthFrameInd;
                    this.wgty = this.windowOut.values(this.newFrmSize);
                    if (this.synthFrameInd == 1) {
                        this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                        this.synthTotal = this.synthSt + this.newFrmSize;
                        if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                            for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                                this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                                this.wSynthBuff[k - 1] = 1.0;
                            }
                            for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n3 = k - 1;
                                this.wSynthBuff[n3] = this.wSynthBuff[n3] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            }
                        } else {
                            for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                                if (k - this.ySynthInd < this.halfWin) {
                                    this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                                    this.wSynthBuff[k - 1] = 1.0;
                                    continue;
                                }
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n4 = k - 1;
                                this.wSynthBuff[n4] = this.wSynthBuff[n4] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            }
                            for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                                if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                    this.ySynthBuff[k - 1] = this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                                    this.wSynthBuff[k - 1] = 1.0;
                                    continue;
                                }
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                int n5 = k - 1;
                                this.wSynthBuff[n5] = this.wSynthBuff[n5] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                            }
                        }
                        if (!this.bSilent) {
                            System.out.println("Synthesized using frame " + String.valueOf(i + 1) + " of " + String.valueOf(this.numfrm) + " " + String.valueOf(this.pm.pitchMarks[i]) + " " + String.valueOf(this.pm.pitchMarks[i + this.modParams.numPeriods]));
                        }
                    } else if (this.bLastFrame) {
                        this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                        int remain = this.newFrmSize - this.halfWin;
                        this.synthTotal = this.synthSt + this.halfWin + remain - 1;
                        if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                            for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n6 = k - 1;
                                this.wSynthBuff[n6] = this.wSynthBuff[n6] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            }
                            for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                                this.wSynthBuff[k - 1] = 1.0;
                            }
                        } else {
                            for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                                if (k - this.ySynthInd < this.halfWin) {
                                    int n = k - 1;
                                    this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                    int n7 = k - 1;
                                    this.wSynthBuff[n7] = this.wSynthBuff[n7] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                    continue;
                                }
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                                this.wSynthBuff[k - 1] = 1.0;
                            }
                            for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                                if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                    int n = k - 1;
                                    this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                    int n8 = k - 1;
                                    this.wSynthBuff[n8] = this.wSynthBuff[n8] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                    continue;
                                }
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                                this.wSynthBuff[k - 1] = 1.0;
                            }
                        }
                        if (!this.bSilent) {
                            System.out.println("Synthesized using frame " + String.valueOf(i + 1) + " of " + String.valueOf(this.numfrm) + " " + String.valueOf(this.pm.pitchMarks[i]) + " " + String.valueOf(this.pm.pitchMarks[i + this.modParams.numPeriods]));
                        }
                    } else {
                        if (!isVoiced && this.repeatSkipCount % 2 == 1) {
                            this.frmy = SignalProcUtils.reverse(this.frmy);
                        }
                        this.synthTotal = this.synthSt + this.newFrmSize;
                        if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                            for (k = this.ySynthInd; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n9 = k - 1;
                                this.wSynthBuff[n9] = this.wSynthBuff[n9] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            }
                        } else {
                            for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n10 = k - 1;
                                this.wSynthBuff[n10] = this.wSynthBuff[n10] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            }
                            for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                                int n11 = k - 1;
                                this.wSynthBuff[n11] = this.wSynthBuff[n11] + this.wgty[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                            }
                        }
                        if (!this.bSilent) {
                            if (j == 1) {
                                System.out.println("Synthesized using frame " + String.valueOf(i + 1) + " of " + String.valueOf(this.numfrm) + " " + String.valueOf(this.pm.pitchMarks[i]) + " " + String.valueOf(this.pm.pitchMarks[i + this.modParams.numPeriods]));
                            } else {
                                System.out.println("Repeated using frame " + String.valueOf(i + 1) + " of " + String.valueOf(this.numfrm) + " " + String.valueOf(this.pm.pitchMarks[i]) + " " + String.valueOf(this.pm.pitchMarks[i + this.modParams.numPeriods]));
                            }
                        }
                    }
                    for (k = 0; k <= this.newSkipSize - 1; ++k) {
                        kInd = (k + this.ySynthInd) % this.maxNewFrmSize;
                        if (kInd == 0) {
                            kInd = this.maxNewFrmSize;
                        }
                        this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
                        this.ySynthBuff[kInd - 1] = 0.0;
                        this.wSynthBuff[kInd - 1] = 0.0;
                        ++this.outBuffStart;
                        if (this.outBuffStart <= this.outBuffLen) continue;
                        if (this.modParams.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                            this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                            this.totalWrittenToFile += this.outBuffLen;
                        } else {
                            this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                            this.totalWrittenToFile = this.origLen;
                        }
                        this.outBuffStart = 1;
                    }
                    this.synthSt += this.newSkipSize;
                    this.ySynthInd = this.ySynthInd + this.newSkipSize <= this.maxNewFrmSize ? (this.ySynthInd += this.newSkipSize) : (this.ySynthInd += this.newSkipSize - this.maxNewFrmSize);
                    if (!this.bLastFrame) continue;
                    this.bBroke = true;
                    continue block0;
                }
                continue;
            }
            if (this.bSilent) continue;
            System.out.println("Skipped frame " + String.valueOf(i + 1) + " of " + String.valueOf(this.numfrm));
        }
        if (this.modParams.tscaleSingle == 1.0) {
            this.synthTotal = this.origLen;
        }
        if (this.outBuffLen > this.synthTotal) {
            this.outBuffLen = this.synthTotal;
        }
        for (k = this.synthSt; k <= this.synthTotal; ++k) {
            kInd = (k - this.synthSt + this.ySynthInd) % this.maxNewFrmSize;
            if (kInd == 0) {
                kInd = this.maxNewFrmSize;
            }
            this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
            this.ySynthBuff[kInd - 1] = 0.0;
            this.wSynthBuff[kInd - 1] = 0.0;
            ++this.outBuffStart;
            if (this.outBuffStart <= this.outBuffLen) continue;
            if (this.modParams.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                this.totalWrittenToFile += this.outBuffLen;
            } else {
                this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                this.totalWrittenToFile = this.origLen;
            }
            this.outBuffStart = 1;
        }
        if (this.outBuffStart > 1) {
            if (this.modParams.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffStart - 1 <= this.origLen) {
                this.dout.writeDouble(this.outBuff, 0, this.outBuffStart - 1);
                this.totalWrittenToFile += this.outBuffStart - 1;
            } else {
                this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                this.totalWrittenToFile = this.origLen;
            }
        }
        this.dout.close();
        this.din = new LEDataInputStream(this.tempOutBinaryFile);
        double[] yOut = this.din.readDouble(this.totalWrittenToFile);
        this.din.close();
        double tmpMax = MathUtils.getAbsMax(yOut);
        if (tmpMax > 32735.0) {
            i = 0;
            while (i < yOut.length) {
                int n = i++;
                yOut[n] = yOut[n] * (32735.0 / tmpMax);
            }
        }
        this.outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(yOut), this.inputAudio.getFormat());
        AudioSystem.write((AudioInputStream)this.outputAudio, AudioFileFormat.Type.WAVE, new File(this.outputFile));
        File tmpFile = new File(this.tempOutBinaryFile);
        tmpFile.delete();
    }

    public static void main(String[] args) throws Exception {
        String strOutputFile = args[0].substring(0, args[0].length() - 4) + "_fdJavOld.wav";
        String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
        double[] pscales = new double[]{1.2, 0.3};
        double[] tscales = new double[]{1.5};
        double[] escales = new double[]{1.0};
        double[] vscales = new double[]{1.8, 0.4};
        FDPSOLAProcessorOld fd = new FDPSOLAProcessorOld(args[0], strPitchFile, strOutputFile, pscales, tscales, escales, vscales);
        fd.fdpsolaOnline();
    }
}

