/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.gui.DatabaseExampleVisualization;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizardCreator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExampleVisualizationOperator
extends Operator {
    public static final String PARAMETER_DATABASE_SYSTEM = "database_system";
    public static final String PARAMETER_DATABASE_URL = "database_url";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_ID_COLUMN = "id_column";

    public DatabaseExampleVisualizationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        DatabaseExampleVisualization visualizer = new DatabaseExampleVisualization(this.getParameterAsString(PARAMETER_DATABASE_URL), this.getParameterAsString(PARAMETER_USERNAME), this.getParameterAsString(PARAMETER_PASSWORD), this.getParameterAsInt(PARAMETER_DATABASE_SYSTEM), this.getParameterAsString(PARAMETER_TABLE_NAME), this.getParameterAsString(PARAMETER_ID_COLUMN), this.getLog());
        ObjectVisualizerService.addObjectVisualizer(visualizer);
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        HashMap<String, String> wizardParameters = new HashMap<String, String>();
        wizardParameters.put("only_table_name", "true");
        wizardParameters.put("show_database_configuration", "true");
        ParameterType type = new ParameterTypeConfiguration(DBExampleSourceConfigurationWizardCreator.class, wizardParameters, this);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DATABASE_SYSTEM, "Indicates the used database system", DatabaseService.getDBSystemNames(), 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DATABASE_URL, "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "Database username.", false));
        types.add(new ParameterTypePassword(PARAMETER_PASSWORD, "Password for the database."));
        types.add(new ParameterTypeString(PARAMETER_TABLE_NAME, "The table from which the data for displaying is taken.", false));
        types.add(new ParameterTypeString(PARAMETER_ID_COLUMN, "The column of the table holding the object ids for detail data querying.", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

