/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProportionNormalizationModel
extends PreprocessingModel {
    private static final long serialVersionUID = 5620317015578777169L;
    private HashMap<String, Double> attributeSums;
    private Set<String> attributeNames;

    public ProportionNormalizationModel(ExampleSet exampleSet, HashMap<String, Double> attributeSums) {
        super(exampleSet);
        this.attributeSums = attributeSums;
        this.attributeNames = new HashSet<String>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            this.attributeNames.add(attribute.getName());
        }
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        for (Example example : exampleSet) {
            for (Attribute attribute : exampleSet.getAttributes()) {
                String attributeName = attribute.getName();
                if (!this.attributeSums.containsKey(attributeName)) continue;
                Double sum = this.attributeSums.get(attributeName);
                double value = example.getValue(attribute);
                example.setValue(attribute, value / sum);
            }
        }
        return exampleSet;
    }

    @Override
    public String getName() {
        return "Proportional normalization model";
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Normalizes all attributes proportional to their respective total sum. Attributes sums: \n");
        for (Map.Entry<String, Double> entry : this.attributeSums.entrySet()) {
            buffer.append(String.valueOf(entry.getKey()) + ": " + entry.getValue() + "\n");
        }
        return buffer.toString();
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet viewParent) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> roleIterator = viewParent.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = roleIterator.next();
            if (!role.isSpecial()) continue;
            attributes.add(role);
        }
        for (Attribute attribute : viewParent.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeNames.contains(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 2, null));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        Double sum = this.attributeSums.get(targetAttribute.getName());
        return value / sum;
    }
}

