/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;

public class MetaCostModel
extends PredictionModel {
    private static final long serialVersionUID = -7378871544357578954L;
    private Model[] models;
    private double[][] costMatrix;

    public MetaCostModel(ExampleSet exampleSet, Model[] models, double[][] costMatrix) {
        super(exampleSet);
        this.models = models;
        this.costMatrix = costMatrix;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    public double getCostValue(int i, int j) {
        return this.costMatrix[i][j];
    }

    public ExampleSet performPrediction(ExampleSet originalExampleSet, Attribute predictedLabel) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = this.getLabel().getMapping().getValues().size();
        double[][] confidences = new double[exampleSet.size()][numberOfClasses];
        int currentNumber = 0;
        HashMap<Integer, String> classIndexMap = new HashMap<Integer, String>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, currentClass);
            ++currentNumber;
        }
        int k = 0;
        while (k < this.getNumberOfModels()) {
            Model model = this.getModel(k);
            exampleSet = model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                int currentClassNumber = 0;
                for (String currentClass : this.getLabel().getMapping().getValues()) {
                    double[] dArray = confidences[counter];
                    int n = currentClassNumber++;
                    dArray[n] = dArray[n] + example.getConfidence(currentClass);
                }
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
            ++k;
        }
        Attribute classificationCost = AttributeFactory.createAttribute("cost", 4);
        originalExampleSet.getExampleTable().addAttribute(classificationCost);
        originalExampleSet.getAttributes().setCost(classificationCost);
        Attribute classLabel = originalExampleSet.getAttributes().getLabel();
        boolean hasLabel = classLabel != null;
        Iterator reader = originalExampleSet.iterator();
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int i = 0;
            while (i < numberOfClasses) {
                confidences[counter][i] = confidences[counter][i] / (double)this.getNumberOfModels();
                ++i;
            }
            double[] conditionalRisk = new double[numberOfClasses];
            int bestIndex = 0;
            double bestValue = Double.POSITIVE_INFINITY;
            int i2 = 0;
            while (i2 < numberOfClasses) {
                int j = 0;
                while (j < numberOfClasses) {
                    int n = i2;
                    conditionalRisk[n] = conditionalRisk[n] + confidences[counter][j] * this.costMatrix[i2][j];
                    ++j;
                }
                if (conditionalRisk[i2] < bestValue) {
                    bestValue = conditionalRisk[i2];
                    bestIndex = i2;
                }
                ++i2;
            }
            example.setPredictedLabel(this.getLabel().getMapping().mapString((String)classIndexMap.get(bestIndex)));
            if (hasLabel) {
                int labelIndex = this.getLabel().getMapping().mapString((String)classIndexMap.get((int)example.getLabel()));
                example.setValue(classificationCost, this.costMatrix[bestIndex][labelIndex]);
            } else {
                example.setValue(classificationCost, conditionalRisk[bestIndex]);
            }
            i2 = 0;
            while (i2 < numberOfClasses) {
                example.setConfidence((String)classIndexMap.get(i2), confidences[counter][i2]);
                ++i2;
            }
            ++counter;
        }
        return originalExampleSet;
    }

    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            tabPane.add("Model " + (i + 1), model.getVisualizationComponent(container));
            ++i;
        }
        return tabPane;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        int i = 0;
        while (i < this.models.length) {
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
            ++i;
        }
        return result.toString();
    }
}

