/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMailingExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static String[] ATTRIBUTE_NAMES = new String[]{"name", "age", "lifestyle", "zip code", "family status", "car", "sports", "earnings"};
    private static int[] VALUE_TYPES = new int[]{1, 3, 1, 3, 1, 1, 1, 3};
    private static String[][] POSSIBLE_VALUES;

    static {
        String[][] stringArrayArray = new String[8][];
        stringArrayArray[2] = new String[]{"healthy", "active", "cozily"};
        stringArrayArray[4] = new String[]{"married", "single"};
        stringArrayArray[5] = new String[]{"practical", "expensive"};
        stringArrayArray[6] = new String[]{"soccer", "badminton", "athletics"};
        POSSIBLE_VALUES = stringArrayArray;
    }

    public DirectMailingExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int m = 0;
        while (m < ATTRIBUTE_NAMES.length) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                int v = 0;
                while (v < possibleValues.length) {
                    current.getMapping().mapString(possibleValues[v]);
                    ++v;
                }
            }
            attributes.add(current);
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("no response");
        label.getMapping().mapString("response");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            double[] values = new double[ATTRIBUTE_NAMES.length + 1];
            values[0] = ((Attribute)attributes.get(0)).getMapping().mapString(random.nextString(8));
            values[1] = random.nextIntInRange(15, 70);
            values[2] = random.nextInt(POSSIBLE_VALUES[2].length);
            values[3] = random.nextIntInRange(10000, 100000);
            values[4] = random.nextInt(POSSIBLE_VALUES[4].length);
            values[5] = random.nextInt(POSSIBLE_VALUES[5].length);
            values[6] = random.nextInt(POSSIBLE_VALUES[6].length);
            values[7] = random.nextIntInRange(20000, 150000);
            values[8] = label.getMapping().mapString("no response");
            if (values[1] > 65.0) {
                if (random.nextDouble() > 0.05) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[1] > 60.0) {
                if (random.nextDouble() > 0.1) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[1] > 55.0) {
                if (random.nextDouble() > 0.2) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[3] < 15000.0) {
                if (random.nextDouble() > 0.1) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[7] > 140000.0) {
                values[8] = label.getMapping().mapString("response");
            }
            table.addDataRow(new DoubleArrayDataRow(values));
            ++n;
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

