/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightingMutation
extends IndividualOperator {
    private double variance;
    private boolean bounded;
    private Random random;

    public WeightingMutation(double variance, boolean bounded, Random random) {
        this.variance = variance;
        this.bounded = bounded;
        this.random = random;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getVariance() {
        return this.variance;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        double[] weights = individual.getWeightsClone();
        LinkedList<Individual> l = new LinkedList<Individual>();
        int i = 0;
        while (i < weights.length) {
            double weight = weights[i] + this.random.nextGaussian() * this.variance;
            if (!this.bounded || weight >= 0.0 && weight <= 1.0) {
                weights[i] = weight;
            }
            ++i;
        }
        Individual newIndividual = new Individual(weights);
        if (newIndividual.getNumberOfUsedAttributes() > 0) {
            l.add(newIndividual);
        }
        return l;
    }
}

