/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.NoOpUserError;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.GUIInputHandler;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.dialog.InitialSettingsDialog;
import com.rapidminer.gui.dialog.ResultHistory;
import com.rapidminer.gui.look.RapidLookAndFeel;
import com.rapidminer.gui.tools.CommunityUpdateManager;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateManager;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapidMinerGUI
extends RapidMiner {
    public static final String PROPERTY_GEOMETRY_X = "rapidminer.gui.geometry.x";
    public static final String PROPERTY_GEOMETRY_Y = "rapidminer.gui.geometry.y";
    public static final String PROPERTY_GEOMETRY_WIDTH = "rapidminer.gui.geometry.width";
    public static final String PROPERTY_GEOMETRY_HEIGHT = "rapidminer.gui.geometry.height";
    public static final String PROPERTY_GEOMETRY_DIVIDER_MAIN = "rapidminer.gui.geometry.divider.main";
    public static final String PROPERTY_GEOMETRY_DIVIDER_EDITOR = "rapidminer.gui.geometry.divider.editor";
    public static final String PROPERTY_GEOMETRY_DIVIDER_LOGGING = "rapidminer.gui.geometry.divider.logging";
    public static final String PROPERTY_GEOMETRY_DIVIDER_GROUPSELECTION = "rapidminer.gui.geometry.divider.groupselection";
    public static final String PROPERTY_EXPERT_MODE = "rapidminer.gui.expertmode";
    public static final String PROPERTY_RAPIDMINER_GUI_UPDATE_CHECK = "rapidminer.gui.update.check";
    public static final String PROPERTY_RAPIDMINER_GUI_LOOK_AND_FEEL = "rapidminer.gui.look";
    public static final String PROPERTY_RAPIDMINER_GUI_MAX_STATISTICS_ROWS = "rapidminer.gui.max_statistics_rows";
    public static final String PROPERTY_RAPIDMINER_GUI_MAX_SORTABLE_ROWS = "rapidminer.gui.max_sortable_rows";
    public static final String PROPERTY_RAPIDMINER_GUI_MAX_DISPLAYED_VALUES = "rapidminer.gui.max_displayed_values";
    public static final String[] LOOK_AND_FEELS = new String[]{"modern", "classic"};
    public static final int LOOK_AND_FEEL_MODERN = 0;
    public static final int LOOK_AND_FEEL_CLASSIC = 1;
    private static final ParameterTypeCategory LOOK_AND_FEEL_PARAMETER_TYPE = new ParameterTypeCategory("rapidminer.gui.look", "Indicates which look and feel should be used (you have to restart RapidMiner in order to see changes).", LOOK_AND_FEELS, 0);
    private static final int NUMBER_OF_RECENT_FILES = 8;
    private static MainFrame mainFrame;
    private static LinkedList<File> recentFiles;
    private static ResultHistory resultHistory;
    private static UpdateManager updateManager;

    static {
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_UPDATE_CHECK, "Check for new RapidMiner versions at start up time?", true));
        RapidMiner.registerRapidMinerProperty(LOOK_AND_FEEL_PARAMETER_TYPE);
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_MAX_STATISTICS_ROWS, "Indicates the maximum number of rows for the automatic calculation of statistics and other time intensive data viewing actions.", 1, Integer.MAX_VALUE, 100000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_MAX_SORTABLE_ROWS, "Indicates the maximum number of rows for sortable tables.", 1, Integer.MAX_VALUE, 100000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_MAX_DISPLAYED_VALUES, "Indicates the maximum number of different values which will for example be displayed in the meta data view.", 1, Integer.MAX_VALUE, 50));
        recentFiles = new LinkedList();
        resultHistory = new ResultHistory();
        updateManager = new CommunityUpdateManager();
    }

    public void run(File file) throws Exception {
        URL logoURL = Tools.getResource("rapidminer_logo.png");
        if (logoURL == null) {
            System.err.println("ERROR: cannot find resources. Probably the ant target 'copy-resources' must be performed!");
            RapidMiner.quit(1);
        }
        RapidMiner.showSplash();
        RapidMiner.splashMessage("Basic Initialization");
        RapidMiner.init();
        RapidMiner.splashMessage("Using US Local");
        Locale.setDefault(Locale.US);
        JOptionPane.setDefaultLocale(Locale.US);
        RapidMiner.splashMessage("Workspace Initialization");
        this.performInitialSettings();
        RapidMiner.splashMessage("Setting up Look and Feel");
        this.setupToolTipManager();
        this.setupGUI();
        RapidMiner.splashMessage("Loading History");
        RapidMinerGUI.loadRecentFileList();
        RapidMiner.splashMessage("Creating Frame");
        RapidMinerGUI.setMainFrame(new MainFrame());
        RapidMiner.splashMessage("Initialize Global Logging");
        LogService.getGlobal().initGUI();
        RapidMiner.splashMessage("Loading GUI Properties");
        RapidMinerGUI.loadGUIProperties(mainFrame);
        RapidMiner.splashMessage("Initialize Plugin GUI");
        Plugin.initPluginGuis(mainFrame);
        RapidMiner.splashMessage("Showing Frame");
        mainFrame.setVisible(true);
        RapidMiner.splashMessage("Initialize Process Logging");
        mainFrame.getProcess().getLog().initGUI();
        RapidMiner.splashMessage("Initialize Checks");
        Plugin.initFinalChecks();
        RapidMiner.splashMessage("Ready.");
        RapidMiner.hideSplash();
        if (file != null) {
            mainFrame.open(file);
            mainFrame.changeMode(0);
        } else {
            mainFrame.changeMode(2);
        }
        Plugin.initPluginUpdateManager();
        String updateProperty = System.getProperty(PROPERTY_RAPIDMINER_GUI_UPDATE_CHECK);
        if (Tools.booleanValue(updateProperty, true)) {
            boolean check = true;
            Calendar lastCheck = RapidMinerGUI.loadLastUpdateCheckDate();
            if (lastCheck != null) {
                Calendar currentDate = Calendar.getInstance();
                currentDate.add(6, -7);
                if (!lastCheck.before(currentDate)) {
                    check = false;
                }
            }
            if (check) {
                RapidMinerGUI.checkForUpdates(false);
            }
        }
    }

    private void setupToolTipManager() {
        ToolTipManager manager = ToolTipManager.sharedInstance();
        manager.setDismissDelay(25000);
        manager.setInitialDelay(1500);
        manager.setReshowDelay(50);
    }

    protected void setupGUI() throws NoOpUserError {
        String lookAndFeelString = System.getProperty(PROPERTY_RAPIDMINER_GUI_LOOK_AND_FEEL);
        int lookAndFeel = 0;
        if (lookAndFeelString != null && (lookAndFeel = LOOK_AND_FEEL_PARAMETER_TYPE.getIndex(lookAndFeelString)) == -1) {
            LogService.getGlobal().log("Cannot setup look and feel ('" + lookAndFeelString + "'), using default.", 3);
        }
        if (lookAndFeel == 1) {
            try {
                Class<?> clazz = Class.forName("com.jgoodies.looks.plastic.PlasticLookAndFeel");
                Method method = clazz.getMethod("setTabStyle", String.class);
                method.invoke(null, "Metal");
                Class<?> themeClazz = Class.forName("com.jgoodies.looks.plastic.PlasticTheme");
                Class<?> skyBluerClazz = Class.forName("com.jgoodies.looks.plastic.theme.SkyBluer");
                Object theme = skyBluerClazz.newInstance();
                method = clazz.getMethod("setPlasticTheme", themeClazz);
                method.invoke(null, theme);
                Class<?> lafClazz = Class.forName("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                Object lafInstance = lafClazz.newInstance();
                UIManager.setLookAndFeel((LookAndFeel)lafInstance);
                SwingTools.setIconType(LOOK_AND_FEELS[1]);
                OperatorService.reloadIcons();
            }
            catch (Throwable e) {
                LogService.getGlobal().log("Cannot setup classic look and feel, using default.", 3);
            }
        } else if (lookAndFeel == 0) {
            try {
                System.setProperty("bookmarks.dir", ParameterService.getUserRapidMinerDir().getAbsolutePath());
                System.setProperty(".bookmarks", ".bookmarks");
                UIManager.setLookAndFeel(new RapidLookAndFeel());
                SwingTools.setIconType(LOOK_AND_FEELS[0]);
                OperatorService.reloadIcons();
            }
            catch (Throwable e) {
                e.printStackTrace();
                LogService.getGlobal().log("Cannot setup modern look and feel, using default.", 3);
            }
        } else {
            LogService.getGlobal().log("Unknown look and feel ('" + lookAndFeel + "'), using default.", 3);
        }
    }

    public static void setMainFrame(MainFrame mf) {
        mainFrame = mf;
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    private void performInitialSettings() {
        boolean firstStart = false;
        VersionNumber lastVersionNumber = null;
        VersionNumber currentVersionNumber = new VersionNumber(RapidMinerGUI.getLongVersion());
        File lastVersionFile = new File(ParameterService.getUserRapidMinerDir(), "lastversion");
        if (!lastVersionFile.exists()) {
            firstStart = true;
        } else {
            String versionString;
            block20: {
                versionString = null;
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(lastVersionFile));
                        versionString = in.readLine();
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logWarning("Cannot read global version file of last used version.");
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                LogService.getGlobal().logError("Cannnot close stream to file " + lastVersionFile);
                            }
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LogService.getGlobal().logError("Cannnot close stream to file " + lastVersionFile);
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogService.getGlobal().logError("Cannnot close stream to file " + lastVersionFile);
                    }
                }
            }
            if (versionString != null) {
                lastVersionNumber = new VersionNumber(versionString);
                if (currentVersionNumber.compareTo(lastVersionNumber) > 0) {
                    firstStart = true;
                }
            } else {
                firstStart = true;
            }
        }
        if (firstStart) {
            this.performFirstInitialization(lastVersionNumber, currentVersionNumber);
        }
        this.writeLastVersion(lastVersionFile);
    }

    private void performFirstInitialization(VersionNumber lastVersion, VersionNumber currentVersion) {
        if (currentVersion != null) {
            LogService.getGlobal().logNote("Performing upgrade" + (lastVersion != null ? " from version " + lastVersion : "") + " to version " + currentVersion);
        }
        ParameterService.copyMainUserConfigFile(lastVersion, currentVersion);
        File oldWorkspace = ParameterService.getUserWorkspace();
        String lookAndFeelString = System.getProperty(PROPERTY_RAPIDMINER_GUI_LOOK_AND_FEEL);
        int lookAndFeel = 0;
        if (lookAndFeelString != null && (lookAndFeel = LOOK_AND_FEEL_PARAMETER_TYPE.getIndex(lookAndFeelString)) == -1) {
            LogService.getGlobal().log("Cannot setup look and feel ('" + lookAndFeelString + "'), using default.", 3);
        }
        InitialSettingsDialog dialog = new InitialSettingsDialog(RapidMinerGUI.getSplashScreenFrame(), oldWorkspace, "rm_workspace", null, ParameterService.getRapidMinerHome(), lookAndFeel, true);
        dialog.setVisible(true);
        if (!dialog.isOk()) {
            SwingTools.showVerySimpleErrorMessage("RapidMiner needs a workspace directory in order to properly work.\nUsing default, you can change the workspace in the file menu.");
        }
        String newPath = dialog.getWorkspacePath();
        File newWorkspace = new File(newPath);
        ParameterService.setUserWorkspace(newWorkspace);
        int selectedLookAndFeel = dialog.getSelectedLookAndFeel();
        ParameterService.writePropertyIntoMainUserConfigFile(PROPERTY_RAPIDMINER_GUI_LOOK_AND_FEEL, String.valueOf(selectedLookAndFeel));
    }

    private void writeLastVersion(File versionFile) {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(versionFile));
                out.println(RapidMinerGUI.getLongVersion());
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot write current version into property file.");
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void useProcessFile(Process process) {
        File file = process.getProcessFile();
        if (recentFiles.contains(file = new File(file.getAbsolutePath()))) {
            recentFiles.remove(file);
        }
        recentFiles.addFirst(file);
        while (recentFiles.size() > 8) {
            recentFiles.removeLast();
        }
        RapidMinerGUI.saveRecentFileList();
    }

    public static ResultHistory getResultHistory() {
        return resultHistory;
    }

    public static List<File> getRecentFiles() {
        return recentFiles;
    }

    private static void loadRecentFileList() {
        block14: {
            File file = ParameterService.getUserConfigFile("history");
            if (!file.exists()) {
                return;
            }
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(file));
                    recentFiles.clear();
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        recentFiles.add(new File(line));
                    }
                }
                catch (IOException e) {
                    SwingTools.showSimpleErrorMessage("Cannot read history file", e);
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        SwingTools.showSimpleErrorMessage("Cannot close connection to history file.", e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        SwingTools.showSimpleErrorMessage("Cannot close connection to history file.", e);
                    }
                }
            }
        }
    }

    private static void saveRecentFileList() {
        File file = ParameterService.getUserConfigFile("history");
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(file));
                Iterator i = recentFiles.iterator();
                while (i.hasNext()) {
                    out.println(((File)i.next()).getAbsolutePath());
                }
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("Cannot write history file", e);
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void saveLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(file));
                Calendar currentDate = Calendar.getInstance();
                out.println(currentDate.get(1));
                out.println(currentDate.get(2));
                out.println(currentDate.get(5));
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static Calendar loadLastUpdateCheckDate() {
        Calendar lastCheck;
        block16: {
            File file = ParameterService.getUserConfigFile("updatecheck.date");
            if (!file.exists()) {
                return null;
            }
            lastCheck = null;
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(file));
                    String yearLine = in.readLine();
                    String monthLine = in.readLine();
                    String dayLine = in.readLine();
                    int year = 2001;
                    if (yearLine != null) {
                        year = Integer.parseInt(yearLine.trim());
                    }
                    int month = 1;
                    if (monthLine != null) {
                        month = Integer.parseInt(monthLine.trim());
                    }
                    int day = 1;
                    if (dayLine != null) {
                        day = Integer.parseInt(dayLine.trim());
                    }
                    lastCheck = Calendar.getInstance();
                    lastCheck.set(1, year);
                    lastCheck.set(2, month);
                    lastCheck.set(5, day);
                }
                catch (IOException e) {
                    LogService.getGlobal().logWarning("Cannot read last date of update check.");
                    if (in == null) break block16;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lastCheck;
    }

    public static void checkForUpdates(boolean showFailureDialog) {
        updateManager.checkForUpdates(RapidMinerGUI.getMainFrame(), showFailureDialog);
    }

    private static void saveGUIProperties() {
        Properties properties = new Properties();
        MainFrame mainFrame = RapidMinerGUI.getMainFrame();
        if (mainFrame != null) {
            properties.setProperty(PROPERTY_GEOMETRY_X, "" + (int)mainFrame.getLocation().getX());
            properties.setProperty(PROPERTY_GEOMETRY_Y, "" + (int)mainFrame.getLocation().getY());
            properties.setProperty(PROPERTY_GEOMETRY_WIDTH, "" + mainFrame.getWidth());
            properties.setProperty(PROPERTY_GEOMETRY_HEIGHT, "" + mainFrame.getHeight());
            properties.setProperty(PROPERTY_GEOMETRY_DIVIDER_MAIN, "" + mainFrame.getMainDividerLocation());
            properties.setProperty(PROPERTY_GEOMETRY_DIVIDER_EDITOR, "" + mainFrame.getEditorDividerLocation());
            properties.setProperty(PROPERTY_GEOMETRY_DIVIDER_LOGGING, "" + mainFrame.getLoggingDividerLocation());
            properties.setProperty(PROPERTY_GEOMETRY_DIVIDER_GROUPSELECTION, "" + mainFrame.getGroupSelectionDividerLocation());
            properties.setProperty(PROPERTY_EXPERT_MODE, "" + mainFrame.getPropertyTable().isExpertMode());
            File file = ParameterService.getUserConfigFile("gui.properties");
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    properties.store(out, "RapidMiner GUI properties");
                }
                catch (IOException e) {
                    LogService.getGlobal().logWarning("Cannot write GUI properties: " + e.getMessage());
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException e2) {
                        throw new Error(e2);
                    }
                }
            }
            finally {
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    private static void loadGUIProperties(MainFrame mainFrame) {
        Properties properties = new Properties();
        File file = ParameterService.getUserConfigFile("gui.properties");
        if (file.exists()) {
            block18: {
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        properties.load(in);
                    }
                    catch (IOException e) {
                        RapidMinerGUI.setDefaultGUIProperties();
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            break block18;
                        }
                        catch (IOException e2) {
                            throw new Error(e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            try {
                mainFrame.setLocation(Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_X)), Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_Y)));
                mainFrame.setSize(new Dimension(Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_WIDTH)), Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_HEIGHT))));
                mainFrame.setDividerLocations(Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_DIVIDER_MAIN)), Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_DIVIDER_EDITOR)), Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_DIVIDER_LOGGING)), Integer.parseInt(properties.getProperty(PROPERTY_GEOMETRY_DIVIDER_GROUPSELECTION)));
                mainFrame.getPropertyTable().setExpertMode(Boolean.valueOf(properties.getProperty(PROPERTY_EXPERT_MODE)));
                mainFrame.updateToggleExpertModeIcon();
            }
            catch (NumberFormatException e) {
                RapidMinerGUI.setDefaultGUIProperties();
            }
        } else {
            RapidMinerGUI.setDefaultGUIProperties();
        }
    }

    private static void setDefaultGUIProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mainFrame.setLocation((int)(0.05 * screenSize.getWidth()), (int)(0.05 * screenSize.getHeight()));
        mainFrame.setSize((int)(0.9 * screenSize.getWidth()), (int)(0.9 * screenSize.getHeight()));
        mainFrame.setDividerLocations((int)(0.6 * screenSize.getHeight()), (int)(0.2 * screenSize.getWidth()), (int)(0.75 * screenSize.getWidth()), (int)(0.4 * screenSize.getWidth()));
        mainFrame.getPropertyTable().setExpertMode(false);
        mainFrame.updateToggleExpertModeIcon();
    }

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        File file = null;
        if (args.length > 0) {
            if (args.length != 1) {
                System.out.println("java " + RapidMinerGUI.class.getName() + " [processfile]");
                return;
            }
            file = new File(args[0]);
            if (!file.exists()) {
                System.err.println("File '" + args[0] + "' not found.");
                return;
            }
            if (!file.canRead()) {
                System.err.println("Cannot read file '" + args[0] + "'.");
                return;
            }
        }
        RapidMiner.setInputHandler(new GUIInputHandler());
        new RapidMinerGUI().run(file);
    }

    public static void registerUpdateManager(UpdateManager manager) {
        updateManager = manager;
    }

    protected static class ShutdownHook
    extends Thread {
        protected ShutdownHook() {
        }

        public void run() {
            LogService.getGlobal().log("Running shutdown sequence.", 3);
            RapidMinerGUI.saveRecentFileList();
            RapidMinerGUI.saveGUIProperties();
        }
    }
}

