/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data2Log
extends Operator {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    private Object currentValue = null;
    private boolean isNominal = false;

    public Data2Log(OperatorDescription description) {
        super(description);
        this.addValue(new Value("data_value", "The value from the data which should be logged."){

            public Object getValue() {
                return Data2Log.this.currentValue;
            }

            public boolean isNominal() {
                return Data2Log.this.isNominal;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        int index = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
        if (index == 0) {
            throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
        }
        index = index < 0 ? exampleSet.size() + index : --index;
        if (index >= exampleSet.size()) {
            throw new UserError((Operator)this, 110, index);
        }
        Example example = exampleSet.getExample(index);
        if (attribute.isNominal() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
            this.currentValue = example.getValueAsString(attribute);
            this.isNominal = true;
        } else {
            this.currentValue = example.getValue(attribute);
            this.isNominal = false;
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The attribute from which the value should be taken.", false));
        types.add(new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example from which the value should be taken. Negative indices are counted from the end of the data set. Positive counting starts with 1, negative counting with -1.", -2147483647, Integer.MAX_VALUE, false));
        return types;
    }
}

