/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.tools.Ontology;

public class SingleAttributes2ValueSeries
extends AbstractSeriesProcessing {
    public SingleAttributes2ValueSeries(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int valueType = 0;
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (a == 0) {
                valueType = attribute.getValueType();
            }
            if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 1)) {
                throw new UserError((Operator)this, 121, attribute, Ontology.BLOCK_TYPE_NAMES[attribute.getBlockType()], Ontology.BLOCK_TYPE_NAMES[1]);
            }
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), valueType)) {
                throw new UserError((Operator)this, 120, attribute, Ontology.VALUE_TYPE_NAMES[attribute.getValueType()], Ontology.VALUE_TYPE_NAMES[valueType]);
            }
            if (a == 0) {
                attribute.setBlockType(3);
            } else if (a == exampleSet.getAttributes().size() - 1) {
                attribute.setBlockType(4);
            } else {
                attribute.setBlockType(2);
            }
            this.checkForStop();
            ++a;
        }
        return exampleSet;
    }
}

