/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.AbstractCriterion;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;

public class GiniIndexCriterion
extends AbstractCriterion {
    private FrequencyCalculator frequencyCalculator = new FrequencyCalculator();

    public double getNominalBenefit(ExampleSet exampleSet, Attribute attribute) {
        double[][] weightCounts = this.frequencyCalculator.getNominalWeightCounts(exampleSet, attribute);
        return this.getBenefit(weightCounts);
    }

    public double getNumericalBenefit(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        double[][] weightCounts = this.frequencyCalculator.getNumericalWeightCounts(exampleSet, attribute, splitValue);
        return this.getBenefit(weightCounts);
    }

    public double getBenefit(double[][] weightCounts) {
        double[] classWeights = new double[weightCounts[0].length];
        int l = 0;
        while (l < classWeights.length) {
            int v = 0;
            while (v < weightCounts.length) {
                int n = l;
                classWeights[n] = classWeights[n] + weightCounts[v][l];
                ++v;
            }
            ++l;
        }
        double totalClassWeight = this.frequencyCalculator.getTotalWeight(classWeights);
        double totalEntropy = this.getGiniIndex(classWeights, totalClassWeight);
        double gain = 0.0;
        int v = 0;
        while (v < weightCounts.length) {
            double[] partitionWeights = weightCounts[v];
            double partitionWeight = this.frequencyCalculator.getTotalWeight(partitionWeights);
            gain += this.getGiniIndex(partitionWeights, partitionWeight) * partitionWeight / this.totalWeight;
            ++v;
        }
        return totalEntropy - gain;
    }

    private double getGiniIndex(double[] labelWeights, double totalWeight) {
        double sum = 0.0;
        int i = 0;
        while (i < labelWeights.length) {
            double frequency = labelWeights[i] / totalWeight;
            sum += frequency * frequency;
            ++i;
        }
        return 1.0 - sum;
    }

    public boolean supportsIncrementalCalculation() {
        return true;
    }

    public double getIncrementalBenefit() {
        double totalGiniEntropy = this.getGiniIndex(this.totalLabelWeights, this.totalWeight);
        double gain = this.getGiniIndex(this.leftLabelWeights, this.leftWeight) * this.leftWeight / this.totalWeight;
        return totalGiniEntropy - (gain += this.getGiniIndex(this.rightLabelWeights, this.rightWeight) * this.rightWeight / this.totalWeight);
    }
}

