/*
 * Decompiled with CFR 0.152.
 */
package uiuc.oai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;
import uiuc.oai.OAIError;
import uiuc.oai.OAIException;
import uiuc.oai.OAIMetadataFormatList;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRecordList;
import uiuc.oai.OAIResumptionStream;
import uiuc.oai.OAISetList;

public class OAIRepository {
    private String strRepositoryId;
    private String strRepositoryName;
    private String strBaseURL = "";
    private String[] strAdminEmail;
    private String[] strCompression;
    private String strEarliestDatestamp;
    private String strDeletedRecord;
    private String strGranularity;
    private String strProtocolVersion;
    private String strUserAgent = "OAIHarvester University of Illinois Library";
    private String strFrom = "someone@somewhere.edu";
    private String strUser = "";
    private String strPassword = "";
    private String strResponseDate;
    private String sRawResponse;
    private NodeList ixmlDescriptions;
    private NodeList ixmlErrors;
    private Node ixmlRequest;
    private Element descrNamespaceNode;
    private Element namespaceNode;
    private int validation = 0;
    private int state = 0;
    private int iRetryLimit = 5;
    private int iMaxRetryMinutes = 60;
    public final int STATE_UNIDENTIFIED = 0;
    public final int STATE_IDENTIFIED = 1;
    public static final int VALIDATION_STRICT = 0;
    public static final int VALIDATION_VERY_STRICT = 1;
    public static final int VALIDATION_LOOSE = 2;
    public static String XMLNS_DC = "http://purl.org/dc/elements/1.1/";
    public static String XMLNS_RFC1807 = "http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt";
    public static String XMLNS_OAI_MARC = "http://www.openarchives.org/OAI/1.1/oai_marc";
    public static String XMLNS_OAI = "http://www.openarchives.org/OAI/1.1/OAI_";
    public static String XMLNS_ID = "http://www.openarchives.org/OAI/1.1/oai-identifier";
    public static String XMLNS_EPR = "http://www.openarchives.org/OAI/1.1/eprints";
    public static String XMLNS_OAI_2_0 = "http://www.openarchives.org/OAI/2.0/";
    public static String XMLNS_OAI_DC_2_0 = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    public static String XMLNS_ID_2_0 = "http://www.openarchives.org/OAI/2.0/oai-identifier/";
    public static String XMLNS_OAI_1_0 = "http://www.openarchives.org/OAI/1.0/OAI_";
    public static String XMLNS_ID_1_0 = "http://www.openarchives.org/OAI/oai-identifier";
    public static String XMLNS_EPR_1_0 = "http://www.openarchives.org/OAI/eprints";
    public static String XMLNS_OAI_MARC_1_0 = "http://www.openarchives.org/OAI/oai_marc";
    public static String XMLNS_ID_1_0_aps = "http://www.openarchives.org/OAI/oai-identifier.xsd";

    public void setBaseURL(String string) throws OAIException {
        this.strBaseURL = string;
        this.identify();
    }

    public String getBaseURL() throws OAIException {
        this.priCheckBaseURL();
        return this.strBaseURL;
    }

    private InputSource priCreateDummyGetRecord(String string, InputStream inputStream) throws OAIException {
        String string2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd");
        if (this.getProtocolMajorVersion() < 2) {
            string2 = "<GetRecord \n";
            string2 = string2 + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string2 = string2 + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_GetRecord' \n";
            string2 = string2 + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_GetRecord ";
            string2 = string2 + "http://www.openarchives.org/OAI/1.1/OAI_GetRecord.xsd'>\n";
            string2 = string2 + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate>\n";
            string2 = string2 + "<requestURL>junk:GetRecord</requestURL>\n";
            string2 = string2 + "<record>\n";
            string2 = string2 + "<header>\n";
            string2 = string2 + "<identifier>" + string + "</identifier>\n";
            string2 = string2 + "<datestamp>" + simpleDateFormat.format(new Date()) + "</datestamp>\n";
            string2 = string2 + "</header>\n";
            string2 = string2 + "<about>\n";
            string2 = string2 + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(inputStream) + "]]></junk:junk>\n";
            string2 = string2 + "</about>\n";
            string2 = string2 + "</record>\n";
            string2 = string2 + "</GetRecord>";
        } else {
            string2 = "<OAI-PMH \n";
            string2 = string2 + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string2 = string2 + "xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string2 = string2 + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string2 = string2 + "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd'>\n";
            string2 = string2 + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate>\n";
            string2 = string2 + "<request>junk:GetRecord</request>\n";
            string2 = string2 + "<GetRecord>\n";
            string2 = string2 + "<record>\n";
            string2 = string2 + "<header>\n";
            string2 = string2 + "<identifier>" + string + "</identifier>\n";
            string2 = string2 + "<datestamp>" + simpleDateFormat.format(new Date()) + "</datestamp>\n";
            string2 = string2 + "</header>\n";
            string2 = string2 + "<about>\n";
            string2 = string2 + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(inputStream) + "]]></junk:junk>\n";
            string2 = string2 + "</about>\n";
            string2 = string2 + "</record>\n";
            string2 = string2 + "</GetRecord>\n";
            string2 = string2 + "</OAI-PMH>";
        }
        StringReader stringReader = new StringReader(string2);
        return new InputSource(stringReader);
    }

    private InputSource priCreateDummyIdentify(InputStream inputStream) throws OAIException {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd");
        if (this.getProtocolMajorVersion() < 2) {
            string = "<Identify \n";
            string = string + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_Identify' \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_Identify ";
            string = string + "http://www.openarchives.org/OAI/1.1/OAI_Identify.xsd'> \n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
            string = string + "<requestURL>junk:Identify</requestURL> \n";
            string = string + "<repositoryName>UNKNOWN</repositoryName> \n";
            string = string + "<baseURL>" + this.strBaseURL + "</baseURL> \n";
            string = string + "<protocolVersion>UNKNOWN</protocolVersion> \n";
            string = string + "<adminEmail>mailto:UNKNOWN</adminEmail> \n";
            string = string + "<description>\n";
            string = string + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(inputStream) + "]]></junk:junk>\n";
            string = string + "</description>\n";
            string = string + "</Identify>";
        } else {
            string = "<OAI-PMH \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string = string + "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd'>\n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate>\n";
            string = string + "<request>junk:Identify</request>\n";
            string = string + "<Identify>\n";
            string = string + "<repositoryName>UNKNOWN</repositoryName> \n";
            string = string + "<baseURL>" + this.strBaseURL + "</baseURL> \n";
            string = string + "<protocolVersion>UNKNOWN</protocolVersion> \n";
            string = string + "<adminEmail>mailto:UNKNOWN</adminEmail> \n";
            string = string + "<description>\n";
            string = string + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(inputStream) + "]]></junk:junk>\n";
            string = string + "</description>\n";
            string = string + "</Identify>\n";
            string = string + "</OAI-PMH>";
        }
        StringReader stringReader = new StringReader(string);
        return new InputSource(stringReader);
    }

    protected void frndSetErrors(NodeList nodeList) {
        this.ixmlErrors = nodeList;
    }

    protected void frndSetRepositoryID(String string) {
        this.strRepositoryId = string;
    }

    protected void frndSetRequest(Node node) {
        this.ixmlRequest = node;
    }

    protected void frndSetResponseDate(String string) {
        this.strResponseDate = string;
    }

    protected String frndGetRawResponse() {
        return this.sRawResponse;
    }

    protected String frndGetUser() {
        return this.strUser;
    }

    protected String frndGetPassword() {
        return this.strPassword;
    }

    public void setBasicAuthorization(String string, String string2) {
        this.strUser = string;
        this.strPassword = string2;
    }

    public OAIError getLastOAIError() throws OAIException {
        return this.getLastOAIError(0);
    }

    public OAIError getLastOAIError(int n) throws OAIException {
        OAIError oAIError = null;
        if (this.getLastOAIErrorCount() > 0 && n < this.getLastOAIErrorCount()) {
            oAIError = new OAIError();
            Node node = this.ixmlErrors.item(n);
            oAIError.frndSetCode(node.getAttributes().getNamedItem("code").getNodeValue());
            oAIError.frndSetReason(node.getFirstChild().getNodeValue());
        }
        return oAIError;
    }

    public int getLastOAIErrorCount() {
        if (this.ixmlErrors != null) {
            return this.ixmlErrors.getLength();
        }
        return 0;
    }

    public String getRequestVerb() {
        String string = "";
        int n = this.getRequestURL().indexOf("verb=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 5, n2);
        }
        return string;
    }

    public String getRequestIdentifier() {
        String string = "";
        int n = this.getRequestURL().indexOf("identifier=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 11, n2);
        }
        return string;
    }

    public String getRequestMetadataPrefix() {
        String string = "";
        int n = this.getRequestURL().indexOf("metadataPrefix=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 15, n2);
        }
        return string;
    }

    public String getRequestFrom() {
        String string = "";
        int n = this.getRequestURL().indexOf("from=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 5, n2);
        }
        return string;
    }

    public String getRequestUntil() {
        String string = "";
        int n = this.getRequestURL().indexOf("until=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 6, n2);
        }
        return string;
    }

    public String getRequestSet() {
        String string = "";
        int n = this.getRequestURL().indexOf("set=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 4, n2);
        }
        return string;
    }

    public String getRequestResumptionToken() {
        String string = "";
        int n = this.getRequestURL().indexOf("resumptionToken=");
        if (n >= 0) {
            int n2 = this.getRequestURL().indexOf("&", n);
            if (n2 <= 0) {
                n2 = this.getRequestURL().length();
            }
            string = this.getRequestURL().substring(n + 16, n2);
        }
        return string;
    }

    public int getAdminEmailCount() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.strAdminEmail == null) {
            return 0;
        }
        return this.strAdminEmail.length;
    }

    public int getCompressionCount() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.strCompression == null) {
            return 0;
        }
        return this.strCompression.length;
    }

    public String getEarliestDatestamp() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'EarliestDateStamp' is not supporeted.");
        }
        return this.strEarliestDatestamp;
    }

    public String getDeletedRecord() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'DeletedRecord' is not supported.");
        }
        return this.strDeletedRecord;
    }

    public String getGranularity() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        String string = this.getProtocolMajorVersion() < 2 ? "YYYY-MM-DD" : (this.strGranularity != null ? this.strGranularity : "YYYY-MM-DD");
        return string;
    }

    public String getResponseDate() {
        return this.strResponseDate;
    }

    public String getRequestBaseURL() {
        String string = this.ixmlRequest.getFirstChild().getNodeValue();
        if (string.endsWith("?")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public int getMaxRetryMinutes() {
        return this.iMaxRetryMinutes;
    }

    public void setMaxRetryMinutes(int n) {
        this.iMaxRetryMinutes = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String frndMyEncode(InputStream inputStream) throws OAIException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = "";
            String string2 = "";
            int n = 0;
            block2: while (true) {
                if ((string = bufferedReader.readLine()) == null) {
                    return string2;
                }
                while (true) {
                    if ((n = string.indexOf("]]>", n)) < 0) {
                        string2 = string2 + string + "\n";
                        continue block2;
                    }
                    string = string.substring(0, n + 2) + "&gt;" + string.substring(n + 2);
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
    }

    protected void frndSetNamespaceNode(Element element) {
        this.namespaceNode = element;
    }

    protected Element getNamespaceNode() {
        return this.namespaceNode;
    }

    private String priBuildParamString(String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        if (string != null && string.length() > 0) {
            string6 = string6 + "&until=" + string;
        }
        if (string2 != null && string2.length() > 0) {
            string6 = string6 + "&from=" + string2;
        }
        if (string3 != null && string3.length() > 0) {
            string6 = string6 + "&set=" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string6 = string6 + "&identifier=" + string4;
        }
        if (string5 != null && string5.length() > 0) {
            string6 = string6 + "&metadataPrefix=" + string5;
        }
        return string6;
    }

    private void priCheckBaseURL() throws OAIException {
        if (this.strBaseURL == null || this.strBaseURL.length() == 0) {
            throw new OAIException(6, "No BaseURL");
        }
    }

    public Node getDescription() throws OAIException {
        return this.getDescription(0);
    }

    public Node getDescription(int n) throws OAIException {
        Node node = null;
        if (this.state == 0) {
            this.identify();
        }
        if (this.ixmlDescriptions.getLength() > 0 && n < this.ixmlDescriptions.getLength()) {
            node = this.ixmlDescriptions.item(n);
        }
        return node;
    }

    public int getDescriptionCount() {
        return this.ixmlDescriptions.getLength();
    }

    public OAIRecord getRecord(String string) throws OAIException {
        return this.getRecord(string, "oai_dc");
    }

    public OAIRecord getRecord(String string, String string2) throws OAIException {
        OAIRecord oAIRecord = new OAIRecord();
        this.priCheckBaseURL();
        String string3 = this.priBuildParamString("", "", "", string, string2);
        try {
            URL uRL = new URL(this.strBaseURL + "?verb=GetRecord" + string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection = this.frndTrySend(httpURLConnection);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (this.validation == 1) {
                documentBuilderFactory.setValidating(true);
            } else {
                documentBuilderFactory.setValidating(false);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            try {
                document = documentBuilder.parse(httpURLConnection.getInputStream());
                oAIRecord.frndSetValid(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OAIException(14, illegalArgumentException.getMessage());
            }
            catch (SAXException sAXException) {
                if (this.validation != 2) {
                    throw new OAIException(13, sAXException.getMessage());
                }
                try {
                    uRL = new URL(this.strBaseURL + "?verb=GetRecord" + string3);
                    httpURLConnection.disconnect();
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection = this.frndTrySend(httpURLConnection);
                    document = documentBuilder.parse(this.priCreateDummyGetRecord(string, httpURLConnection.getInputStream()));
                    oAIRecord.frndSetValid(false);
                }
                catch (SAXException sAXException2) {
                    throw new OAIException(13, sAXException2.getMessage());
                }
            }
            try {
                this.namespaceNode = document.createElement("GetRecord");
                this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI + "GetRecord");
                this.namespaceNode.setAttribute("xmlns:dc", XMLNS_DC);
                PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                XPath xPath = new XPath("/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolverDefault, 0, null);
                XPathContext xPathContext = new XPathContext();
                int n = xPathContext.getDTMHandleFromNode((Node)document);
                XObject xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                Node node = xObject.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI_2_0);
                    prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                    xPath = new XPath("/oai:OAI-PMH/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node == null) {
                        this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI_1_0 + "GetRecord");
                        prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                        xPath = new XPath("/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolverDefault, 0, null);
                        xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                        node = xObject.nodeset().nextNode();
                    } else {
                        xPath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolverDefault, 0, null);
                        xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                        this.ixmlErrors = xObject.nodelist();
                        if (this.ixmlErrors.getLength() > 0) {
                            this.strProtocolVersion = "2";
                            throw new OAIException(15, this.getLastOAIError().getCode() + ": " + this.getLastOAIError().getReason());
                        }
                    }
                }
                if (node != null) {
                    oAIRecord.frndSetRepository(this);
                    oAIRecord.frndSetMetadataPrefix(string2);
                    oAIRecord.frndSetIdOnly(false);
                    n = xPathContext.getDTMHandleFromNode(node);
                    xPath = new XPath("//oai:header/oai:identifier", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    oAIRecord.frndSetIdentifier(xObject.nodeset().nextNode().getFirstChild().getNodeValue());
                    xPath = new XPath("//oai:header/oai:datestamp", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    oAIRecord.frndSetDatestamp(xObject.nodeset().nextNode().getFirstChild().getNodeValue());
                    oAIRecord.frndSetRecord(node);
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    if (namedNodeMap != null && namedNodeMap.getNamedItem("status") != null) {
                        oAIRecord.frndSetStatus(namedNodeMap.getNamedItem("status").getFirstChild().getNodeValue());
                    }
                } else {
                    oAIRecord = null;
                }
                if ((node = (xObject = (xPath = new XPath("//oai:responseDate", null, (PrefixResolver)prefixResolverDefault, 0, null)).execute(xPathContext, n, (PrefixResolver)prefixResolverDefault)).nodeset().nextNode()) != null) {
                    this.strResponseDate = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strResponseDate = "";
                } else {
                    throw new OAIException(4, "GetRecord missing responseDate");
                }
                xPath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node != null) {
                    this.ixmlRequest = node;
                } else if (this.validation == 2) {
                    this.ixmlRequest = null;
                } else {
                    throw new OAIException(4, "GetRecord missing requestURL");
                }
                xPath = null;
                prefixResolverDefault = null;
                xPathContext = null;
                xObject = null;
            }
            catch (TransformerException transformerException) {
                throw new OAIException(14, transformerException.getMessage());
            }
            uRL = null;
            documentBuilderFactory = null;
            documentBuilder = null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAIException(14, malformedURLException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new OAIException(14, factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OAIException(14, parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
        return oAIRecord;
    }

    public String identify() throws OAIException {
        return this.identify(this.strBaseURL);
    }

    public String identify(String string) throws OAIException {
        boolean bl = false;
        this.priCheckBaseURL();
        try {
            URL uRL = new URL(string + "?verb=Identify");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection = this.frndTrySend(httpURLConnection);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (this.validation == 1) {
                documentBuilderFactory.setValidating(true);
            } else {
                documentBuilderFactory.setValidating(false);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            try {
                document = documentBuilder.parse(httpURLConnection.getInputStream());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OAIException(14, illegalArgumentException.getMessage());
            }
            catch (SAXException sAXException) {
                if (this.validation != 2) {
                    throw new OAIException(13, sAXException.getMessage());
                }
                try {
                    uRL = new URL(string + "?verb=Identify");
                    httpURLConnection.disconnect();
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection = this.frndTrySend(httpURLConnection);
                    document = documentBuilder.parse(this.priCreateDummyIdentify(httpURLConnection.getInputStream()));
                }
                catch (SAXException sAXException2) {
                    throw new OAIException(13, sAXException2.getMessage());
                }
            }
            try {
                this.descrNamespaceNode = document.createElement("Identify");
                this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI + "Identify");
                this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID);
                this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR);
                PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                XPathContext xPathContext = new XPathContext();
                int n = xPathContext.getDTMHandleFromNode((Node)document);
                XPath xPath = new XPath("/oai_id:Identify", null, (PrefixResolver)prefixResolverDefault, 0, null);
                XObject xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                Node node = xObject.nodeset().nextNode();
                if (node == null) {
                    this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI_2_0);
                    this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID_2_0);
                    this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR);
                    prefixResolverDefault = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                    xPath = new XPath("/oai_id:OAI-PMH", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node == null) {
                        this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI_1_0 + "Identify");
                        this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID_1_0);
                        this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR_1_0);
                        prefixResolverDefault = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                    } else {
                        xPath = new XPath("oai_id:OAI-PMH/oai_id:error", null, (PrefixResolver)prefixResolverDefault, 0, null);
                        xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                        this.ixmlErrors = xObject.nodelist();
                        if (this.getLastOAIErrorCount() > 0) {
                            this.strProtocolVersion = "2";
                            throw new OAIException(15, this.getLastOAIError().getCode() + ": " + this.getLastOAIError().getReason());
                        }
                        bl = true;
                    }
                }
                if ((node = (xObject = (xPath = new XPath("//oai_id:repositoryName", null, (PrefixResolver)prefixResolverDefault, 0, null)).execute(xPathContext, n, (PrefixResolver)prefixResolverDefault)).nodeset().nextNode()) != null) {
                    this.strRepositoryName = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strRepositoryName = "UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing repositoryName");
                }
                xPath = new XPath("//oai_id:baseURL", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node != null) {
                    this.strBaseURL = node.getFirstChild().getNodeValue();
                } else if (this.validation != 2) {
                    throw new OAIException(4, "Identify missing baseURL");
                }
                xPath = new XPath("//oai_id:protocolVersion", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node != null) {
                    this.strProtocolVersion = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strProtocolVersion = "UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing protocolVersion");
                }
                xPath = new XPath("//oai_id:adminEmail", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                NodeList nodeList = xObject.nodelist();
                if (nodeList.getLength() > 0) {
                    this.strAdminEmail = new String[nodeList.getLength()];
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        this.strAdminEmail[n2] = nodeList.item(n2).getFirstChild().getNodeValue();
                        ++n2;
                    }
                } else if (this.validation == 2) {
                    this.strAdminEmail = new String[1];
                    this.strAdminEmail[0] = "mailto:UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing adminEmail");
                }
                if (bl) {
                    xPath = new XPath("//oai_id:earliestDatestamp", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node != null) {
                        this.strEarliestDatestamp = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strEarliestDatestamp = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing earliestDatestamp");
                    }
                    xPath = new XPath("//oai_id:deletedRecord", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node != null) {
                        this.strDeletedRecord = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strDeletedRecord = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing deletedRecordp");
                    }
                    xPath = new XPath("//oai_id:granularity", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node != null) {
                        this.strGranularity = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strGranularity = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing granularity");
                    }
                    xPath = new XPath("//oai_id:compression", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    nodeList = xObject.nodelist();
                    if (nodeList.getLength() > 0) {
                        this.strCompression = new String[nodeList.getLength()];
                        int n3 = 0;
                        while (n3 < nodeList.getLength()) {
                            this.strCompression[n3] = nodeList.item(n3).getFirstChild().getNodeValue();
                            ++n3;
                        }
                    }
                }
                xPath = new XPath("//oai_id:description", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                this.ixmlDescriptions = xObject.nodelist();
                xPath = new XPath("//oai_id:responseDate", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node != null) {
                    this.strResponseDate = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strResponseDate = "";
                } else {
                    throw new OAIException(4, "GetRecord missing responseDate");
                }
                xPath = new XPath("//oai_id:requestURL | //oai_id:request", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node != null) {
                    this.ixmlRequest = node;
                } else if (this.validation == 2) {
                    this.ixmlRequest = null;
                } else {
                    throw new OAIException(4, "GetRecord missing requestURL");
                }
                this.state = 1;
                xPath = null;
                prefixResolverDefault = null;
                xPathContext = null;
                xObject = null;
            }
            catch (TransformerException transformerException) {
                throw new OAIException(14, transformerException.getMessage());
            }
            uRL = null;
            documentBuilderFactory = null;
            documentBuilder = null;
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new OAIException(14, factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OAIException(14, parserConfigurationException.getMessage());
        }
        return this.strRepositoryName;
    }

    public OAIRecordList listIdentifiers() throws OAIException {
        return this.listIdentifiers("", "", "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String string) throws OAIException {
        return this.listIdentifiers(string, "", "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String string, String string2) throws OAIException {
        return this.listIdentifiers(string, string2, "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String string, String string2, String string3) throws OAIException {
        return this.listIdentifiers(string, string2, string3, "oai_dc");
    }

    public OAIRecordList listIdentifiers(String string, String string2, String string3, String string4) throws OAIException {
        this.priCheckBaseURL();
        String string5 = string4;
        if (this.getProtocolMajorVersion() > 1 && string4.length() == 0) {
            string5 = "oai_dc";
        }
        String string6 = this.priBuildParamString(string, string2, string3, "", string5);
        OAIResumptionStream oAIResumptionStream = new OAIResumptionStream(this, this.strBaseURL, "ListIdentifiers", string6);
        OAIRecordList oAIRecordList = new OAIRecordList();
        oAIRecordList.frndSetOAIResumptionStream(oAIResumptionStream);
        return oAIRecordList;
    }

    public OAIRecordList listRecords() throws OAIException {
        return this.listRecords("oai_dc", "", "", "");
    }

    public OAIRecordList listRecords(String string) throws OAIException {
        return this.listRecords(string, "", "", "");
    }

    public OAIRecordList listRecords(String string, String string2) throws OAIException {
        return this.listRecords(string, string2, "", "");
    }

    public OAIRecordList listRecords(String string, String string2, String string3) throws OAIException {
        return this.listRecords(string, string2, string3, "");
    }

    public OAIRecordList listRecords(String string, String string2, String string3, String string4) throws OAIException {
        this.priCheckBaseURL();
        String string5 = string;
        string5 = string.length() == 0 ? "oai_dc" : string;
        String string6 = this.priBuildParamString(string2, string3, string4, "", string5);
        OAIResumptionStream oAIResumptionStream = new OAIResumptionStream(this, this.strBaseURL, "ListRecords", string6);
        OAIRecordList oAIRecordList = new OAIRecordList();
        oAIRecordList.frndSetOAIResumptionStream(oAIResumptionStream);
        oAIRecordList.frndSetMetadataPrefix(string);
        return oAIRecordList;
    }

    public String getRepositoryIdentifier() throws OAIException {
        String string = "";
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier() && this.strRepositoryId.length() == 0 && this.validation == 1) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        if (!this.usesOAIIdentifier() && this.strRepositoryId.length() == 0) {
            return string;
        }
        try {
            int n = 0;
            while (n < this.ixmlDescriptions.getLength()) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(n), (String)"//oai_id:description/id:oai-identifier/id:repositoryIdentifier", (Node)this.descrNamespaceNode);
                if (node != null) {
                    string = node.getFirstChild().getNodeValue();
                }
                ++n;
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return string;
    }

    public Node getOAIIdentifierDescription() throws OAIException {
        Node node = null;
        Node node2 = null;
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier()) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        int n = 0;
        while (n < this.ixmlDescriptions.getLength()) {
            node = this.ixmlDescriptions.item(n);
            if (node.getNamespaceURI().equals(XMLNS_ID) || node.getNamespaceURI().equals(XMLNS_ID_1_0) || node.getNamespaceURI().equals("XMLNS_ID_1_0_aps")) {
                node2 = node;
                break;
            }
            ++n;
        }
        return node2;
    }

    public Node getEPrintsDescription() throws OAIException {
        Node node = null;
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier()) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        int n = 0;
        while (n < this.ixmlDescriptions.getLength()) {
            Node node2 = this.ixmlDescriptions.item(n);
            if (node2.getNamespaceURI().equals(XMLNS_EPR) || node2.getNamespaceURI().equals(XMLNS_EPR_1_0)) {
                node = node2;
                break;
            }
            ++n;
        }
        return node;
    }

    public void setRetryLimit(int n) {
        this.iRetryLimit = n;
    }

    public int getRetryLimit() {
        return this.iRetryLimit;
    }

    public String getSampleIdentifier() throws OAIException {
        String string = "";
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier() && this.validation == 1) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        if (!this.usesOAIIdentifier()) {
            return string;
        }
        try {
            int n = 0;
            while (n < this.ixmlDescriptions.getLength()) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(n), (String)"//oai_id:description/id:oai-identifier/id:sampleIdentifier", (Node)this.descrNamespaceNode);
                if (string != null) {
                    string = node.getFirstChild().getNodeValue();
                }
                ++n;
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return string;
    }

    public String getRepositoryName() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.strRepositoryName;
    }

    public String getAdminEmail() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.getAdminEmail(0);
    }

    public String getAdminEmail(int n) throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getAdminEmailCount() > 0 && n < this.getAdminEmailCount()) {
            return this.strAdminEmail[n];
        }
        return "";
    }

    public String getCompression() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.getCompression(0);
    }

    public String getCompression(int n) throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getCompressionCount() > 0 && n < this.getCompressionCount()) {
            return this.strCompression[n];
        }
        return "";
    }

    public int getProtocolMajorVersion() throws OAIException {
        int n = 0;
        if (this.state == 0) {
            this.identify();
        }
        try {
            n = Integer.parseInt(this.strProtocolVersion.trim().substring(0, 1));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public String getProtocolVersion() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.strProtocolVersion;
    }

    public String getRequestURL() {
        String string;
        block8: {
            string = this.ixmlRequest.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = this.ixmlRequest.getAttributes();
            Node node = namedNodeMap.getNamedItem("verb");
            if (node != null) {
                string = string + "?verb=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("identifier")) != null) {
                string = string + "&identifier=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("metadataPrefix")) != null) {
                string = string + "&metadataPrefix=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("from")) != null) {
                string = string + "&from=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("until")) != null) {
                string = string + "&until=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("set")) != null) {
                string = string + "&set=" + node.getNodeValue();
            }
            if ((node = namedNodeMap.getNamedItem("resumptionToken")) == null) break block8;
            try {
                string = string + "&resumptionToken=" + URLEncoder.encode(node.getNodeValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = string + "&resumptionToken=" + node.getNodeValue();
            }
        }
        return string;
    }

    public String getUserAgent() {
        return this.strUserAgent;
    }

    public void setUserAgent(String string) {
        this.strUserAgent = string;
    }

    public String getFrom() {
        return this.strFrom;
    }

    public void setFrom(String string) {
        this.strFrom = string;
    }

    protected HttpURLConnection frndTrySend(HttpURLConnection httpURLConnection) throws OAIException {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        boolean bl = false;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        GregorianCalendar gregorianCalendar3 = null;
        int n = 0;
        do {
            try {
                Object object;
                httpURLConnection2.setRequestProperty("User-Agent", this.strUserAgent);
                httpURLConnection2.setRequestProperty("From", this.strFrom);
                if (this.strUser != null && this.strUser.length() > 0) {
                    byte[] byArray = (this.strUser + ":" + this.strPassword).getBytes();
                    object = new BASE64Encoder();
                    httpURLConnection2.setRequestProperty("Authorization", "Basic " + object.encode(byArray));
                }
                gregorianCalendar.setTime(new Date());
                httpURLConnection2.connect();
                if (httpURLConnection2.getResponseCode() == 200) {
                    bl = true;
                    continue;
                }
                if (httpURLConnection2.getResponseCode() == 503) {
                    if (++n > this.iRetryLimit) {
                        throw new OAIException(11, "The RetryLimit " + this.iRetryLimit + " has been exceeded");
                    }
                    String string = httpURLConnection2.getHeaderField("Retry-After");
                    if (string == null) {
                        throw new OAIException(10, "No Retry-After header");
                    }
                    try {
                        int n2 = Integer.parseInt(string);
                        gregorianCalendar.add(13, n2);
                        gregorianCalendar3 = gregorianCalendar;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            object = DateFormat.getDateInstance().parse(string);
                            gregorianCalendar3 = new GregorianCalendar();
                            gregorianCalendar3.setTime((Date)object);
                        }
                        catch (ParseException parseException) {
                            throw new OAIException(14, parseException.getMessage());
                        }
                    }
                    if (gregorianCalendar3 != null) {
                        gregorianCalendar2.setTime(new Date());
                        gregorianCalendar2.add(12, this.iMaxRetryMinutes);
                        if (gregorianCalendar3.getTime().before(gregorianCalendar2.getTime())) {
                            try {
                                while (gregorianCalendar3.getTime().after(new Date())) {
                                    Thread.sleep(10000L);
                                }
                                URL uRL = new URL(httpURLConnection2.getURL().toString());
                                httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                throw new OAIException(14, interruptedException.getMessage());
                            }
                        }
                        throw new OAIException(10, "Retry time(" + string + " sec) is too long");
                    }
                    throw new OAIException(10, string + " is not a valid Retry-After header");
                }
                if (httpURLConnection2.getResponseCode() == 403) {
                    throw new OAIException(14, httpURLConnection2.getResponseMessage());
                }
                if (++n > this.iRetryLimit) {
                    throw new OAIException(11, "The RetryLimit " + this.iRetryLimit + " has been exceeded");
                }
                int n3 = 10 * (int)Math.exp(n);
                gregorianCalendar.add(13, n3);
                gregorianCalendar3 = gregorianCalendar;
                try {
                    while (gregorianCalendar3.getTime().after(new Date())) {
                        Thread.sleep(n3 * 1000);
                    }
                    object = new URL(httpURLConnection2.getURL().toString());
                    httpURLConnection2 = (HttpURLConnection)((URL)object).openConnection();
                }
                catch (InterruptedException interruptedException) {
                    throw new OAIException(14, interruptedException.getMessage());
                }
            }
            catch (IOException iOException) {
                throw new OAIException(14, iOException.getMessage());
            }
        } while (!bl);
        return httpURLConnection2;
    }

    public boolean usesOAIIdentifier() throws OAIException {
        boolean bl = false;
        if (this.state == 0) {
            this.identify();
        }
        try {
            int n = 0;
            while (n < this.ixmlDescriptions.getLength()) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(n), (String)"//oai_id:description/*", (Node)this.descrNamespaceNode);
                if (node != null && (node.getNamespaceURI().equals(XMLNS_ID) || node.getNamespaceURI().equals(XMLNS_ID_1_0) || node.getNamespaceURI().equals("XMLNS_ID_1_0_aps"))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return bl;
    }

    public boolean usesEPrints() throws OAIException {
        boolean bl = false;
        if (this.state == 0) {
            this.identify();
        }
        try {
            int n = 0;
            while (n < this.ixmlDescriptions.getLength()) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(n), (String)"//oai_id:description/*", (Node)this.descrNamespaceNode);
                if (node != null && (node.getNamespaceURI().equals(XMLNS_EPR) || node.getNamespaceURI().equals(XMLNS_EPR_1_0))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return bl;
    }

    public int getValidation() {
        return this.validation;
    }

    public void setValidation(int n) {
        this.validation = n;
    }

    public OAIMetadataFormatList listMetadataFormats() throws OAIException {
        return this.listMetadataFormats("");
    }

    public OAIMetadataFormatList listMetadataFormats(String string) throws OAIException {
        OAIMetadataFormatList oAIMetadataFormatList = new OAIMetadataFormatList();
        this.priCheckBaseURL();
        String string2 = this.priBuildParamString("", "", "", string, "");
        OAIResumptionStream oAIResumptionStream = new OAIResumptionStream(this, this.strBaseURL, "ListMetadataFormats", string2);
        oAIMetadataFormatList.frndSetOAIResumptionStream(oAIResumptionStream);
        return oAIMetadataFormatList;
    }

    public OAISetList listSets() throws OAIException {
        OAISetList oAISetList = new OAISetList();
        this.priCheckBaseURL();
        OAIResumptionStream oAIResumptionStream = new OAIResumptionStream(this, this.strBaseURL, "ListSets");
        oAISetList.frndSetOAIResumptionStream(oAIResumptionStream);
        return oAISetList;
    }
}

