/*
 * Decompiled with CFR 0.152.
 */
package uiuc.oai;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uiuc.oai.OAIException;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRepository;
import uiuc.oai.OAIResumptionStream;

public class OAIRecordList {
    private OAIRecord recCurrent;
    private String strMetadataPrefix;
    private OAIResumptionStream oaiResume;

    public OAIRecord getCurrentItem() {
        return this.recCurrent;
    }

    public int getCurrentIndex() throws OAIException {
        return this.oaiResume.getIndex();
    }

    public int getCompleteSize() throws OAIException {
        return this.oaiResume.getCompleteSize();
    }

    private void priSetCurrentItem() throws OAIException {
        Node node = this.oaiResume.getItem();
        OAIRecord oAIRecord = new OAIRecord();
        if (node != null) {
            oAIRecord.frndSetRepository(this.getOAIRepository());
            oAIRecord.frndSetValid(this.isListValid());
            if (node.getNodeName().equals("identifier")) {
                oAIRecord.frndSetIdOnly(true);
                oAIRecord.frndSetIdentifier(node.getFirstChild().getNodeValue());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && namedNodeMap.getNamedItem("status") != null) {
                    oAIRecord.frndSetStatus(namedNodeMap.getNamedItem("status").getNodeValue());
                }
            } else if (node.getNodeName().equals("header")) {
                oAIRecord.frndSetIdOnly(true);
                oAIRecord.frndSetMetadataPrefix(this.strMetadataPrefix);
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    if (nodeList.item(n).getNodeName().equals("identifier")) {
                        oAIRecord.frndSetIdentifier(nodeList.item(n).getFirstChild().getNodeValue());
                    } else if (nodeList.item(n).getNodeName().equals("datestamp")) {
                        oAIRecord.frndSetDatestamp(nodeList.item(n).getFirstChild().getNodeValue());
                    }
                    ++n;
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && namedNodeMap.getNamedItem("status") != null) {
                    oAIRecord.frndSetStatus(namedNodeMap.getNamedItem("status").getNodeValue());
                }
                oAIRecord.frndSetRecord(node);
            } else if (node.getNodeName().equals("record")) {
                Node node2 = null;
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    if (nodeList.item(n).getNodeName().equals("header")) {
                        node2 = nodeList.item(n);
                        break;
                    }
                    ++n;
                }
                if (node2 != null) {
                    oAIRecord.frndSetIdOnly(false);
                    oAIRecord.frndSetMetadataPrefix(this.strMetadataPrefix);
                    nodeList = node2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        if (nodeList.item(n2).getNodeName().equals("identifier") && nodeList.item(n2).getChildNodes().getLength() > 0) {
                            oAIRecord.frndSetIdentifier(nodeList.item(n2).getFirstChild().getNodeValue());
                        } else if (nodeList.item(n2).getNodeName().equals("datestamp") && nodeList.item(n2).getChildNodes().getLength() > 0) {
                            oAIRecord.frndSetDatestamp(nodeList.item(n2).getFirstChild().getNodeValue());
                        }
                        ++n2;
                    }
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    if (namedNodeMap != null && namedNodeMap.getNamedItem("status") != null) {
                        oAIRecord.frndSetStatus(namedNodeMap.getNamedItem("status").getNodeValue());
                    }
                    oAIRecord.frndSetRecord(node);
                } else {
                    oAIRecord = null;
                }
            } else {
                throw new OAIException(12, "Element " + node.getNodeName() + " is unknown");
            }
            this.recCurrent = oAIRecord;
        } else {
            this.recCurrent = null;
        }
    }

    public boolean isListValid() {
        return this.oaiResume.isResponseValid();
    }

    public boolean moreItems() throws OAIException {
        return this.oaiResume.more();
    }

    public void moveNext() throws OAIException {
        this.oaiResume.moveNext();
        this.priSetCurrentItem();
    }

    public OAIRepository getOAIRepository() {
        return this.oaiResume.getRepository();
    }

    public void requery() throws OAIException {
        this.oaiResume.requery();
        this.priSetCurrentItem();
    }

    protected void frndSetOAIResumptionStream(OAIResumptionStream oAIResumptionStream) throws OAIException {
        this.oaiResume = oAIResumptionStream;
        this.priSetCurrentItem();
    }

    protected void frndSetMetadataPrefix(String string) {
        this.strMetadataPrefix = string;
    }
}

