/*
 * Decompiled with CFR 0.152.
 */
package uiuc.oai;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uiuc.oai.OAIException;
import uiuc.oai.OAIRepository;

public class OAIResumptionStream {
    private String strBaseURL;
    private String strVerb;
    private String strParams;
    private String strResumptionToken;
    private String strExpirationDate;
    private Document xml;
    private NodeList nodeList;
    private int iIndex;
    private int iCompleteListSize;
    private int iCursor;
    private int iCount;
    private int iRealCursor;
    private Element namespaceNode;
    private boolean boolInitialized;
    private boolean boolValidResponse;
    private int iResumptionCount;
    private OAIRepository oParent;

    public OAIResumptionStream(OAIRepository oAIRepository, String string, String string2) throws OAIException {
        this.initialize(oAIRepository, string, string2, "");
    }

    public OAIResumptionStream(OAIRepository oAIRepository, String string, String string2, String string3) throws OAIException {
        this.initialize(oAIRepository, string, string2, string3);
    }

    private void initialize(OAIRepository oAIRepository, String string, String string2, String string3) throws OAIException {
        this.oParent = oAIRepository;
        this.strVerb = string2;
        this.strBaseURL = string;
        this.strParams = string3;
        this.strResumptionToken = "";
        this.iResumptionCount = 0;
        this.boolInitialized = false;
        this.boolValidResponse = false;
        this.iIndex = 1;
        this.iCount = -1;
        this.iCursor = -1;
        this.iRealCursor = -1;
        this.iCompleteListSize = -1;
        if (!(this.strVerb.equals("ListIdentifiers") || this.strVerb.equals("ListMetadataFormats") || this.strVerb.equals("ListRecords") || this.strVerb.equals("ListSets"))) {
            throw new OAIException(5, "Invalid verb");
        }
        if (this.strBaseURL.length() == 0) {
            throw new OAIException(6, "No baseURL");
        }
        if (string3.length() > 0 && string3.charAt(0) != '&') {
            string3 = "&" + string3;
        }
        try {
            URL uRL = new URL(this.strBaseURL + "?verb=" + this.strVerb + string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection = this.oParent.frndTrySend(httpURLConnection);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (this.oParent.getValidation() == 1) {
                documentBuilderFactory.setValidating(true);
            } else {
                documentBuilderFactory.setValidating(false);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                this.xml = documentBuilder.parse(httpURLConnection.getInputStream());
                this.boolValidResponse = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OAIException(14, illegalArgumentException.getMessage());
            }
            catch (SAXException sAXException) {
                if (this.oParent.getValidation() != 2) {
                    throw new OAIException(13, sAXException.getMessage() + " Try loose validation.");
                }
                try {
                    httpURLConnection.disconnect();
                    uRL = new URL(this.strBaseURL + "?verb=" + this.strVerb + string3);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection = this.oParent.frndTrySend(httpURLConnection);
                    this.xml = documentBuilder.parse(this.priCreateDummyResponse(httpURLConnection.getInputStream()));
                }
                catch (SAXException sAXException2) {
                    throw new OAIException(13, sAXException2.getMessage());
                }
            }
            this.namespaceNode = this.xml.createElement(this.strVerb);
            this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI + this.strVerb);
            this.namespaceNode.setAttribute("xmlns:dc", OAIRepository.XMLNS_DC);
            PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
            XPath xPath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolverDefault, 0, null);
            XPathContext xPathContext = new XPathContext();
            int n = xPathContext.getDTMHandleFromNode((Node)this.xml);
            XObject xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
            Node node = xObject.nodeset().nextNode();
            if (node == null) {
                this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_2_0);
                prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                xPath = new XPath("/oai:OAI-PMH", null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                node = xObject.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_1_0 + this.strVerb);
                } else {
                    xPath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
                    NodeList nodeList = xObject.nodelist();
                    if (nodeList.getLength() > 0) {
                        this.oParent.frndSetErrors(nodeList);
                        throw new OAIException(15, this.oParent.getLastOAIError().getCode() + ": " + this.oParent.getLastOAIError().getReason());
                    }
                }
            }
            xPath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolverDefault, 0, null);
            xObject = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault);
            this.nodeList = xObject.nodelist();
            this.boolInitialized = true;
            this.oParent.frndSetNamespaceNode(this.namespaceNode);
            xPath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolverDefault, 0, null);
            node = xPath.execute(xPathContext, n, (PrefixResolver)prefixResolverDefault).nodeset().nextNode();
            if (node != null) {
                this.oParent.frndSetRequest(node);
            }
            this.oParent.frndSetResponseDate(this.getResponseDate());
            documentBuilderFactory = null;
            documentBuilder = null;
            uRL = null;
            prefixResolverDefault = null;
            xPathContext = null;
            xPath = null;
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAIException(14, malformedURLException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new OAIException(14, factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OAIException(14, parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
    }

    public int getCompleteSize() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        return this.iCompleteListSize;
    }

    public int getResumptionCursor() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        if (this.iCursor == -1) {
            return this.iRealCursor;
        }
        return this.iCursor;
    }

    public String getResumptionExpirationDate() throws OAIException {
        this.priCheckInitialized();
        this.priGetResumptionToken();
        return this.strExpirationDate;
    }

    public int getIndex() throws OAIException {
        return this.getResumptionCursor() + this.iIndex - 1;
    }

    public boolean isResponseValid() {
        return this.boolValidResponse;
    }

    public boolean more() throws OAIException {
        boolean bl = false;
        this.priCheckInitialized();
        if (this.strResumptionToken.length() > 0 || this.iIndex <= this.priGetSetCount()) {
            bl = true;
        }
        return bl;
    }

    public void moveNext() throws OAIException {
        this.priCheckInitialized();
        int n = this.priGetSetCount();
        if (this.more()) {
            if (this.iIndex <= n) {
                ++this.iIndex;
            }
            if (this.iIndex > n) {
                this.priResumption();
            }
        } else {
            throw new OAIException(7, "No more sets");
        }
    }

    public String getBaseURL() throws OAIException {
        this.priCheckInitialized();
        return this.strBaseURL;
    }

    public String getResponseDate() throws OAIException {
        String string = "";
        this.priCheckInitialized();
        NodeList nodeList = this.xml.getElementsByTagName("responseDate");
        if (nodeList.getLength() <= 0) {
            throw new OAIException(4, this.strVerb + " missing responseDate");
        }
        string = nodeList.item(0).getFirstChild().getNodeValue();
        return string;
    }

    public String getRequestURL() throws OAIException {
        String string;
        block12: {
            this.priCheckInitialized();
            string = "";
            try {
                Node node = XPathAPI.selectSingleNode((Node)this.xml, (String)"//oai:requestURL | //oai:request", (Node)this.namespaceNode);
                if (node != null) {
                    string = node.getFirstChild().getNodeValue();
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    Node node2 = namedNodeMap.getNamedItem("verb");
                    if (node2 != null) {
                        string = string + "?verb=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("identifier")) != null) {
                        string = string + "&identifier=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("metadataPrefix")) != null) {
                        string = string + "&metadataPrefix=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("from")) != null) {
                        string = string + "&from=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("until")) != null) {
                        string = string + "&until=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("set")) != null) {
                        string = string + "&set=" + node2.getNodeValue();
                    }
                    if ((node2 = namedNodeMap.getNamedItem("resumptionToken")) != null) {
                        try {
                            string = string + "&resumptionToken=" + URLEncoder.encode(node2.getNodeValue(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string = string + "&resumptionToken=" + node2.getNodeValue();
                        }
                    }
                    break block12;
                }
                throw new OAIException(4, this.strVerb + " missing requestURL/request");
            }
            catch (TransformerException transformerException) {
                throw new OAIException(14, transformerException.getMessage());
            }
        }
        return string;
    }

    public Node getItem() throws OAIException {
        this.priCheckInitialized();
        return this.priGetXMLItem(this.iIndex);
    }

    public String getParams() throws OAIException {
        this.priCheckInitialized();
        return this.strParams;
    }

    public OAIRepository getRepository() {
        return this.oParent;
    }

    public String getVerb() throws OAIException {
        this.priCheckInitialized();
        return this.strVerb;
    }

    public void requery() throws OAIException {
        this.priCheckInitialized();
        this.initialize(this.oParent, this.strBaseURL, this.strVerb, this.strParams);
    }

    private void priCheckInitialized() throws OAIException {
        if (!this.boolInitialized) {
            throw new OAIException(9, "Not initialized");
        }
    }

    private Node priGetXMLItem(int n) {
        if (this.nodeList != null && n <= this.nodeList.getLength()) {
            return this.nodeList.item(n - 1);
        }
        return null;
    }

    private int priGetSetCount() {
        if (this.iCount >= 0) {
            return this.iCount;
        }
        this.iCount = this.nodeList.getLength();
        return this.iCount;
    }

    public int getResponseSize() throws OAIException {
        this.priCheckInitialized();
        return this.priGetSetCount();
    }

    private String priGetResumptionToken() throws OAIException {
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xml, (String)("//oai:" + this.strVerb + "/oai:resumptionToken/text()"), (Node)this.namespaceNode);
            if (node != null) {
                this.strResumptionToken = node.getNodeValue().trim();
                NamedNodeMap namedNodeMap = node.getParentNode().getAttributes();
                Node node2 = namedNodeMap.getNamedItem("expirationDate");
                this.strExpirationDate = node2 != null ? node2.getNodeValue() : "";
                node2 = namedNodeMap.getNamedItem("completeListSize");
                if (node2 != null) {
                    try {
                        this.iCompleteListSize = Integer.parseInt(node2.getNodeValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.iCompleteListSize = -1;
                    }
                } else {
                    this.iCompleteListSize = -1;
                }
                if ((node2 = namedNodeMap.getNamedItem("cursor")) != null) {
                    try {
                        this.iCursor = Integer.parseInt(node2.getNodeValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.iCursor = -1;
                    }
                } else {
                    this.iCursor = -1;
                }
            } else {
                this.strResumptionToken = "";
                this.strExpirationDate = "";
                this.iCompleteListSize = -1;
                this.iCursor = -1;
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        if (this.strResumptionToken.length() == 0 && this.iCompleteListSize == -1) {
            this.iCompleteListSize = this.iCursor == -1 ? this.priGetSetCount() + this.iRealCursor : this.priGetSetCount() + this.iCursor;
        }
        return this.strResumptionToken;
    }

    private String priGetMainNodeName() throws OAIException {
        String string;
        if (this.strVerb.equals("ListSets")) {
            string = "set";
        } else if (this.strVerb.equals("ListIdentifiers")) {
            string = this.oParent.getProtocolMajorVersion() < 2 ? "identifier" : "header";
        } else if (this.strVerb.equals("ListMetadataFormats")) {
            string = "metadataFormat";
        } else if (this.strVerb.equals("ListRecords")) {
            string = "record";
        } else {
            throw new OAIException(5, "Invalid verb");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputSource priCreateDummyResponse(InputStream inputStream) throws OAIException {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.oParent.getProtocolMajorVersion() < 2) {
            if (this.strVerb.equals("ListSets")) {
                string = "<ListSets xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListSets' \n";
                string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListSets ";
                string = string + "http://www.openarchives.org/OAI/1.1/OAI_ListSets.xsd'> \n";
                string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
                string = string + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                string = string + "<set> \n";
                string = string + "<setSpec>junk:set" + this.iResumptionCount + "</setSpec> \n";
                string = string + "<setName><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></setName> \n";
                string = string + "</set> \n";
                string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
                string = string + "</ListSets>\n";
            } else if (this.strVerb.equals("ListIdentifiers")) {
                string = "<ListIdentifiers xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers' \n";
                string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers ";
                string = string + "http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers.xsd'> \n";
                string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
                string = string + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                string = string + "<identifier><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></identifier> \n";
                string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
                string = string + "</ListIdentifiers>\n";
            } else if (this.strVerb.equals("ListMetadataFormats")) {
                string = "<ListMetadataFormats xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats' \n";
                string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats ";
                string = string + "http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats.xsd'> \n";
                string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
                string = string + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL> \n";
                string = string + "<metadataFormat> \n";
                string = string + "<metadataPrefix>junk_metadataPrefix" + this.iResumptionCount + "</metadataPrefix> \n";
                string = string + "<schema><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></schema> \n";
                string = string + "</metadataFormat> \n";
                string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
                string = string + "</ListMetadataFormats>\n";
            } else {
                if (!this.strVerb.equals("ListRecords")) throw new OAIException(5, "Invalid verb");
                string = "<ListRecords \n";
                string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
                string = string + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_ListRecords' \n";
                string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_ListRecords ";
                string = string + "http://www.openarchives.org/OAI/1.1/OAI_ListRecords.xsd'>\n";
                string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate>\n";
                string = string + "<requestURL>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</requestURL>";
                string = string + "<record>\n";
                string = string + "<header>\n";
                string = this.oParent.usesOAIIdentifier() ? string + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : string + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
                string = string + "<datestamp>" + simpleDateFormat.format(new Date()) + "</datestamp>\n";
                string = string + "</header>\n";
                string = string + "<about>\n";
                string = string + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></junk:junk>\n";
                string = string + "</about>\n";
                string = string + "</record>\n";
                string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
                string = string + "</ListRecords>\n";
            }
        } else if (this.strVerb.equals("ListSets")) {
            string = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string = string + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
            string = string + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            string = string + "<ListSets> \n";
            string = string + "<set> \n";
            string = string + "<setSpec>junk:set" + this.iResumptionCount + "</setSpec> \n";
            string = string + "<setName>INVALID SET</setName> \n";
            string = string + "<setDescription><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></setDescription> \n";
            string = string + "</set> \n";
            string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
            string = string + "</ListSets>\n";
            string = string + "</OAI-PMH>\n";
        } else if (this.strVerb.equals("ListIdentifiers")) {
            string = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string = string + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
            string = string + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            string = string + "<ListIdentifiers>\n";
            string = string + "<header>\n";
            string = this.oParent.usesOAIIdentifier() ? string + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : string + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
            string = string + "<datestamp>" + simpleDateFormat.format(new Date()) + "</datestamp>\n";
            string = string + "<setSpec><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]>\n";
            string = string + "</header>\n";
            string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
            string = string + "</ListIdentifiers>\n";
            string = string + "</OAI-PMH>\n";
        } else if (this.strVerb.equals("ListMetadataFormats")) {
            string = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string = string + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
            string = string + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            string = string + "<metadataFormat> \n";
            string = string + "<metadataPrefix>junk_metadataPrefix" + this.iResumptionCount + "</metadataPrefix> \n";
            string = string + "<schema><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></schema> \n";
            string = string + "</metadataFormat> \n";
            string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
            string = string + "</ListMetadataFormats>\n";
            string = string + "</OAI-PMH>\n";
        } else {
            if (!this.strVerb.equals("ListRecords")) throw new OAIException(5, "Invalid verb");
            string = "<OAI-PMH xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            string = string + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            string = string + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            string = string + "http://www.openarchives.org/OAI/2.0/OAI_PMH.xsd'> \n";
            string = string + "<responseDate>" + simpleDateFormat.format(new Date()) + "</responseDate> \n";
            string = string + "<request>" + this.strBaseURL + "?verb=" + this.strVerb + this.priXMLEncode(this.strParams) + "</request> \n";
            string = string + "<record>\n";
            string = string + "<header>\n";
            string = this.oParent.usesOAIIdentifier() ? string + "<identifier>" + this.oParent.getRepositoryIdentifier() + "junk:identifier" + this.iResumptionCount + "</identifier>\n" : string + "<identifier>junk:identifier" + this.iResumptionCount + "</identifier>\n";
            string = string + "<datestamp>" + simpleDateFormat.format(new Date()) + "</datestamp>\n";
            string = string + "</header>\n";
            string = string + "<about>\n";
            string = string + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.oParent.frndMyEncode(inputStream) + "]]></junk:junk>\n";
            string = string + "</about>\n";
            string = string + "</record>\n";
            string = string + this.priTryToGetResumptionToken(inputStream) + "\n";
            string = string + "</ListRecords>\n";
            string = string + "</OAI-PMH>\n";
        }
        StringReader stringReader = new StringReader(string);
        return new InputSource(stringReader);
    }

    private String priTryToGetResumptionToken(InputStream inputStream) throws OAIException {
        String string = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = "";
            int n = -1;
            int n2 = -1;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n < 0 && (n2 = (string = string2.substring((n = string2.indexOf("<resumptionToken")) + 17)).indexOf("</resumptionToken")) > 0) {
                    string = string.substring(0, n2);
                } else {
                    if (n <= 0 || (n2 = (string = string + string2).indexOf("</resumptionToken")) <= 0) continue;
                    string = string.substring(0, n2);
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
        return string;
    }

    private String priXMLEncode(String string) {
        String string2 = string;
        int n = 0;
        while ((n = string2.indexOf(38, n)) >= 0) {
            string2 = string2.substring(0, n) + "&amp;" + string2.substring(n + 1);
            n += 4;
        }
        return string2;
    }

    private void priResumption() throws OAIException {
        String string = this.priGetResumptionToken();
        if (string.length() == 0) {
            return;
        }
        int n = this.priGetSetCount();
        this.iCount = -1;
        ++this.iResumptionCount;
        try {
            URL uRL = new URL(this.strBaseURL + "?verb=" + this.strVerb + "&resumptionToken=" + URLEncoder.encode(string, "UTF-8"));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection = this.oParent.frndTrySend(httpURLConnection);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (this.oParent.getValidation() == 1) {
                documentBuilderFactory.setValidating(true);
            } else {
                documentBuilderFactory.setValidating(false);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                this.xml = documentBuilder.parse(httpURLConnection.getInputStream());
                this.boolValidResponse = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OAIException(14, illegalArgumentException.getMessage());
            }
            catch (SAXException sAXException) {
                if (this.oParent.getValidation() != 2) {
                    throw new OAIException(13, sAXException.getMessage() + " Try loose validation.");
                }
                try {
                    httpURLConnection.disconnect();
                    uRL = new URL(this.strBaseURL + "?verb=" + this.strVerb + "&resumptionToken=" + URLEncoder.encode(string, "UTF-8"));
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection = this.oParent.frndTrySend(httpURLConnection);
                    this.xml = documentBuilder.parse(this.priCreateDummyResponse(httpURLConnection.getInputStream()));
                }
                catch (SAXException sAXException2) {
                    throw new OAIException(13, sAXException2.getMessage());
                }
            }
            try {
                this.namespaceNode = this.xml.createElement(this.strVerb);
                this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI + this.strVerb);
                this.namespaceNode.setAttribute("xmlns:dc", OAIRepository.XMLNS_DC);
                PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                XPath xPath = new XPath("/oai:" + this.strVerb, null, (PrefixResolver)prefixResolverDefault, 0, null);
                XPathContext xPathContext = new XPathContext();
                int n2 = xPathContext.getDTMHandleFromNode((Node)this.xml);
                XObject xObject = xPath.execute(xPathContext, n2, (PrefixResolver)prefixResolverDefault);
                Node node = xObject.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_2_0);
                    prefixResolverDefault = new PrefixResolverDefault((Node)this.namespaceNode);
                    xPath = new XPath("/oai:OAI-PMH", null, (PrefixResolver)prefixResolverDefault, 0, null);
                    xObject = xPath.execute(xPathContext, n2, (PrefixResolver)prefixResolverDefault);
                    node = xObject.nodeset().nextNode();
                    if (node == null) {
                        this.namespaceNode.setAttribute("xmlns:oai", OAIRepository.XMLNS_OAI_1_0 + this.strVerb);
                    } else {
                        xPath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolverDefault, 0, null);
                        xObject = xPath.execute(xPathContext, n2, (PrefixResolver)prefixResolverDefault);
                        NodeList nodeList = xObject.nodelist();
                        if (nodeList.getLength() > 0) {
                            this.oParent.frndSetErrors(nodeList);
                            throw new OAIException(15, this.oParent.getLastOAIError().getCode() + ": " + this.oParent.getLastOAIError().getReason());
                        }
                    }
                }
                xPath = new XPath("//oai:" + this.strVerb + "/oai:" + this.priGetMainNodeName(), null, (PrefixResolver)prefixResolverDefault, 0, null);
                xObject = xPath.execute(xPathContext, n2, (PrefixResolver)prefixResolverDefault);
                this.nodeList = xObject.nodelist();
                this.oParent.frndSetNamespaceNode(this.namespaceNode);
                xPath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolverDefault, 0, null);
                node = xPath.execute(xPathContext, n2, (PrefixResolver)prefixResolverDefault).nodeset().nextNode();
                if (node != null) {
                    this.oParent.frndSetRequest(node);
                }
                this.oParent.frndSetResponseDate(this.getResponseDate());
                this.iRealCursor += n;
                prefixResolverDefault = null;
                xPathContext = null;
                xPath = null;
            }
            catch (TransformerException transformerException) {
                throw new OAIException(14, transformerException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OAIException(14, illegalArgumentException.getMessage());
            }
            documentBuilderFactory = null;
            documentBuilder = null;
            uRL = null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAIException(14, malformedURLException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAIException(14, unsupportedEncodingException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new OAIException(14, factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OAIException(14, parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new OAIException(14, iOException.getMessage());
        }
        this.iIndex = 1;
    }
}

