/*
 * Decompiled with CFR 0.152.
 */
package uiuc.oai;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uiuc.oai.OAIException;
import uiuc.oai.OAIRepository;

public class OAIRecord {
    private String strStatus = "";
    private String strIdentifier = "";
    private String strDatestamp = "";
    private String strMetadataPrefix = "";
    private boolean boolIdOnly = true;
    private boolean boolValid = true;
    private Node xmlRecord = null;
    private OAIRepository repo;

    public String getMetadataNamespaceURI() throws OAIException {
        String string = "";
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)"oai:metadata/*", (Node)this.repo.getNamespaceNode());
            if (node != null) {
                string = node.getNamespaceURI();
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return string;
    }

    public String getAboutNamespaceURI() throws OAIException {
        return this.getAboutNamespaceURI(0);
    }

    public String getAboutNamespaceURI(int n) throws OAIException {
        String string = "";
        this.priCheckIdOnly();
        try {
            Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("oai:about[" + (n + 1) + "]/*"), (Node)this.repo.getNamespaceNode());
            if (node != null) {
                string = node.getNamespaceURI();
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return string;
    }

    private void priCheckIdOnly() throws OAIException {
        if (this.boolIdOnly) {
            this.refreshRecord();
        }
    }

    public String getDatestamp() throws OAIException {
        if (this.repo.getProtocolMajorVersion() < 2) {
            this.priCheckIdOnly();
        }
        return this.strDatestamp;
    }

    public boolean deleted() {
        return this.strStatus.equals("deleted");
    }

    public boolean isRecordValid() {
        return this.boolValid;
    }

    public String getIdentifier() {
        return this.strIdentifier;
    }

    public String getStatus() {
        return this.strStatus;
    }

    public Node getMetadata() throws OAIException {
        Node node = null;
        this.priCheckIdOnly();
        try {
            Node node2 = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)"oai:metadata/*", (Node)this.repo.getNamespaceNode());
            if (node2 != null) {
                node = node2.cloneNode(true);
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return node;
    }

    public int getAboutCount() throws OAIException {
        int n = 0;
        this.priCheckIdOnly();
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)this.xmlRecord, (String)"oai:about/*", (Node)this.repo.getNamespaceNode());
            n = nodeList.getLength();
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return n;
    }

    public Node getAbout() throws OAIException {
        return this.getAbout(0);
    }

    public Node getAbout(int n) throws OAIException {
        Node node = null;
        this.priCheckIdOnly();
        try {
            Node node2 = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("oai:about[" + (n + 1) + "]/*"), (Node)this.repo.getNamespaceNode());
            if (node2 != null) {
                node = node2.cloneNode(true);
            }
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return node;
    }

    public boolean isIdentifierOnly() {
        return this.boolIdOnly;
    }

    public String getMetadataPrefix() throws OAIException {
        if (this.repo.getProtocolMajorVersion() < 2) {
            this.priCheckIdOnly();
        }
        return this.strMetadataPrefix;
    }

    public Node getRecord() throws OAIException {
        this.priCheckIdOnly();
        return this.xmlRecord.cloneNode(true);
    }

    public void refreshRecord() throws OAIException {
        if (this.strMetadataPrefix.length() == 0) {
            this.strMetadataPrefix = "oai_dc";
        }
        this.refreshRecord(this.strMetadataPrefix);
    }

    public void refreshRecord(String string) throws OAIException {
        OAIRecord oAIRecord = this.repo.getRecord(this.strIdentifier, string);
        if (oAIRecord == null) {
            throw new OAIException(1, "Record failed to refresh, illegal or nonexisting identifier?");
        }
        this.frndSetDatestamp(oAIRecord.getDatestamp());
        this.frndSetIdentifier(oAIRecord.getIdentifier());
        this.frndSetIdOnly(oAIRecord.isIdentifierOnly());
        this.frndSetMetadataPrefix(string);
        this.frndSetStatus(oAIRecord.deleted() ? "deleted" : "");
        this.frndSetRecord(oAIRecord.getRecord());
        this.frndSetValid(oAIRecord.isRecordValid());
        this.boolIdOnly = false;
    }

    public int getSetSpecCount() throws OAIException {
        int n = 0;
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)this.xmlRecord, (String)"//oai:setSpec", (Node)this.repo.getNamespaceNode());
            n = nodeList.getLength();
        }
        catch (TransformerException transformerException) {
            throw new OAIException(14, transformerException.getMessage());
        }
        return n;
    }

    public String getSetSpec() throws OAIException {
        return this.getSetSpec(0);
    }

    public String getSetSpec(int n) throws OAIException {
        String string = "";
        if (this.repo.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'setSpec' of header is not supported.");
        }
        if (this.getSetSpecCount() > 0 && n < this.getSetSpecCount()) {
            try {
                Node node = XPathAPI.selectSingleNode((Node)this.xmlRecord, (String)("//oai:setSpec[" + (n + 1) + "]/text()"), (Node)this.repo.getNamespaceNode());
                if (node != null) {
                    string = node.getNodeValue();
                }
            }
            catch (TransformerException transformerException) {
                throw new OAIException(14, transformerException.getMessage());
            }
        }
        return string;
    }

    protected void frndSetIdentifier(String string) {
        this.strIdentifier = string;
    }

    protected void frndSetDatestamp(String string) {
        this.strDatestamp = string;
    }

    protected void frndSetRepository(OAIRepository oAIRepository) {
        this.repo = oAIRepository;
    }

    protected void frndSetMetadataPrefix(String string) {
        this.strMetadataPrefix = string;
    }

    protected void frndSetValid(boolean bl) {
        this.boolValid = bl;
    }

    protected void frndSetIdOnly(boolean bl) {
        this.boolIdOnly = bl;
    }

    protected void frndSetRecord(Node node) {
        this.xmlRecord = node;
    }

    protected void frndSetStatus(String string) {
        this.strStatus = string;
    }
}

