/**
 * University of Illinois/NCSA Open Source License
 *
 * Copyright (c) 2001,2002 The Board of Trustees of the University of Illinois
 * All rights reserved.
 *
 * Developed by:  Open Archives Initiative Metadata Harvesting Project
 *                University of Illinois at Urbana-Champaign
 *                http://oai.grainger.uiuc.edu/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 *  . Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimers.
 *  . Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimers in the
 *    documentation and/or other materials provided with the distribution.
 *  . Neither the names of Open Archives Initiative Metadata Harvesting
 *    Project, University of Illinois at Urbana-Champaign, nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this Software without specific prior written permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS WITH THE SOFTWARE.
 *
 * DC.Title:          OAISet
 * 
 * DC.Description:    Class representing an OAI Set
 * 
 * DC.Contributor:    Yuping Tseng, ytseng1@uiuc.edu, University og Illinois at Urbana-Champaign
 * DC.Contributor:    Tom Habing, thabing@uiuc.edu, University of Illinois at Urbana-Champaign
 * 
 * DC.Date.Modified:  Modtime: 4/01/02 11:58a 
 * 
 * DC:Rights:         University of Illinois/NCSA Open Source License
 * 
 * DC.Relation:       For more information see http://oai.grainger.uiuc.edu/
 * DC.Relation:       See http://www.openarchives.org/OAI/openarchivesprotocol.html
 * 
 */
package org.gcube.common;

import org.w3c.dom.*;

/**
 * This class represents an OAI Set.
 * 
 * This object is returned by the OAISetList.getCurrentItem() method.
 */
public class OAISet {

  /**
   * Construct a empty set.
   */
  public OAISet() {
    boolValid = true;
  }

  /**
   * Return the first description of this repository
   */
  public Node getSetDescription() throws OAIException {
    return getSetDescription(0);  
  }

  /**
   * Return one of the descriptions of this repository
   */
  public Node getSetDescription(int i) throws OAIException {
    if (ixmlDescriptions.getLength() > 0 && i < ixmlDescriptions.getLength()) {
      return ixmlDescriptions.item(i);
    } else {
     return null;
    }
  }

  /**
   * Return how many descriptions there are for the repository
   */
  public int getSetDescriptionCount() {
    if (ixmlDescriptions == null) {
      return 0;
    } else {
      return ixmlDescriptions.getLength();
    }
  }
 
  /**
   * Return true if the set appears to be valid (well-formed, and if the Validation if Very Strict also valid according to the 
   *  XML Schemas); if the Validation is Loose and the record is not well-formed, false is returned. 
   */
  public boolean isSetValid() {
    return boolValid;
  }

  protected void frndSetValid(boolean b) {
    boolValid = b;
  }

  protected void frndSetSetSpec(String ss) {
    strSetSpec = ss;
  }

  protected void frndSetSetName(String sn) {
    strSetName = sn;
  }

  protected void frndSetSetDescription(NodeList nl) {
    ixmlDescriptions = nl;
  }

  /**
   * Returns the identifier for the set. 
   */
  public String getSetSpec() {
    return strSetSpec;
  }

  /**
   * Returns the human-readable name of the set. 
   */
  public String getSetName() {
    return strSetName;
  }

  private boolean boolValid;
  private String strSetSpec;
  private String strSetName;
  private NodeList ixmlDescriptions;
}
