/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.gcube.common.OAIError;
import org.gcube.common.OAIException;
import org.gcube.common.OAIMetadataFormatList;
import org.gcube.common.OAIRecord;
import org.gcube.common.OAIRecordList;
import org.gcube.common.OAIResumptionStream;
import org.gcube.common.OAISetList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

public class OAIRepository {
    private String strRepositoryId;
    private String strRepositoryName;
    private String strBaseURL = "";
    private String[] strAdminEmail;
    private String[] strCompression;
    private String strEarliestDatestamp;
    private String strDeletedRecord;
    private String strGranularity;
    private String strProtocolVersion;
    private String strUserAgent = "OAIHarvester University of Illinois Library";
    private String strFrom = "someone@somewhere.edu";
    private String strUser = "";
    private String strPassword = "";
    private String strResponseDate;
    private String sRawResponse;
    private NodeList ixmlDescriptions;
    private NodeList ixmlErrors;
    private Node ixmlRequest;
    private Element descrNamespaceNode;
    private Element namespaceNode;
    private int validation = 0;
    private int state = 0;
    private int iRetryLimit = 5;
    private int iMaxRetryMinutes = 60;
    public final int STATE_UNIDENTIFIED = 0;
    public final int STATE_IDENTIFIED = 1;
    public static final int VALIDATION_STRICT = 0;
    public static final int VALIDATION_VERY_STRICT = 1;
    public static final int VALIDATION_LOOSE = 2;
    public static String XMLNS_DC = "http://purl.org/dc/elements/1.1/";
    public static String XMLNS_RFC1807 = "http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt";
    public static String XMLNS_OAI_MARC = "http://www.openarchives.org/OAI/1.1/oai_marc";
    public static String XMLNS_OAI = "http://www.openarchives.org/OAI/1.1/OAI_";
    public static String XMLNS_ID = "http://www.openarchives.org/OAI/1.1/oai-identifier";
    public static String XMLNS_EPR = "http://www.openarchives.org/OAI/1.1/eprints";
    public static String XMLNS_OAI_2_0 = "http://www.openarchives.org/OAI/2.0/";
    public static String XMLNS_OAI_DC_2_0 = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    public static String XMLNS_ID_2_0 = "http://www.openarchives.org/OAI/2.0/oai-identifier/";
    public static String XMLNS_OAI_1_0 = "http://www.openarchives.org/OAI/1.0/OAI_";
    public static String XMLNS_ID_1_0 = "http://www.openarchives.org/OAI/oai-identifier";
    public static String XMLNS_EPR_1_0 = "http://www.openarchives.org/OAI/eprints";
    public static String XMLNS_OAI_MARC_1_0 = "http://www.openarchives.org/OAI/oai_marc";
    public static String XMLNS_ID_1_0_aps = "http://www.openarchives.org/OAI/oai-identifier.xsd";

    public void setBaseURL(String url) throws OAIException {
        this.strBaseURL = url;
        this.identify();
    }

    public String getBaseURL() throws OAIException {
        this.priCheckBaseURL();
        return this.strBaseURL;
    }

    private InputSource priCreateDummyGetRecord(String id, InputStream xml) throws OAIException {
        String rec;
        SimpleDateFormat formatter = new SimpleDateFormat("yyy-MM-dd");
        if (this.getProtocolMajorVersion() < 2) {
            rec = "<GetRecord \n";
            rec = rec + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            rec = rec + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_GetRecord' \n";
            rec = rec + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_GetRecord ";
            rec = rec + "http://www.openarchives.org/OAI/1.1/OAI_GetRecord.xsd'>\n";
            rec = rec + "<responseDate>" + formatter.format(new Date()) + "</responseDate>\n";
            rec = rec + "<requestURL>junk:GetRecord</requestURL>\n";
            rec = rec + "<record>\n";
            rec = rec + "<header>\n";
            rec = rec + "<identifier>" + id + "</identifier>\n";
            rec = rec + "<datestamp>" + formatter.format(new Date()) + "</datestamp>\n";
            rec = rec + "</header>\n";
            rec = rec + "<about>\n";
            rec = rec + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(xml) + "]]></junk:junk>\n";
            rec = rec + "</about>\n";
            rec = rec + "</record>\n";
            rec = rec + "</GetRecord>";
        } else {
            rec = "<OAI-PMH \n";
            rec = rec + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            rec = rec + "xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            rec = rec + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            rec = rec + "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd'>\n";
            rec = rec + "<responseDate>" + formatter.format(new Date()) + "</responseDate>\n";
            rec = rec + "<request>junk:GetRecord</request>\n";
            rec = rec + "<GetRecord>\n";
            rec = rec + "<record>\n";
            rec = rec + "<header>\n";
            rec = rec + "<identifier>" + id + "</identifier>\n";
            rec = rec + "<datestamp>" + formatter.format(new Date()) + "</datestamp>\n";
            rec = rec + "</header>\n";
            rec = rec + "<about>\n";
            rec = rec + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(xml) + "]]></junk:junk>\n";
            rec = rec + "</about>\n";
            rec = rec + "</record>\n";
            rec = rec + "</GetRecord>\n";
            rec = rec + "</OAI-PMH>";
        }
        StringReader sr = new StringReader(rec);
        return new InputSource(sr);
    }

    private InputSource priCreateDummyIdentify(InputStream xml) throws OAIException {
        String ret;
        SimpleDateFormat formatter = new SimpleDateFormat("yyy-MM-dd");
        if (this.getProtocolMajorVersion() < 2) {
            ret = "<Identify \n";
            ret = ret + "xmlns='http://www.openarchives.org/OAI/1.1/OAI_Identify' \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/1.1/OAI_Identify ";
            ret = ret + "http://www.openarchives.org/OAI/1.1/OAI_Identify.xsd'> \n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate> \n";
            ret = ret + "<requestURL>junk:Identify</requestURL> \n";
            ret = ret + "<repositoryName>UNKNOWN</repositoryName> \n";
            ret = ret + "<baseURL>" + this.strBaseURL + "</baseURL> \n";
            ret = ret + "<protocolVersion>UNKNOWN</protocolVersion> \n";
            ret = ret + "<adminEmail>mailto:UNKNOWN</adminEmail> \n";
            ret = ret + "<description>\n";
            ret = ret + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(xml) + "]]></junk:junk>\n";
            ret = ret + "</description>\n";
            ret = ret + "</Identify>";
        } else {
            ret = "<OAI-PMH \n";
            ret = ret + "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' \n";
            ret = ret + "xmlns='http://www.openarchives.org/OAI/2.0/' \n";
            ret = ret + "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/ ";
            ret = ret + "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd'>\n";
            ret = ret + "<responseDate>" + formatter.format(new Date()) + "</responseDate>\n";
            ret = ret + "<request>junk:Identify</request>\n";
            ret = ret + "<Identify>\n";
            ret = ret + "<repositoryName>UNKNOWN</repositoryName> \n";
            ret = ret + "<baseURL>" + this.strBaseURL + "</baseURL> \n";
            ret = ret + "<protocolVersion>UNKNOWN</protocolVersion> \n";
            ret = ret + "<adminEmail>mailto:UNKNOWN</adminEmail> \n";
            ret = ret + "<description>\n";
            ret = ret + "<junk:junk xmlns:junk='junk:junk'><![CDATA[" + this.frndMyEncode(xml) + "]]></junk:junk>\n";
            ret = ret + "</description>\n";
            ret = ret + "</Identify>\n";
            ret = ret + "</OAI-PMH>";
        }
        StringReader sr = new StringReader(ret);
        return new InputSource(sr);
    }

    protected void frndSetErrors(NodeList e) {
        this.ixmlErrors = e;
    }

    protected void frndSetRepositoryID(String id) {
        this.strRepositoryId = id;
    }

    protected void frndSetRequest(Node u) {
        this.ixmlRequest = u;
    }

    protected void frndSetResponseDate(String d) {
        this.strResponseDate = d;
    }

    protected String frndGetRawResponse() {
        return this.sRawResponse;
    }

    protected String frndGetUser() {
        return this.strUser;
    }

    protected String frndGetPassword() {
        return this.strPassword;
    }

    public void setBasicAuthorization(String usr, String pwd) {
        this.strUser = usr;
        this.strPassword = pwd;
    }

    public OAIError getLastOAIError() throws OAIException {
        return this.getLastOAIError(0);
    }

    public OAIError getLastOAIError(int i) throws OAIException {
        OAIError err = null;
        if (this.getLastOAIErrorCount() > 0 && i < this.getLastOAIErrorCount()) {
            err = new OAIError();
            Node n = this.ixmlErrors.item(i);
            err.frndSetCode(n.getAttributes().getNamedItem("code").getNodeValue());
            err.frndSetReason(n.getFirstChild().getNodeValue());
        }
        return err;
    }

    public int getLastOAIErrorCount() {
        if (this.ixmlErrors != null) {
            return this.ixmlErrors.getLength();
        }
        return 0;
    }

    public String getRequestVerb() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("verb=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 5, idx2);
        }
        return ret;
    }

    public String getRequestIdentifier() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("identifier=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 11, idx2);
        }
        return ret;
    }

    public String getRequestMetadataPrefix() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("metadataPrefix=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 15, idx2);
        }
        return ret;
    }

    public String getRequestFrom() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("from=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 5, idx2);
        }
        return ret;
    }

    public String getRequestUntil() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("until=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 6, idx2);
        }
        return ret;
    }

    public String getRequestSet() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("set=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 4, idx2);
        }
        return ret;
    }

    public String getRequestResumptionToken() {
        String ret = "";
        int idx1 = this.getRequestURL().indexOf("resumptionToken=");
        if (idx1 >= 0) {
            int idx2 = this.getRequestURL().indexOf("&", idx1);
            if (idx2 <= 0) {
                idx2 = this.getRequestURL().length();
            }
            ret = this.getRequestURL().substring(idx1 + 16, idx2);
        }
        return ret;
    }

    public int getAdminEmailCount() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.strAdminEmail == null) {
            return 0;
        }
        return this.strAdminEmail.length;
    }

    public int getCompressionCount() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.strCompression == null) {
            return 0;
        }
        return this.strCompression.length;
    }

    public String getEarliestDatestamp() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'EarliestDateStamp' is not supporeted.");
        }
        return this.strEarliestDatestamp;
    }

    public String getDeletedRecord() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getProtocolMajorVersion() < 2) {
            throw new OAIException(15, "'DeletedRecord' is not supported.");
        }
        return this.strDeletedRecord;
    }

    public String getGranularity() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        String ret = this.getProtocolMajorVersion() < 2 ? "YYYY-MM-DD" : (this.strGranularity != null ? this.strGranularity : "YYYY-MM-DD");
        return ret;
    }

    public String getResponseDate() {
        return this.strResponseDate;
    }

    public String getRequestBaseURL() {
        String ret = this.ixmlRequest.getFirstChild().getNodeValue();
        if (ret.endsWith("?")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public int getMaxRetryMinutes() {
        return this.iMaxRetryMinutes;
    }

    public void setMaxRetryMinutes(int m) {
        this.iMaxRetryMinutes = m;
    }

    protected String frndMyEncode(InputStream s) throws OAIException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(s, "UTF-8"));
            String tmp = "";
            String ret = "";
            int idx = 0;
            while ((tmp = br.readLine()) != null) {
                while ((idx = tmp.indexOf("]]>", idx)) >= 0) {
                    tmp = tmp.substring(0, idx + 2) + "&gt;" + tmp.substring(idx + 2);
                }
                ret = ret + tmp + "\n";
            }
            return ret;
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
    }

    protected void frndSetNamespaceNode(Element ns) {
        this.namespaceNode = ns;
    }

    protected Element getNamespaceNode() {
        return this.namespaceNode;
    }

    private String priBuildParamString(String u, String f, String s, String i, String m) {
        String param = "";
        if (u != null && u.length() > 0) {
            param = param + "&until=" + u;
        }
        if (f != null && f.length() > 0) {
            param = param + "&from=" + f;
        }
        if (s != null && s.length() > 0) {
            param = param + "&set=" + s;
        }
        if (i != null && i.length() > 0) {
            param = param + "&identifier=" + i;
        }
        if (m != null && m.length() > 0) {
            param = param + "&metadataPrefix=" + m;
        }
        return param;
    }

    private void priCheckBaseURL() throws OAIException {
        if (this.strBaseURL == null || this.strBaseURL.length() == 0) {
            throw new OAIException(6, "No BaseURL");
        }
    }

    public Node getDescription() throws OAIException {
        return this.getDescription(0);
    }

    public Node getDescription(int i) throws OAIException {
        Node ret = null;
        if (this.state == 0) {
            this.identify();
        }
        if (this.ixmlDescriptions.getLength() > 0 && i < this.ixmlDescriptions.getLength()) {
            ret = this.ixmlDescriptions.item(i);
        }
        return ret;
    }

    public int getDescriptionCount() {
        return this.ixmlDescriptions.getLength();
    }

    public OAIRecord getRecord(String identifier) throws OAIException {
        return this.getRecord(identifier, "oai_dc");
    }

    public OAIRecord getRecord(String identifier, String metadataPrefix) throws OAIException {
        OAIRecord rec = new OAIRecord();
        this.priCheckBaseURL();
        String params = this.priBuildParamString("", "", "", identifier, metadataPrefix);
        try {
            URL url = new URL(this.strBaseURL + "?verb=GetRecord" + params);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http = this.frndTrySend(http);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            if (this.validation == 1) {
                docFactory.setValidating(true);
            } else {
                docFactory.setValidating(false);
            }
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document xml = null;
            try {
                xml = docBuilder.parse(http.getInputStream());
                rec.frndSetValid(true);
            }
            catch (IllegalArgumentException iae) {
                throw new OAIException(14, iae.getMessage());
            }
            catch (SAXException se) {
                if (this.validation != 2) {
                    throw new OAIException(13, se.getMessage());
                }
                try {
                    url = new URL(this.strBaseURL + "?verb=GetRecord" + params);
                    http.disconnect();
                    http = (HttpURLConnection)url.openConnection();
                    http = this.frndTrySend(http);
                    xml = docBuilder.parse(this.priCreateDummyGetRecord(identifier, http.getInputStream()));
                    rec.frndSetValid(false);
                }
                catch (SAXException se2) {
                    throw new OAIException(13, se2.getMessage());
                }
            }
            try {
                this.namespaceNode = xml.createElement("GetRecord");
                this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI + "GetRecord");
                this.namespaceNode.setAttribute("xmlns:dc", XMLNS_DC);
                PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                XPath xpath = new XPath("/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolver, 0, null);
                XPathContext xpathSupport = new XPathContext();
                int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)xml);
                XObject list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                Node node = list.nodeset().nextNode();
                if (node == null) {
                    this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI_2_0);
                    prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                    xpath = new XPath("/oai:OAI-PMH/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node == null) {
                        this.namespaceNode.setAttribute("xmlns:oai", XMLNS_OAI_1_0 + "GetRecord");
                        prefixResolver = new PrefixResolverDefault((Node)this.namespaceNode);
                        xpath = new XPath("/oai:GetRecord/oai:record", null, (PrefixResolver)prefixResolver, 0, null);
                        list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                        node = list.nodeset().nextNode();
                    } else {
                        xpath = new XPath("oai:OAI-PMH/oai:error", null, (PrefixResolver)prefixResolver, 0, null);
                        list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                        this.ixmlErrors = list.nodelist();
                        if (this.ixmlErrors.getLength() > 0) {
                            this.strProtocolVersion = "2";
                            throw new OAIException(15, this.getLastOAIError().getCode() + ": " + this.getLastOAIError().getReason());
                        }
                    }
                }
                if (node != null) {
                    rec.frndSetRepository(this);
                    rec.frndSetMetadataPrefix(metadataPrefix);
                    rec.frndSetIdOnly(false);
                    ctxtNode = xpathSupport.getDTMHandleFromNode(node);
                    xpath = new XPath("//oai:header/oai:identifier", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    rec.frndSetIdentifier(list.nodeset().nextNode().getFirstChild().getNodeValue());
                    xpath = new XPath("//oai:header/oai:datestamp", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    rec.frndSetDatestamp(list.nodeset().nextNode().getFirstChild().getNodeValue());
                    rec.frndSetRecord(node);
                    NamedNodeMap nmap = node.getAttributes();
                    if (nmap != null && nmap.getNamedItem("status") != null) {
                        rec.frndSetStatus(nmap.getNamedItem("status").getFirstChild().getNodeValue());
                    }
                } else {
                    rec = null;
                }
                xpath = new XPath("//oai:responseDate", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.strResponseDate = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strResponseDate = "";
                } else {
                    throw new OAIException(4, "GetRecord missing responseDate");
                }
                xpath = new XPath("//oai:requestURL | //oai:request", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.ixmlRequest = node;
                } else if (this.validation == 2) {
                    this.ixmlRequest = null;
                } else {
                    throw new OAIException(4, "GetRecord missing requestURL");
                }
                xpath = null;
                prefixResolver = null;
                xpathSupport = null;
                list = null;
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
            url = null;
            docFactory = null;
            docBuilder = null;
        }
        catch (MalformedURLException mue) {
            throw new OAIException(14, mue.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            throw new OAIException(14, fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new OAIException(14, pce.getMessage());
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
        return rec;
    }

    public String identify() throws OAIException {
        return this.identify(this.strBaseURL);
    }

    public String identify(String baseURL) throws OAIException {
        boolean v2 = false;
        this.priCheckBaseURL();
        try {
            URL url = new URL(baseURL + "?verb=Identify");
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http = this.frndTrySend(http);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            if (this.validation == 1) {
                docFactory.setValidating(true);
            } else {
                docFactory.setValidating(false);
            }
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document xml = null;
            try {
                xml = docBuilder.parse(http.getInputStream());
            }
            catch (IllegalArgumentException iae) {
                throw new OAIException(14, iae.getMessage());
            }
            catch (SAXException se) {
                if (this.validation != 2) {
                    throw new OAIException(13, se.getMessage());
                }
                try {
                    url = new URL(baseURL + "?verb=Identify");
                    http.disconnect();
                    http = (HttpURLConnection)url.openConnection();
                    http = this.frndTrySend(http);
                    xml = docBuilder.parse(this.priCreateDummyIdentify(http.getInputStream()));
                }
                catch (SAXException se2) {
                    throw new OAIException(13, se2.getMessage());
                }
            }
            try {
                int i;
                this.descrNamespaceNode = xml.createElement("Identify");
                this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI + "Identify");
                this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID);
                this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR);
                PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                XPathContext xpathSupport = new XPathContext();
                int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)xml);
                XPath xpath = new XPath("/oai_id:Identify", null, (PrefixResolver)prefixResolver, 0, null);
                XObject list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                Node node = list.nodeset().nextNode();
                if (node == null) {
                    this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI_2_0);
                    this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID_2_0);
                    this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR);
                    prefixResolver = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                    xpath = new XPath("/oai_id:OAI-PMH", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node == null) {
                        this.descrNamespaceNode.setAttribute("xmlns:oai_id", XMLNS_OAI_1_0 + "Identify");
                        this.descrNamespaceNode.setAttribute("xmlns:id", XMLNS_ID_1_0);
                        this.descrNamespaceNode.setAttribute("xmlns:epr", XMLNS_EPR_1_0);
                        prefixResolver = new PrefixResolverDefault((Node)this.descrNamespaceNode);
                    } else {
                        xpath = new XPath("oai_id:OAI-PMH/oai_id:error", null, (PrefixResolver)prefixResolver, 0, null);
                        list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                        this.ixmlErrors = list.nodelist();
                        if (this.getLastOAIErrorCount() > 0) {
                            this.strProtocolVersion = "2";
                            throw new OAIException(15, this.getLastOAIError().getCode() + ": " + this.getLastOAIError().getReason());
                        }
                        v2 = true;
                    }
                }
                if ((node = (list = (xpath = new XPath("//oai_id:repositoryName", null, (PrefixResolver)prefixResolver, 0, null)).execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver)).nodeset().nextNode()) != null) {
                    this.strRepositoryName = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strRepositoryName = "UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing repositoryName");
                }
                xpath = new XPath("//oai_id:baseURL", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.strBaseURL = node.getFirstChild().getNodeValue();
                } else if (this.validation != 2) {
                    throw new OAIException(4, "Identify missing baseURL");
                }
                xpath = new XPath("//oai_id:protocolVersion", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.strProtocolVersion = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strProtocolVersion = "UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing protocolVersion");
                }
                xpath = new XPath("//oai_id:adminEmail", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                NodeList nl = list.nodelist();
                if (nl.getLength() > 0) {
                    this.strAdminEmail = new String[nl.getLength()];
                    for (i = 0; i < nl.getLength(); ++i) {
                        this.strAdminEmail[i] = nl.item(i).getFirstChild().getNodeValue();
                    }
                } else if (this.validation == 2) {
                    this.strAdminEmail = new String[1];
                    this.strAdminEmail[0] = "mailto:UNKNOWN";
                } else {
                    throw new OAIException(4, "Identify missing adminEmail");
                }
                if (v2) {
                    xpath = new XPath("//oai_id:earliestDatestamp", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node != null) {
                        this.strEarliestDatestamp = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strEarliestDatestamp = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing earliestDatestamp");
                    }
                    xpath = new XPath("//oai_id:deletedRecord", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node != null) {
                        this.strDeletedRecord = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strDeletedRecord = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing deletedRecordp");
                    }
                    xpath = new XPath("//oai_id:granularity", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    node = list.nodeset().nextNode();
                    if (node != null) {
                        this.strGranularity = node.getFirstChild().getNodeValue();
                    } else if (this.validation == 2) {
                        this.strGranularity = "UNKNOWN";
                    } else {
                        throw new OAIException(4, "Identify missing granularity");
                    }
                    xpath = new XPath("//oai_id:compression", null, (PrefixResolver)prefixResolver, 0, null);
                    list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    nl = list.nodelist();
                    if (nl.getLength() > 0) {
                        this.strCompression = new String[nl.getLength()];
                        for (i = 0; i < nl.getLength(); ++i) {
                            this.strCompression[i] = nl.item(i).getFirstChild().getNodeValue();
                        }
                    }
                }
                xpath = new XPath("//oai_id:description", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                this.ixmlDescriptions = list.nodelist();
                xpath = new XPath("//oai_id:responseDate", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.strResponseDate = node.getFirstChild().getNodeValue();
                } else if (this.validation == 2) {
                    this.strResponseDate = "";
                } else {
                    throw new OAIException(4, "GetRecord missing responseDate");
                }
                xpath = new XPath("//oai_id:requestURL | //oai_id:request", null, (PrefixResolver)prefixResolver, 0, null);
                list = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                node = list.nodeset().nextNode();
                if (node != null) {
                    this.ixmlRequest = node;
                } else if (this.validation == 2) {
                    this.ixmlRequest = null;
                } else {
                    throw new OAIException(4, "GetRecord missing requestURL");
                }
                this.state = 1;
                xpath = null;
                prefixResolver = null;
                xpathSupport = null;
                list = null;
            }
            catch (TransformerException te) {
                throw new OAIException(14, te.getMessage());
            }
            url = null;
            docFactory = null;
            docBuilder = null;
        }
        catch (IOException ie) {
            throw new OAIException(14, ie.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            throw new OAIException(14, fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new OAIException(14, pce.getMessage());
        }
        return this.strRepositoryName;
    }

    public OAIRecordList listIdentifiers() throws OAIException {
        return this.listIdentifiers("", "", "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String untild) throws OAIException {
        return this.listIdentifiers(untild, "", "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String untild, String fromd) throws OAIException {
        return this.listIdentifiers(untild, fromd, "", "oai_dc");
    }

    public OAIRecordList listIdentifiers(String untild, String fromd, String setSpec) throws OAIException {
        return this.listIdentifiers(untild, fromd, setSpec, "oai_dc");
    }

    public OAIRecordList listIdentifiers(String untild, String fromd, String setSpec, String metadataPrefix) throws OAIException {
        this.priCheckBaseURL();
        String prefix = metadataPrefix;
        if (this.getProtocolMajorVersion() > 1 && metadataPrefix.length() == 0) {
            prefix = "oai_dc";
        }
        String params = this.priBuildParamString(untild, fromd, setSpec, "", prefix);
        OAIResumptionStream rs = new OAIResumptionStream(this, this.strBaseURL, "ListIdentifiers", params);
        OAIRecordList sets = new OAIRecordList();
        sets.frndSetOAIResumptionStream(rs);
        return sets;
    }

    public OAIRecordList listRecords() throws OAIException {
        return this.listRecords("oai_dc", "", "", "");
    }

    public OAIRecordList listRecords(String metadataPrefix) throws OAIException {
        return this.listRecords(metadataPrefix, "", "", "");
    }

    public OAIRecordList listRecords(String metadataPrefix, String untild) throws OAIException {
        return this.listRecords(metadataPrefix, untild, "", "");
    }

    public OAIRecordList listRecords(String metadataPrefix, String untild, String fromd) throws OAIException {
        return this.listRecords(metadataPrefix, untild, fromd, "");
    }

    public OAIRecordList listRecords(String metadataPrefix, String untild, String fromd, String setSpec) throws OAIException {
        this.priCheckBaseURL();
        String prefix = metadataPrefix;
        prefix = metadataPrefix.length() == 0 ? "oai_dc" : metadataPrefix;
        String params = this.priBuildParamString(untild, fromd, setSpec, "", prefix);
        OAIResumptionStream rs = new OAIResumptionStream(this, this.strBaseURL, "ListRecords", params);
        OAIRecordList sets = new OAIRecordList();
        sets.frndSetOAIResumptionStream(rs);
        sets.frndSetMetadataPrefix(metadataPrefix);
        return sets;
    }

    public String getRepositoryIdentifier() throws OAIException {
        String ret = "";
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier() && this.strRepositoryId.length() == 0 && this.validation == 1) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        if (!this.usesOAIIdentifier() && this.strRepositoryId.length() == 0) {
            return ret;
        }
        try {
            for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(i), (String)"//oai_id:description/id:oai-identifier/id:repositoryIdentifier", (Node)this.descrNamespaceNode);
                if (node == null) continue;
                ret = node.getFirstChild().getNodeValue();
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public Node getOAIIdentifierDescription() throws OAIException {
        Node node = null;
        Node ret = null;
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier()) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
            node = this.ixmlDescriptions.item(i);
            if (!node.getNamespaceURI().equals(XMLNS_ID) && !node.getNamespaceURI().equals(XMLNS_ID_1_0) && !node.getNamespaceURI().equals("XMLNS_ID_1_0_aps")) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public Node getEPrintsDescription() throws OAIException {
        Node ret = null;
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier()) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
            Node node = this.ixmlDescriptions.item(i);
            if (!node.getNamespaceURI().equals(XMLNS_EPR) && !node.getNamespaceURI().equals(XMLNS_EPR_1_0)) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public void setRetryLimit(int rl) {
        this.iRetryLimit = rl;
    }

    public int getRetryLimit() {
        return this.iRetryLimit;
    }

    public String getSampleIdentifier() throws OAIException {
        String ret = "";
        if (this.state == 0) {
            this.identify();
        }
        if (!this.usesOAIIdentifier() && this.validation == 1) {
            throw new OAIException(8, "The RepositoryIdentifier is unknown");
        }
        if (!this.usesOAIIdentifier()) {
            return ret;
        }
        try {
            for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(i), (String)"//oai_id:description/id:oai-identifier/id:sampleIdentifier", (Node)this.descrNamespaceNode);
                if (ret == null) continue;
                ret = node.getFirstChild().getNodeValue();
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public String getRepositoryName() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.strRepositoryName;
    }

    public String getAdminEmail() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.getAdminEmail(0);
    }

    public String getAdminEmail(int i) throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getAdminEmailCount() > 0 && i < this.getAdminEmailCount()) {
            return this.strAdminEmail[i];
        }
        return "";
    }

    public String getCompression() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.getCompression(0);
    }

    public String getCompression(int i) throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        if (this.getCompressionCount() > 0 && i < this.getCompressionCount()) {
            return this.strCompression[i];
        }
        return "";
    }

    public int getProtocolMajorVersion() throws OAIException {
        int ver = 0;
        if (this.state == 0) {
            this.identify();
        }
        try {
            ver = Integer.parseInt(this.strProtocolVersion.trim().substring(0, 1));
        }
        catch (NumberFormatException ne) {
            ver = 0;
        }
        return ver;
    }

    public String getProtocolVersion() throws OAIException {
        if (this.state == 0) {
            this.identify();
        }
        return this.strProtocolVersion;
    }

    public String getRequestURL() {
        String ret = this.ixmlRequest.getFirstChild().getNodeValue();
        NamedNodeMap map = this.ixmlRequest.getAttributes();
        Node n = map.getNamedItem("verb");
        if (n != null) {
            ret = ret + "?verb=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("identifier")) != null) {
            ret = ret + "&identifier=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("metadataPrefix")) != null) {
            ret = ret + "&metadataPrefix=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("from")) != null) {
            ret = ret + "&from=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("until")) != null) {
            ret = ret + "&until=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("set")) != null) {
            ret = ret + "&set=" + n.getNodeValue();
        }
        if ((n = map.getNamedItem("resumptionToken")) != null) {
            try {
                ret = ret + "&resumptionToken=" + URLEncoder.encode(n.getNodeValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ret = ret + "&resumptionToken=" + n.getNodeValue();
            }
        }
        return ret;
    }

    public String getUserAgent() {
        return this.strUserAgent;
    }

    public void setUserAgent(String ua) {
        this.strUserAgent = ua;
    }

    public String getFrom() {
        return this.strFrom;
    }

    public void setFrom(String f) {
        this.strFrom = f;
    }

    protected HttpURLConnection frndTrySend(HttpURLConnection h) throws OAIException {
        HttpURLConnection http = h;
        boolean done = false;
        GregorianCalendar sendTime = new GregorianCalendar();
        GregorianCalendar testTime = new GregorianCalendar();
        GregorianCalendar retryTime = null;
        int retryCount = 0;
        do {
            try {
                http.setRequestProperty("User-Agent", this.strUserAgent);
                http.setRequestProperty("From", this.strFrom);
                if (this.strUser != null && this.strUser.length() > 0) {
                    byte[] encodedPassword = (this.strUser + ":" + this.strPassword).getBytes();
                    BASE64Encoder encoder = new BASE64Encoder();
                    http.setRequestProperty("Authorization", "Basic " + encoder.encode(encodedPassword));
                }
                sendTime.setTime(new Date());
                http.connect();
                if (http.getResponseCode() == 200) {
                    done = true;
                    continue;
                }
                if (http.getResponseCode() == 503) {
                    if (++retryCount > this.iRetryLimit) {
                        throw new OAIException(11, "The RetryLimit " + this.iRetryLimit + " has been exceeded");
                    }
                    String retryAfter = http.getHeaderField("Retry-After");
                    if (retryAfter == null) {
                        throw new OAIException(10, "No Retry-After header");
                    }
                    try {
                        int sec = Integer.parseInt(retryAfter);
                        sendTime.add(13, sec);
                        retryTime = sendTime;
                    }
                    catch (NumberFormatException ne) {
                        try {
                            Date retryDate = DateFormat.getDateInstance().parse(retryAfter);
                            retryTime = new GregorianCalendar();
                            retryTime.setTime(retryDate);
                        }
                        catch (ParseException pe) {
                            throw new OAIException(14, pe.getMessage());
                        }
                    }
                    if (retryTime != null) {
                        testTime.setTime(new Date());
                        testTime.add(12, this.iMaxRetryMinutes);
                        if (retryTime.getTime().before(testTime.getTime())) {
                            try {
                                while (retryTime.getTime().after(new Date())) {
                                    Thread.sleep(10000L);
                                }
                                URL url = new URL(http.getURL().toString());
                                http = (HttpURLConnection)url.openConnection();
                                continue;
                            }
                            catch (InterruptedException ie) {
                                throw new OAIException(14, ie.getMessage());
                            }
                        }
                        throw new OAIException(10, "Retry time(" + retryAfter + " sec) is too long");
                    }
                    throw new OAIException(10, retryAfter + " is not a valid Retry-After header");
                }
                if (http.getResponseCode() == 403) {
                    throw new OAIException(14, http.getResponseMessage());
                }
                if (++retryCount > this.iRetryLimit) {
                    throw new OAIException(11, "The RetryLimit " + this.iRetryLimit + " has been exceeded");
                }
                int sec = 10 * (int)Math.exp(retryCount);
                sendTime.add(13, sec);
                retryTime = sendTime;
                try {
                    while (retryTime.getTime().after(new Date())) {
                        Thread.sleep(sec * 1000);
                    }
                    URL url = new URL(http.getURL().toString());
                    http = (HttpURLConnection)url.openConnection();
                }
                catch (InterruptedException ie) {
                    throw new OAIException(14, ie.getMessage());
                }
            }
            catch (IOException ie) {
                throw new OAIException(14, ie.getMessage());
            }
        } while (!done);
        return http;
    }

    public boolean usesOAIIdentifier() throws OAIException {
        boolean ret = false;
        if (this.state == 0) {
            this.identify();
        }
        try {
            for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(i), (String)"//oai_id:description/*", (Node)this.descrNamespaceNode);
                if (node == null || !node.getNamespaceURI().equals(XMLNS_ID) && !node.getNamespaceURI().equals(XMLNS_ID_1_0) && !node.getNamespaceURI().equals("XMLNS_ID_1_0_aps")) continue;
                ret = true;
                break;
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public boolean usesEPrints() throws OAIException {
        boolean ret = false;
        if (this.state == 0) {
            this.identify();
        }
        try {
            for (int i = 0; i < this.ixmlDescriptions.getLength(); ++i) {
                Node node = XPathAPI.selectSingleNode((Node)this.ixmlDescriptions.item(i), (String)"//oai_id:description/*", (Node)this.descrNamespaceNode);
                if (node == null || !node.getNamespaceURI().equals(XMLNS_EPR) && !node.getNamespaceURI().equals(XMLNS_EPR_1_0)) continue;
                ret = true;
                break;
            }
        }
        catch (TransformerException te) {
            throw new OAIException(14, te.getMessage());
        }
        return ret;
    }

    public int getValidation() {
        return this.validation;
    }

    public void setValidation(int v) {
        this.validation = v;
    }

    public OAIMetadataFormatList listMetadataFormats() throws OAIException {
        return this.listMetadataFormats("");
    }

    public OAIMetadataFormatList listMetadataFormats(String identifier) throws OAIException {
        OAIMetadataFormatList sets = new OAIMetadataFormatList();
        this.priCheckBaseURL();
        String params = this.priBuildParamString("", "", "", identifier, "");
        OAIResumptionStream rs = new OAIResumptionStream(this, this.strBaseURL, "ListMetadataFormats", params);
        sets.frndSetOAIResumptionStream(rs);
        return sets;
    }

    public OAISetList listSets() throws OAIException {
        OAISetList sets = new OAISetList();
        this.priCheckBaseURL();
        OAIResumptionStream rs = new OAIResumptionStream(this, this.strBaseURL, "ListSets");
        sets.frndSetOAIResumptionStream(rs);
        return sets;
    }
}

