/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common;

import org.gcube.common.OAIException;
import org.gcube.common.OAIRecord;
import org.gcube.common.OAIRepository;
import org.gcube.common.OAIResumptionStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAIRecordList {
    private OAIRecord recCurrent;
    private String strMetadataPrefix;
    private OAIResumptionStream oaiResume;

    public OAIRecord getCurrentItem() {
        return this.recCurrent;
    }

    public int getCurrentIndex() throws OAIException {
        return this.oaiResume.getIndex();
    }

    public int getCompleteSize() throws OAIException {
        return this.oaiResume.getCompleteSize();
    }

    private void priSetCurrentItem() throws OAIException {
        Node node = this.oaiResume.getItem();
        OAIRecord s = new OAIRecord();
        if (node != null) {
            s.frndSetRepository(this.getOAIRepository());
            s.frndSetValid(this.isListValid());
            if (node.getNodeName().equals("identifier")) {
                s.frndSetIdOnly(true);
                s.frndSetIdentifier(node.getFirstChild().getNodeValue());
                NamedNodeMap nmap = node.getAttributes();
                if (nmap != null && nmap.getNamedItem("status") != null) {
                    s.frndSetStatus(nmap.getNamedItem("status").getNodeValue());
                }
            } else if (node.getNodeName().equals("metadata")) {
                s.setMetadataRecord(node.getFirstChild().getNodeValue());
            } else if (node.getNodeName().equals("header")) {
                s.frndSetIdOnly(true);
                s.frndSetMetadataPrefix(this.strMetadataPrefix);
                NodeList nl = node.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeName().equals("identifier")) {
                        s.frndSetIdentifier(nl.item(i).getFirstChild().getNodeValue());
                        continue;
                    }
                    if (nl.item(i).getNodeName().equals("datestamp")) {
                        s.frndSetDatestamp(nl.item(i).getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!nl.item(i).getNodeName().equals("setSpec") || nl.item(i).getChildNodes().getLength() <= 0) continue;
                    s.addSet(nl.item(i).getFirstChild().getNodeValue());
                }
                NamedNodeMap nmap = node.getAttributes();
                if (nmap != null && nmap.getNamedItem("status") != null) {
                    s.frndSetStatus(nmap.getNamedItem("status").getNodeValue());
                }
                s.frndSetRecord(node);
            } else if (node.getNodeName().equals("record")) {
                int i;
                Node n = null;
                NodeList nlist = node.getChildNodes();
                for (i = 0; i < nlist.getLength(); ++i) {
                    if (!nlist.item(i).getNodeName().equals("header")) continue;
                    n = nlist.item(i);
                    break;
                }
                if (n != null) {
                    s.frndSetIdOnly(false);
                    s.frndSetMetadataPrefix(this.strMetadataPrefix);
                    nlist = n.getChildNodes();
                    for (i = 0; i < nlist.getLength(); ++i) {
                        if (nlist.item(i).getNodeName().equals("identifier") && nlist.item(i).getChildNodes().getLength() > 0) {
                            s.frndSetIdentifier(nlist.item(i).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (nlist.item(i).getNodeName().equals("datestamp") && nlist.item(i).getChildNodes().getLength() > 0) {
                            s.frndSetDatestamp(nlist.item(i).getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!nlist.item(i).getNodeName().equals("setSpec") || nlist.item(i).getChildNodes().getLength() <= 0) continue;
                        s.addSet(nlist.item(i).getFirstChild().getNodeValue());
                    }
                    NamedNodeMap nmap = node.getAttributes();
                    if (nmap != null && nmap.getNamedItem("status") != null) {
                        s.frndSetStatus(nmap.getNamedItem("status").getNodeValue());
                    }
                    s.frndSetRecord(node);
                } else {
                    s = null;
                }
            } else {
                throw new OAIException(12, "Element " + node.getNodeName() + " is unknown");
            }
            this.recCurrent = s;
        } else {
            this.recCurrent = null;
        }
    }

    public boolean isListValid() {
        return this.oaiResume.isResponseValid();
    }

    public boolean moreItems() throws OAIException {
        return this.oaiResume.more();
    }

    public void moveNext() throws OAIException {
        this.oaiResume.moveNext();
        this.priSetCurrentItem();
    }

    public OAIRepository getOAIRepository() {
        return this.oaiResume.getRepository();
    }

    public void requery() throws OAIException {
        this.oaiResume.requery();
        this.priSetCurrentItem();
    }

    protected void frndSetOAIResumptionStream(OAIResumptionStream rs) throws OAIException {
        this.oaiResume = rs;
        this.priSetCurrentItem();
    }

    protected void frndSetMetadataPrefix(String meta) {
        this.strMetadataPrefix = meta;
    }
}

