/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.File;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFile
implements File {
    private static Logger logger = LoggerFactory.getLogger(JCRFile.class);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    public static final String STORAGE_PATH = "hl:storagePath";
    protected ItemDelegate itemDelegate;
    private JCRWorkspace workspace;

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate) {
        this.workspace = workspace;
        this.itemDelegate = itemDelegate;
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, MetaInfo info) throws InternalErrorException {
        this(workspace, itemDelegate);
        this.setMeta(info);
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, InputStream is) throws InternalErrorException, IOException, RemoteBackendException {
        this(workspace, itemDelegate);
        String remotePath = null;
        try {
            remotePath = (String)itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
        }
        catch (Exception e) {
            logger.error("Content not present yet in " + itemDelegate.getName());
        }
        if (remotePath == null || remotePath.isEmpty()) {
            remotePath = itemDelegate.getPath();
        }
        MetaInfo info = WorkspaceItemUtil.getMetadataInfo(is, this.getStorage(), remotePath, itemDelegate.getTitle());
        this.setMeta(info);
    }

    private void setMeta(MetaInfo info) {
        HashMap<NodeProperty, String> content = null;
        try {
            content = this.itemDelegate.getContent();
        }
        catch (Exception e) {
            logger.error("Content not present yet in " + this.itemDelegate.getName());
        }
        if (content == null) {
            content = new HashMap<NodeProperty, String>();
        }
        content.put(NodeProperty.PORTAL_LOGIN, this.workspace.getOwner().getPortalLogin());
        content.put(NodeProperty.MIME_TYPE, info.getMimeType());
        Long l = Long.valueOf(String.valueOf(info.getSize()));
        content.put(NodeProperty.SIZE, new XStream().toXML((Object)l));
        content.put(NodeProperty.STORAGE_ID, info.getStorageId());
        content.put(NodeProperty.REMOTE_STORAGE_PATH, info.getRemotePath());
        this.itemDelegate.setContent(content);
        logger.trace("GCUBEStorage ID : " + info.getStorageId());
    }

    public String getName() throws InternalErrorException {
        return this.itemDelegate.getTitle();
    }

    public String getMimeType() {
        String mimeType = null;
        try {
            mimeType = (String)this.itemDelegate.getContent().get(NodeProperty.MIME_TYPE);
        }
        catch (Exception e) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        String remotePath = null;
        String storageID = null;
        InputStream stream = null;
        try {
            storageID = (String)this.itemDelegate.getContent().get(NodeProperty.STORAGE_ID);
            if (storageID == null) {
                try {
                    remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
                    logger.trace("Retrieving streaming from Storage by Remote Path " + remotePath);
                    storageID = this.getStorage().getStorageId(remotePath);
                    this.setStorageID(storageID);
                }
                catch (Exception e1) {
                    logger.error("Remote Path not found " + e1.getMessage());
                }
            } else {
                logger.trace("Retrieving streaming from Storage by storage ID " + storageID);
            }
            if (storageID == null) {
                throw new InternalErrorException("No Storage ID and RemotePath found in node ID " + this.getName());
            }
            stream = this.getStorage().getRemoteFile(storageID);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return stream;
    }

    public long getLength() throws InternalErrorException {
        long size = 0L;
        try {
            size = (Long)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.SIZE));
            if (size <= 0L) {
                long newsize = this.getStorage().getRemoteFileSize(this.getRemotePath());
                if (newsize <= size) {
                    this.setLenght(size);
                }
                return newsize;
            }
        }
        catch (Exception e) {
            logger.error(this.itemDelegate.getTitle() + " has not size property");
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLenght(long size) {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.getPortalLogin(), false);
            this.itemDelegate.getContent().put(NodeProperty.SIZE, new XStream().toXML((Object)size));
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            logger.error("Impossible to set lenght for " + this.itemDelegate.getPath());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public String getPublicLink() throws InternalErrorException {
        try {
            String remotePath = this.getRemotePath();
            return this.getStorage().getPublicLink(remotePath);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return remotePath;
    }

    public String getStorageId() throws InternalErrorException {
        String storageId = null;
        try {
            storageId = (String)this.itemDelegate.getContent().get(NodeProperty.STORAGE_ID);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return storageId;
    }

    public void getHardLink(String destPath) throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            logger.trace("No public link for file: " + this.itemDelegate.getTitle());
            this.getStorage().createHardLink(remotePath, destPath);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void updateInfo(JCRSession servlets, MetaInfo info) throws InternalErrorException {
        long size = info.getSize();
        try {
            this.itemDelegate.getContent().put(NodeProperty.STORAGE_ID, info.getStorageId());
            this.itemDelegate.getContent().put(NodeProperty.MIME_TYPE, info.getMimeType());
            this.itemDelegate.getContent().put(NodeProperty.SIZE, new XStream().toXML((Object)size));
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected String getPortalLogin() {
        return this.workspace.getOwner().getPortalLogin();
    }

    protected GCUBEStorage getStorage() {
        return this.workspace.getStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageID(String storageID) {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.getPortalLogin(), false);
            this.itemDelegate.getContent().put(NodeProperty.STORAGE_ID, storageID);
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            logger.error("Impossible to storage ID for " + this.itemDelegate.getPath());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }
}

