/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    public static final String USERS = "hl:users";
    public static final String MEMBERS = "hl:members";
    public static final String IS_VRE_FOLDER = "hl:isVreFolder";
    public static final String DISPLAY_NAME = "hl:displayName";
    private String applicationName;
    private String destinationFolderId;
    private boolean isVreFolder;
    private String displayName;
    private String absPath;
    private String itemName;
    private List<String> users;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        this.absPath = this.getAbsolutePath();
        try {
            this.isVreFolder = node.getProperty(IS_VRE_FOLDER).getBoolean();
        }
        catch (Exception e) {
            this.isVreFolder = false;
        }
        try {
            this.displayName = node.getProperty(DISPLAY_NAME).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = this.listUsers(users);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName, String displayName, boolean isVreFolder) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = this.listUsers(users);
        this.displayName = displayName;
        this.isVreFolder = isVreFolder;
        this.absPath = this.getAbsolutePath();
        node.setProperty(IS_VRE_FOLDER, isVreFolder);
        node.setProperty(DISPLAY_NAME, displayName);
        node.getSession().save();
    }

    private List<String> listUsers(List<String> usersList) throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        JCRUserManager userManager = new JCRUserManager();
        List<GCubeGroup> groupsList = userManager.getGroups();
        for (GCubeGroup group : groupsList) {
            groups.add(group.getName());
        }
        Session session = JCRRepository.getSession();
        try {
            for (String user : usersList) {
                block12: {
                    Node sharedNode = session.getNodeByIdentifier(this.getId());
                    Node memberIds = null;
                    try {
                        memberIds = sharedNode.getNode(MEMBERS);
                    }
                    catch (Exception e) {
                        memberIds = sharedNode.addNode(MEMBERS);
                        session.save();
                        logger.warn(" Members_ids Node already exists");
                    }
                    try {
                        memberIds.getNode(user);
                    }
                    catch (Exception e) {
                        if (user.endsWith("-Manager")) break block12;
                        memberIds.addNode(user);
                        session.save();
                        logger.warn(user + " add to membersList");
                    }
                }
                if (groups.contains(user)) {
                    List<String> userList = this.workspace.resolveGroupId(user);
                    users.addAll(userList);
                    continue;
                }
                users.add(user);
            }
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return users;
    }

    @Override
    public void save(Node node) throws RepositoryException {
        try {
            this.addUser(node, this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            logger.trace("Share with " + this.users.toString());
            for (String user : this.users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                Home home = homeManager.getHome(user);
                if (this.applicationName == null) {
                    if (this.isVreFolder()) {
                        this.addUser(node, user, home.getWorkspace().getMySpecialFolders().getId());
                        continue;
                    }
                    this.addUser(node, user, home.getWorkspace().getRoot().getId());
                    continue;
                }
                this.addUser(node, user, home.getDataArea().getApplicationRoot(this.applicationName).getId());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Node getUserNode(Node node, String user) throws RepositoryException, InternalErrorException {
        Node usersNode = node.getNode(USERS);
        String value = usersNode.getProperty(user).getString();
        String[] values = value.split(this.workspace.getPathSeparator());
        if (values.length < 2) {
            throw new InternalErrorException("Path node corrupt");
        }
        String parentId = values[0];
        String nodeName = values[1];
        Node parentNode = node.getSession().getNodeByIdentifier(parentId);
        return node.getSession().getNode(parentNode.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)nodeName));
    }

    private Node getUserNode(Node node) throws RepositoryException, InternalErrorException {
        return this.getUserNode(node, this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(Node node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            Node userNode = this.getUserNode(node);
            if (this.workspace.exists(nodeNewName, userNode.getParent().getIdentifier())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = userNode.getParent().getPath() + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.RENAMED.toString());
            node.getSession().save();
            String path = userNode.getPath();
            node.getSession().getWorkspace().move(path, newPath);
            Node usersNode = node.getNode(USERS);
            String value = userNode.getParent().getIdentifier() + this.workspace.getPathSeparator() + newName;
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier());
            Session session = destinationFolderNode.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            Node userNode = this.getUserNode(node);
            String userNodeName = this.getNodeName(userNode);
            String newPath = destinationFolderNode.getPath() + this.workspace.getPathSeparator() + userNodeName;
            String value = destinationFolderNode.getIdentifier() + this.workspace.getPathSeparator() + userNodeName;
            session.getWorkspace().clone(session.getWorkspace().getName(), node.getPath(), newPath, false);
            Node usersNode = node.getNode(USERS);
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node unShareNode(Node sharedNode, Node destinationNode, boolean localCopy) throws RepositoryException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException, ItemNotFoundException, RemoteBackendException {
        logger.debug("unShare Node: " + sharedNode.getPath() + " -  by user: " + this.workspace.getOwner().getPortalLogin());
        Session session = sharedNode.getSession();
        Node userNode = this.getUserNode(sharedNode);
        String folderName = this.getNodeName(userNode);
        String description = this.getDescription();
        if (destinationNode.getIdentifier().equals(userNode.getParent().getIdentifier())) {
            this.removeUserSharedFolder(sharedNode);
        }
        if (localCopy) {
            String unSharedFolderId = this.workspace.createFolder(folderName, description, destinationNode.getIdentifier()).getId();
            Node nodeFolder = session.getNodeByIdentifier(unSharedFolderId);
            NodeIterator iterator = sharedNode.getNodes();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                session.getWorkspace().copy(child.getPath(), nodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            logger.debug("copyremotecontent from " + nodeFolder.getPath() + " to " + destinationNode.getPath());
            this.workspace.copyRemoteContent(nodeFolder, destinationNode);
            session.save();
            JCRWorkspaceItem itemUnshared = (JCRWorkspaceItem)this.workspace.getItem(unSharedFolderId);
            itemUnshared.setUnshareHistory(this.workspace.getOwner().getPortalLogin());
            itemUnshared.setOwnerToCurrentUser(itemUnshared);
            return nodeFolder;
        }
        return null;
    }

    @Override
    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Session session = nodeFolder.getSession();
        Node node = session.getNodeByIdentifier(this.identifier);
        String pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (session.getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(newName + " already exist");
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        String description = this.getDescription();
        try {
            String unSharedFolderId = this.workspace.createFolder(Text.escapeIllegalJcrChars((String)newName), description, nodeFolder.getIdentifier()).getId();
            Node newNodeFolder = session.getNodeByIdentifier(unSharedFolderId);
            NodeIterator iterator = node.getNodes();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
                session.getWorkspace().copy(child.getPath(), newNodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            return newNodeFolder;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(this.getUserNode(node));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        Node userNode = this.getUserNode(node);
        return ((JCRWorkspaceFolder)this.getParent(userNode)).getPath(userNode.getParent()) + this.workspace.getPathSeparator() + this.getNodeName(userNode);
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        logger.debug("remove shared");
        logger.debug("portalLogin: " + this.workspace.getOwner().getPortalLogin() + " - owner: " + this.getOwner().getPortalLogin());
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath(), true)) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node");
            }
            if (this.isVreFolder()) {
                throw new InternalErrorException("A VRE folder cannot be removed");
            }
            if (sharedNode.getPath().equals(this.workspace.mySpecialFoldersPath)) {
                throw new InternalErrorException("This folder cannot be removed");
            }
            try {
                WorkspaceFolder unsharedFolder = this.unShare();
                logger.trace("unsharedFolder: " + unsharedFolder.getPath());
                Node usharedNode = session.getNodeByIdentifier(unsharedFolder.getId());
                this.workspace.moveToTrash(usharedNode);
                session.save();
            }
            catch (ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<String> getMembers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.getId());
            Node members = node.getNode(MEMBERS);
            NodeIterator children = members.getNodes();
            while (children.hasNext()) {
                String name = children.nextNode().getName();
                if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                list.add(name);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    @Override
    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.getId());
            Node usersNode = node.getNode(USERS);
            PropertyIterator iterator = usersNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String name = property.getName();
                if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                list.add(name);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    private void addUser(Node sharedNode, String user, String destinationFolderId) throws InternalErrorException, RepositoryException {
        logger.trace("addUser(" + sharedNode.getPath() + ", " + user + ", " + destinationFolderId + ");");
        Session session = sharedNode.getSession();
        try {
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user).getWorkspace().getItem(destinationFolderId);
            Node rootNode = session.getNodeByIdentifier(userRoot.getId());
            String sharedFolderName = userRoot.getUniqueName(sharedNode.getProperty("jcr:title").getString(), false);
            String pathUser = null;
            Node usersNode = sharedNode.getNode(USERS);
            if (this.applicationName != null) {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath() + this.workspace.getPathSeparator() + this.itemName, pathUser, false);
                logger.trace("clone from " + sharedNode.getPath() + this.workspace.getPathSeparator() + this.itemName + " to " + pathUser);
                session.save();
            } else {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                try {
                    if (usersNode.getProperty(user) != null) {
                        return;
                    }
                }
                catch (PathNotFoundException e) {
                    logger.debug("User is not present");
                }
                session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath(), pathUser, false);
                logger.trace("Clone from " + sharedNode.getPath() + " to " + pathUser);
                session.save();
            }
            String value = userRoot.getId() + this.workspace.getPathSeparator() + sharedFolderName;
            logger.trace("usersNode: " + usersNode.getPath() + " - set value " + value + " to: " + user);
            usersNode.setProperty(user, value);
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node usersNode = sharedNode.getNode(USERS);
            try {
                if (usersNode.getProperty(user) != null) {
                    logger.trace(user + " is already in share");
                    return;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug("User " + user + " is not present");
            }
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            Home home = homeManager.getHome(user);
            if (this.isVreFolder) {
                this.addUser(sharedNode, user, home.getWorkspace().getMySpecialFolders().getId());
            } else {
                this.addUser(sharedNode, user, home.getWorkspace().getRoot().getId());
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = this.getUserNode(node);
            Node unsharedNode = null;
            JCRWorkspaceFolder folder = null;
            boolean flag = false;
            if (this.getOwner().getPortalLogin().equals(this.workspace.getOwner().getPortalLogin()) || this.getACLUser().equals((Object)ACLType.ADMINISTRATOR)) {
                flag = true;
            }
            try {
                unsharedNode = this.unShareNode(node, userNode.getParent(), flag);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (unsharedNode != null) {
                folder = new JCRWorkspaceFolder(this.workspace, unsharedNode);
                logger.trace("remove clones");
                this.removeClones(node);
                logger.trace("remove sharedNode: " + node.getPath());
                node.remove();
                session.save();
            } else {
                JCRAccessManager accessManager = new JCRAccessManager();
                ArrayList<String> userToRemove = new ArrayList<String>();
                userToRemove.add(this.workspace.getOwner().getPortalLogin());
                accessManager.deleteAces(this.getAbsolutePath(), userToRemove);
            }
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder unShare(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = node.getNode(USERS);
            if (!(user.startsWith("jcr:") || user.startsWith("hl:") || user.equals(this.workspace.getOwner().getPortalLogin()))) {
                try {
                    Node cloneNode = this.getUserNode(node, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone ");
                }
                try {
                    userNode.setProperty(user, (String)null);
                    userNode.getSession().save();
                    logger.trace(user + "  deleted from share " + node.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users ");
                }
            }
            JCRAccessManager accessManager = new JCRAccessManager();
            ArrayList<String> userToRemove = new ArrayList<String>();
            userToRemove.add(user);
            accessManager.deleteAces(this.getAbsolutePath(), userToRemove);
            this.setUnshareHistory(user);
            WorkspaceFolder workspaceFolder = null;
            return workspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder share(List<String> usersList) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        List<String> userIds = this.listUsers(usersList);
        for (String user : userIds) {
            this.addUser(user);
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode, user);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ACLType getPrivilege() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    ACLType aclType;
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty() || (aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user))).equals((Object)ACLType.ADMINISTRATOR)) continue;
                    return aclType;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return ACLType.WRITE_OWNER;
    }

    public void removeClones(Node sharedNode) throws InternalErrorException, RepositoryException {
        Session session = sharedNode.getSession();
        try {
            Node userNode = sharedNode.getNode(USERS);
            PropertyIterator usersList = userNode.getProperties();
            while (usersList.hasNext()) {
                String user = usersList.nextProperty().getName();
                if (user.startsWith("jcr:")) continue;
                logger.trace("user " + user);
                logger.trace("workspace.getOwner().getPortalLogin() " + this.workspace.getOwner().getPortalLogin());
                if (user.startsWith("jcr:") || user.startsWith("hl:")) continue;
                try {
                    Node cloneNode = this.getUserNode(sharedNode, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone " + e);
                }
                try {
                    logger.trace("remove user in userList");
                    logger.trace(user + "  deleted from share " + sharedNode.getPath());
                    userNode.setProperty(user, (String)null);
                    userNode.getSession().save();
                    logger.trace(user + "  deleted from share " + sharedNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users " + e);
                }
                try {
                    Node memberNode = sharedNode.getNode(MEMBERS);
                    memberNode.getNode(user).remove();
                    memberNode.getSession().save();
                }
                catch (Exception e) {
                    logger.error("Error removing user from members node");
                }
            }
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeUserSharedFolder(Node sharedNode) throws InternalErrorException, RepositoryException {
        Session session = sharedNode.getSession();
        try {
            Node userNode = this.getUserNode(sharedNode);
            session.removeItem(userNode.getPath());
            session.save();
            try {
                Node usersNode = sharedNode.getNode(USERS);
                usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), (String)null);
                usersNode.getSession().save();
            }
            catch (Exception e) {
                logger.error("Error removing user from users node");
            }
            try {
                Node memberNode = sharedNode.getNode(MEMBERS);
                memberNode.getNode(this.workspace.getOwner().getPortalLogin()).remove();
                memberNode.getSession().save();
            }
            catch (Exception e) {
                logger.error("Error removing user from members node");
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isVreFolder() {
        return this.isVreFolder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean addAdmin(final String username) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                this.share((List<String>)new ArrayList<String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(username);
                    }
                });
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                ArrayList<String> administator = new ArrayList<String>();
                administator.add(username);
                this.setACL(administator, ACLType.ADMINISTRATOR);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return false;
            }
            return true;
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to set administrators");
    }

    public List<String> getAdministrators() throws InternalErrorException {
        List<String> list = null;
        try {
            list = this.getACLOwner().get(ACLType.ADMINISTRATOR);
        }
        catch (Exception e) {
            logger.error("no administrators");
        }
        return list;
    }

    public boolean isAdmin(String username) throws InternalErrorException {
        return this.getACLUser().equals((Object)ACLType.ADMINISTRATOR);
    }

    public boolean setAdmins(List<String> logins) throws InsufficientPrivilegesException, InternalErrorException {
        logger.trace("setAdmins: " + logins.toString() + " on shared folder: " + this.absPath);
        if (this.isAdmin(this.workspace.getOwner().getPortalLogin())) {
            try {
                List<String> notAdmins = this.getAdministrators();
                try {
                    notAdmins.removeAll(logins);
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.absPath);
                }
                try {
                    notAdmins.remove(this.getOwner().getPortalLogin());
                }
                catch (Exception e) {
                    logger.trace("Admins not alredy set on " + this.absPath);
                }
                ACLType privilege = this.getPrivilege();
                logger.trace("Set " + privilege + " on users " + notAdmins);
                JCRAccessManager accessManager = new JCRAccessManager();
                logger.trace("Setting " + privilege + " on users " + notAdmins);
                try {
                    accessManager.deleteAces(this.absPath, notAdmins);
                }
                catch (Exception e) {
                    logger.error("Error deleting aces on " + this.absPath);
                }
                try {
                    this.setACL(notAdmins, privilege);
                }
                catch (Exception e) {
                    logger.error("Error setting aces on " + this.absPath);
                }
                try {
                    logins.removeAll(notAdmins);
                }
                catch (Exception e) {
                    logger.error("error removing all");
                }
                logger.trace("Setting Admin on users " + logins);
                for (String user : logins) {
                    this.addAdmin(user);
                }
                return true;
            }
            catch (Exception e) {
                logger.error("Error setting admins on node " + this.absPath, (Throwable)e);
                return false;
            }
        }
        throw new InsufficientPrivilegesException("Insufficient Privileges to edit administrators");
    }

    public void setACL(List<String> users, ACLType privilege) throws InternalErrorException {
        ArrayList<String> notAdmins = new ArrayList<String>(users);
        List<String> admins = this.getAdministrators();
        if (admins != null) {
            notAdmins.removeAll(admins);
            logger.info("notAdmin users " + ((Object)notAdmins).toString());
        } else {
            logger.info("No Administrators on " + this.absPath);
        }
        boolean flag = false;
        JCRAccessManager accessManager = new JCRAccessManager();
        int i = 0;
        while (!flag && i < 3) {
            ++i;
            try {
                if (this.absPath == null) {
                    throw new InternalErrorException("Absolute path cannot be null setting ACL");
                }
                switch (privilege) {
                    case READ_ONLY: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setReadOnlyACL(notAdmins, this.absPath);
                        break;
                    }
                    case WRITE_OWNER: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteOwnerACL(notAdmins, this.absPath);
                        break;
                    }
                    case WRITE_ALL: {
                        if (notAdmins.size() <= 0) break;
                        flag = accessManager.setWriteAllACL(notAdmins, this.absPath);
                        break;
                    }
                    case ADMINISTRATOR: {
                        flag = accessManager.setAdminACL(users, this.absPath);
                        break;
                    }
                }
                if (flag) continue;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("an error occurred setting ACL on: " + this.absPath);
            }
        }
        logger.info("Has ACL been modified correctly for users " + users.toString() + "in path " + this.absPath + "? " + flag);
        this.setAdministrators(accessManager, admins);
    }

    private void setAdministrators(JCRAccessManager accessManager, List<String> admins) {
        if (!this.isVreFolder() && admins == null) {
            boolean isSet = false;
            int j = 0;
            while (!isSet && j < 3) {
                ++j;
                try {
                    String owner = this.workspace.getOwner().getPortalLogin();
                    ArrayList<String> adminList = new ArrayList<String>();
                    adminList.add(owner);
                    logger.info("Set " + owner + " ad administrator");
                    isSet = accessManager.setAdminACL(adminList, this.absPath);
                    logger.info("Has ACL been modified correctly for users " + ((Object)adminList).toString() + "in path " + this.absPath + "? " + isSet);
                    if (isSet) continue;
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    logger.error("Error setting administators on " + this.absPath);
                }
            }
        }
    }

    public List<String> getGroups() throws InternalErrorException {
        ArrayList<String> groups = new ArrayList<String>();
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        List<String> members = this.getMembers();
        for (String member : members) {
            if (!gm.isGroup(member).booleanValue()) continue;
            groups.add(member);
        }
        return groups;
    }
}

