/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceTrashItem
extends JCRWorkspaceItem
implements WorkspaceTrashItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String DELETE_DATE = "hl:deleteDate";
    protected static final String DELETE_USER = "hl:deleteUser";
    protected static final String ORIGINAL_PARENT_ID = "hl:originalParentId";
    protected static final String ORIGINAL_PATH = "hl:originalPath";
    protected static final String NAME = "hl:originalName";
    protected static final String MIME_TYPE = "hl:mimeType";
    protected static final String LENGTH = "hl:length";
    protected static final String GROUP_IDS = "hl:groupId";
    protected static final String USERS_LIST = "hl:users";
    protected static final String IS_FOLDER = "hl:isFolder";
    private final JCRWorkspace workspace;
    private String identifier;
    private Calendar deleteDate;
    private String name;
    private String originalParentId;
    private String deleteUser;
    private String mimeType;
    private long length;
    private List<String> groupIds;
    private List<String> users;
    private boolean isFolder;
    private String originalPath;

    public JCRWorkspaceTrashItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        this.identifier = node.getIdentifier();
        this.workspace = workspace;
        this.name = node.getProperty(NAME).getString();
        this.deleteDate = node.getProperty(DELETE_DATE).getDate();
        this.deleteUser = node.getProperty(DELETE_USER).getString();
        this.originalParentId = node.getProperty(ORIGINAL_PARENT_ID).getString();
        this.isFolder = node.getProperty(IS_FOLDER).getBoolean();
        this.originalPath = node.getProperty(ORIGINAL_PATH).getString();
        try {
            this.mimeType = node.getProperty(MIME_TYPE).getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.length = node.getProperty(LENGTH).getLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCRWorkspaceTrashItem(JCRWorkspace workspace, Node node, String name, String description, Calendar date, String portalLogin, String originalParentId, String mimeType, long length, List<String> users, List<String> groupIds, boolean isFolder, String originalPath) throws RepositoryException {
        super(workspace, node, name, description);
        this.identifier = node.getIdentifier();
        this.workspace = workspace;
        this.name = name;
        this.deleteUser = portalLogin;
        this.deleteDate = date;
        this.originalParentId = originalParentId;
        this.originalPath = originalPath;
        this.mimeType = mimeType;
        this.length = length;
        this.isFolder = isFolder;
        node.setProperty(NAME, name);
        node.setProperty(DELETE_DATE, Calendar.getInstance());
        node.setProperty(DELETE_USER, portalLogin);
        node.setProperty(ORIGINAL_PARENT_ID, originalParentId);
        node.setProperty(ORIGINAL_PATH, originalPath);
        node.setProperty(MIME_TYPE, mimeType);
        node.setProperty(LENGTH, length);
        node.setProperty(IS_FOLDER, isFolder);
        if (groupIds != null) {
            node.setProperty(GROUP_IDS, groupIds.toArray(new String[0]));
        }
        if (users != null) {
            node.setProperty(USERS_LIST, users.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        Node node = null;
        try {
            block13: {
                node = session.getNodeByIdentifier(this.identifier).getNode(this.getName());
                Node originalParentNode = session.getNodeByIdentifier(this.originalParentId);
                try {
                    this.workspace.moveItem(node.getIdentifier(), this.originalParentId);
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
                try {
                    if (this.getUsers().isEmpty()) break block13;
                    JCRWorkspaceSharedFolder item = (JCRWorkspaceSharedFolder)this.workspace.getWorkspaceItem(node);
                    try {
                        item.share(this.getUsers());
                    }
                    catch (InsufficientPrivilegesException | WrongDestinationException e) {
                        e.printStackTrace();
                        throw new InternalErrorException(e);
                    }
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            session.getNodeByIdentifier(this.identifier).remove();
            session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (RemoteBackendException e) {
            e.printStackTrace();
        }
        finally {
            session.logout();
        }
    }

    public void deletePermanently() throws InternalErrorException {
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            JCRWorkspaceItem item = this.workspace.getWorkspaceItem(node);
            logger.debug("deletePermanently node: " + node.getPath());
            try {
                this.removeRemoteContent(node.getNode(item.getName()), this.getType());
            }
            catch (Exception e) {
                // empty catch block
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void removeRemoteContent(Node node, WorkspaceItemType workspaceItemType) throws RepositoryException, RemoteBackendException {
        block5: {
            try {
                Node contentNode = node.getNode(CONTENT);
                if (!contentNode.hasProperty("hl:remotePath")) break block5;
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                try {
                    if (workspaceItemType == WorkspaceItemType.FOLDER) {
                        GCUBEStorage.removeRemoteFolder(remotePath);
                        break block5;
                    }
                    GCUBEStorage.removeRemoteFile(remotePath);
                }
                catch (Exception e) {
                    logger.warn(node.getName() + " payload not available", (Throwable)e);
                }
            }
            catch (PathNotFoundException e) {
                logger.error("Content node jcr:content not found", (Throwable)e);
            }
        }
    }

    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_ITEM;
    }

    public long getLength() throws InternalErrorException {
        return this.length;
    }

    public String getMimeType() throws InternalErrorException {
        return this.mimeType;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public String getOriginalParentId() {
        return this.originalParentId;
    }

    public Calendar getDeleteDate() {
        return this.deleteDate;
    }

    public String getDeleteUser() {
        return this.deleteUser;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.TRASH_ITEM;
    }

    public String getWorkflowId() throws InternalErrorException {
        return null;
    }

    public void setWorkflowId(String id) throws InternalErrorException {
    }

    public String getWorkflowStatus() throws InternalErrorException {
        return null;
    }

    public void setWorkflowStatus(String status) throws InternalErrorException {
    }

    public String getWorkflowData() throws InternalErrorException {
        return null;
    }

    public void setWorkflowData(String data) throws InternalErrorException {
    }

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return null;
    }

    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
    }
}

