/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;

public class JCRWorkspaceTrashFolder
extends JCRWorkspaceFolder
implements WorkspaceTrashFolder {
    protected String identifier;
    public static final String NT_TRASH_ITEM = "nthl:trashItem";

    public JCRWorkspaceTrashFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        this.identifier = node.getIdentifier();
    }

    public WorkspaceTrashItem getTrashItemById(String id) throws InternalErrorException {
        JCRWorkspaceTrashItem trashItem;
        block7: {
            Session session = null;
            Node trashNode = null;
            trashItem = null;
            try {
                session = JCRRepository.getSession();
                trashNode = session.getNodeByIdentifier(id);
                if (!trashNode.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)) break block7;
                try {
                    trashItem = new JCRWorkspaceTrashItem(this.workspace, trashNode);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Trash not found " + e);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                session.logout();
            }
        }
        return trashItem;
    }

    public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
        Session session = null;
        Node node = null;
        ArrayList<WorkspaceTrashItem> children = null;
        try {
            session = JCRRepository.getSession();
            children = new ArrayList<WorkspaceTrashItem>();
            node = session.getNodeByIdentifier(this.identifier);
            NodeIterator trashNodes = node.getNodes();
            while (trashNodes.hasNext()) {
                Node trashNode = trashNodes.nextNode();
                if (!trashNode.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)) continue;
                WorkspaceTrashItem trashItem = (WorkspaceTrashItem)this.workspace.getItem(trashNode.getIdentifier());
                children.add(trashItem);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return children;
    }

    public List<? extends WorkspaceItem> listTrash() throws InternalErrorException {
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            JCRWorkspaceItem item = this.workspace.getWorkspaceItem(node);
            List children = item.getChildren();
            for (WorkspaceItem child : children) {
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    public List<String> emptyTrash() throws InternalErrorException {
        Session session = null;
        Node trashNode = null;
        try {
            session = JCRRepository.getSession();
            trashNode = session.getNodeByIdentifier(this.identifier);
            NodeIterator children = trashNode.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                if (!child.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)) continue;
                try {
                    JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                    trashItem.deletePermanently();
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
                child.remove();
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    public List<String> restoreAll() throws InternalErrorException {
        Session session = null;
        Node trashNode = null;
        try {
            session = JCRRepository.getSession();
            trashNode = session.getNodeByIdentifier(this.identifier);
            NodeIterator children = trashNode.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                if (!child.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)) continue;
                try {
                    JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                    trashItem.restore();
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_FOLDER;
    }
}

