/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRReport
extends JCRWorkspaceFolderItem
implements Report {
    private static final String CREATED = "hl:created";
    private static final String LAST_EDIT = "hl:lastEdit";
    private static final String AUTHOR = "hl:author";
    private static final String LAST_EDIT_BY = "hl:lastEditBy";
    private static final String TEMPLATE_NAME = "hl:templateName";
    private static final String NUMBER_OF_SECTION = "hl:numberOfSection";
    private static final String STATUS = "hl:status";
    private static final String NT_CONTENT = "nthl:reportItemContent";
    private final JCRFile file;

    public JCRReport(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
        Node nodeContent = node.getNode("jcr:content");
        this.file = new JCRFile(nodeContent);
    }

    public JCRReport(JCRWorkspace workspace, Node node, String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData) throws RepositoryException, RemoteBackendException {
        super(workspace, node, name, description);
        Validate.notNull((Object)created, (String)"Created must be not null");
        Validate.notNull((Object)lastEdit, (String)"LastEdit must be not null");
        Validate.notNull((Object)author, (String)"Author must be not null");
        Validate.notNull((Object)lastEditBy, (String)"LastEditBy must be not null");
        Validate.notNull((Object)templateName, (String)"TemplateName must be not null");
        Validate.notNull((Object)status, (String)"Status must be not null");
        Validate.notNull((Object)reportData, (String)"ReportData must be not null");
        node.setProperty("hl:workspaceItemType", FolderItemType.REPORT.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        this.file = new JCRFile(contentNode, new BufferedInputStream(reportData));
        contentNode.setProperty(TEMPLATE_NAME, templateName);
        contentNode.setProperty(AUTHOR, author);
        contentNode.setProperty(CREATED, created);
        contentNode.setProperty(LAST_EDIT, lastEdit);
        contentNode.setProperty(LAST_EDIT_BY, lastEditBy);
        contentNode.setProperty(NUMBER_OF_SECTION, (long)numberOfSections);
        contentNode.setProperty(STATUS, status);
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.file.getLength();
    }

    public InputStream getData() throws InternalErrorException {
        return this.file.getData();
    }

    public Calendar getCreated() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            Calendar calendar = contentNode.getProperty(CREATED).getDate();
            return calendar;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public Calendar getLastEdit() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            Calendar calendar = contentNode.getProperty(LAST_EDIT).getDate();
            return calendar;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getAuthor() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            String string = contentNode.getProperty(AUTHOR).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getLastEditBy() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            String string = contentNode.getProperty(LAST_EDIT_BY).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getTemplateName() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            String string = contentNode.getProperty(TEMPLATE_NAME).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public int getNumberOfSections() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            int n = (int)contentNode.getProperty(NUMBER_OF_SECTION).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getStatus() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            Node contentNode = node.getNode("jcr:content");
            String string = contentNode.getProperty(STATUS).getString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.REPORT;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.file.save(node);
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

