/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    public static final String USERS = "hl:users";
    public static final String GROUP_IDS = "hl:groupIds";
    public static final String IS_VRE_FOLDER = "hl:isVreFolder";
    public static final String DISPLAY_NAME = "hl:displayName";
    private static final String READ_ONLY = "jcr:read";
    private static final String WRITE_OWNER = "jcr:write";
    private static final String WRITE_ALL = "hl:writeAll";
    private static final String ADMINISTRATOR = "jcr:all";
    private String applicationName;
    private String destinationFolderId;
    private String trashFolderId;
    private List<String> users;
    private List<String> groupIds;
    private boolean isVreFolder;
    private String displayName;
    private String absPath;
    private String itemName;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        this.trashFolderId = workspace.trashId;
        this.absPath = node.getPath();
        try {
            this.isVreFolder = node.getProperty(IS_VRE_FOLDER).getBoolean();
        }
        catch (Exception e) {
            this.isVreFolder = false;
        }
        try {
            this.displayName = node.getProperty(DISPLAY_NAME).getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.groupIds = this.getGroupIds(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, List<String> users, String applicationName, String itemName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = users;
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String originalDestinationFolderId, String applicationName, String itemName, String groupId, String displayName, boolean isVreFolder) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = originalDestinationFolderId;
        this.applicationName = applicationName;
        this.itemName = itemName;
        this.users = workspace.resolveGroupId(groupId);
        this.displayName = displayName;
        this.isVreFolder = isVreFolder;
        this.absPath = node.getPath();
        node.setProperty(IS_VRE_FOLDER, isVreFolder);
        node.setProperty(DISPLAY_NAME, displayName);
        Node groupNode = node.getNode(GROUP_IDS);
        try {
            groupNode.addNode(groupId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        node.getSession().save();
        this.groupIds = this.getGroupIds(node);
    }

    @Override
    public void save(Node node) throws RepositoryException {
        try {
            this.addUser(node, this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            for (String user : this.users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                Home home = homeManager.getHome(user);
                if (this.applicationName == null) {
                    this.addUser(node, user, home.getWorkspace().getRoot().getId());
                    continue;
                }
                this.addUser(node, user, home.getDataArea().getApplicationRoot(this.applicationName).getId());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Node getUserNode(Node node, String user) throws RepositoryException, InternalErrorException {
        Node usersNode = node.getNode(USERS);
        String value = usersNode.getProperty(user).getString();
        String[] values = value.split(this.workspace.getPathSeparator());
        if (values.length < 2) {
            throw new InternalErrorException("Path node corrupt");
        }
        String parentId = values[0];
        String nodeName = values[1];
        Node parentNode = node.getSession().getNodeByIdentifier(parentId);
        return node.getSession().getNode(parentNode.getPath() + this.workspace.getPathSeparator() + nodeName);
    }

    private Node getUserNode(Node node) throws RepositoryException, InternalErrorException {
        return this.getUserNode(node, this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(Node node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            Node userNode = this.getUserNode(node);
            if (this.workspace.exists(nodeNewName, userNode.getParent().getIdentifier())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = userNode.getParent().getPath() + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.RENAMED.toString());
            node.getSession().save();
            String path = userNode.getPath();
            node.getSession().getWorkspace().move(path, newPath);
            Node usersNode = node.getNode(USERS);
            String value = userNode.getParent().getIdentifier() + this.workspace.getPathSeparator() + newName;
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier());
            Session session = destinationFolderNode.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            Node userNode = this.getUserNode(node);
            String userNodeName = this.getNodeName(userNode);
            String newPath = destinationFolderNode.getPath() + this.workspace.getPathSeparator() + userNodeName;
            String value = destinationFolderNode.getIdentifier() + this.workspace.getPathSeparator() + userNodeName;
            session.getWorkspace().clone(session.getWorkspace().getName(), node.getPath(), newPath, false);
            Node usersNode = node.getNode(USERS);
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node unShareNode(Node sharedNode, Node destinationNode) throws RepositoryException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException, ItemNotFoundException, RemoteBackendException {
        logger.debug("unShare Node: " + sharedNode.getPath() + " -  by user: " + this.workspace.getOwner().getPortalLogin());
        Session session = sharedNode.getSession();
        Node userNode = this.getUserNode(sharedNode);
        JCRWorkspaceItem itemUnshared = (JCRWorkspaceItem)this.workspace.getItem(sharedNode.getIdentifier());
        itemUnshared.setUnshareHistory(this.workspace.getOwner().getPortalLogin());
        session.save();
        if (destinationNode.getIdentifier().equals(userNode.getParent().getIdentifier())) {
            this.removeUserSharedFolder(sharedNode);
            session.save();
        }
        session.save();
        return destinationNode;
    }

    @Override
    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Session session = nodeFolder.getSession();
        Node node = session.getNodeByIdentifier(this.identifier);
        String pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (session.getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(newName + " already exist");
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        String description = this.getDescription();
        try {
            String unSharedFolderId = this.workspace.createFolder(Text.escapeIllegalJcrChars((String)newName), description, nodeFolder.getIdentifier()).getId();
            Node newNodeFolder = session.getNodeByIdentifier(unSharedFolderId);
            NodeIterator iterator = node.getNodes();
            while (iterator.hasNext()) {
                Node child = (Node)iterator.next();
                if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:")) continue;
                session.getWorkspace().copy(child.getPath(), newNodeFolder.getPath() + this.workspace.getPathSeparator() + child.getName());
            }
            return newNodeFolder;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(this.getUserNode(node));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        Node userNode = this.getUserNode(node);
        return ((JCRWorkspaceFolder)this.getParent(userNode)).getPath(userNode.getParent()) + this.workspace.getPathSeparator() + this.getNodeName(userNode);
    }

    public void removeUserSharedFolder(Node sharedNode) throws InternalErrorException {
        try {
            Session session = sharedNode.getSession();
            Node userNode = this.getUserNode(sharedNode);
            Node usersNode = sharedNode.getNode(USERS);
            usersNode.getProperty(this.workspace.getOwner().getPortalLogin()).remove();
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        logger.debug("remove shared");
        logger.debug("portalLogin: " + this.workspace.getOwner().getPortalLogin() + " - owner: " + this.getOwner().getPortalLogin());
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            if (!JCRPrivilegesInfo.canDelete(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getSharePath(), true)) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node");
            }
            if (this.isVreFolder()) {
                throw new InternalErrorException("A VRE folder cannot be removed");
            }
            try {
                this.workspace.moveToTrash(sharedNode, true);
            }
            catch (ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.getId());
            Node usersNode = node.getNode(USERS);
            PropertyIterator iterator = usersNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String name = property.getName();
                if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                list.add(name);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    private void addUser(Node sharedNode, String user, String destinationFolderId) throws InternalErrorException, RepositoryException {
        logger.trace("addUser(" + sharedNode.getPath() + ", " + user + ", " + destinationFolderId + ");");
        try {
            Session session = sharedNode.getSession();
            Node destinationNode = session.getNodeByIdentifier(destinationFolderId);
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user).getWorkspace().getItem(destinationFolderId);
            Node rootNode = session.getNodeByIdentifier(userRoot.getId());
            String sharedFolderName = WorkspaceUtil.getUniqueName((String)sharedNode.getProperty("jcr:title").getString(), (WorkspaceFolder)userRoot);
            String pathUser = null;
            Node usersNode = sharedNode.getNode(USERS);
            if (this.applicationName != null) {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath() + this.workspace.getPathSeparator() + this.itemName, pathUser, false);
                logger.trace("clone from " + sharedNode.getPath() + this.workspace.getPathSeparator() + this.itemName + " to " + pathUser);
                session.save();
            } else {
                pathUser = rootNode.getPath() + this.workspace.getPathSeparator() + sharedFolderName;
                try {
                    if (usersNode.getProperty(user) != null) {
                        return;
                    }
                }
                catch (PathNotFoundException e) {
                    logger.debug("User is not present");
                }
                session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath(), pathUser, false);
                session.save();
            }
            String value = userRoot.getId() + this.workspace.getPathSeparator() + sharedFolderName;
            usersNode.setProperty(user, value);
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node usersNode = sharedNode.getNode(USERS);
            try {
                if (usersNode.getProperty(user) != null) {
                    return;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug("User " + user + " is not present");
            }
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            Home home = homeManager.getHome(user);
            this.addUser(sharedNode, user, home.getWorkspace().getRoot().getId());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = this.getUserNode(node);
            this.unShareNode(node, userNode.getParent());
            JCRAccessManager accessManager = new JCRAccessManager();
            ArrayList<String> userToRemove = new ArrayList<String>();
            userToRemove.add(this.workspace.getOwner().getPortalLogin());
            accessManager.deleteAces(this.getSharePath(), userToRemove);
            WorkspaceFolder workspaceFolder = null;
            return workspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder unShare(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = node.getNode(USERS);
            if (!(user.startsWith("jcr:") || user.startsWith("hl:") || user.equals(this.workspace.getOwner().getPortalLogin()))) {
                try {
                    Node cloneNode = this.getUserNode(node, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone ");
                }
                try {
                    userNode.setProperty(user, (String)null);
                    userNode.getSession().save();
                    logger.trace(user + "  deleted from share " + node.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users ");
                }
            }
            JCRAccessManager accessManager = new JCRAccessManager();
            ArrayList<String> userToRemove = new ArrayList<String>();
            userToRemove.add(user);
            accessManager.deleteAces(this.getSharePath(), userToRemove);
            this.setUnshareHistory(user);
            WorkspaceFolder workspaceFolder = null;
            return workspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder share(List<String> users) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        for (String user : users) {
            this.addUser(user);
        }
        try {
            this.setShareHistory(users, this.workspace.getOwner().getPortalLogin());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode, user);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getSharePath() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String string = session.getNodeByIdentifier(this.identifier).getPath();
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setACL(List<String> users, ACLType privilege) throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getSharePath();
            switch (privilege) {
                case READ_ONLY: {
                    accessManager.setReadOnlyACL(users, absPath);
                    break;
                }
                case WRITE_OWNER: {
                    accessManager.setWriteOwnerACL(users, absPath);
                    break;
                }
                case WRITE_ALL: {
                    accessManager.setWriteAllACL(users, absPath);
                    break;
                }
                case ADMINISTRATOR: {
                    accessManager.setAdminACL(users, absPath);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        ArrayList<String> userList = null;
        try {
            userList = new ArrayList<String>();
            userList.add(this.getOwner().getPortalLogin());
            accessManager.setAdminACL(userList, absPath);
        }
        catch (Exception e) {
            logger.error("Error setting owner as administator");
        }
    }

    public Map<ACLType, List<String>> getACLOwner() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        HashMap<ACLType, List<String>> map = new HashMap<ACLType, List<String>>();
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getSharePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (final String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty()) continue;
                    List<String> acl = aclMap.get(user);
                    ACLType aclType = this.getACLTypeByKey(aclMap.get(user));
                    List users = null;
                    try {
                        users = (List)map.get(aclType);
                        users.add(user);
                        map.put(aclType, users);
                    }
                    catch (Exception e) {
                        map.put(aclType, (List<String>)new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(user);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return map;
    }

    private ACLType getACLTypeByKey(List<String> list) {
        switch (list.get(0)) {
            case "jcr:read": {
                return ACLType.READ_ONLY;
            }
            case "jcr:write": {
                return ACLType.WRITE_OWNER;
            }
            case "hl:writeAll": {
                return ACLType.WRITE_ALL;
            }
            case "jcr:all": {
                return ACLType.ADMINISTRATOR;
            }
        }
        return ACLType.READ_ONLY;
    }

    public void removeUsers(Node sharedNode) throws InternalErrorException, RepositoryException {
        Session session = sharedNode.getSession();
        try {
            Node userNode = sharedNode.getNode(USERS);
            PropertyIterator usersList = userNode.getProperties();
            while (usersList.hasNext()) {
                String user = usersList.nextProperty().getName();
                if (user.startsWith("jcr:") || user.startsWith("hl:") || user.equals(this.workspace.getOwner().getPortalLogin())) continue;
                try {
                    Node cloneNode = this.getUserNode(sharedNode, user);
                    logger.trace("remove clone " + cloneNode.getPath());
                    session.removeItem(cloneNode.getPath());
                    session.save();
                }
                catch (Exception e) {
                    logger.error("Error removing clone ");
                }
                try {
                    userNode.setProperty(user, (String)null);
                    userNode.getSession().save();
                    logger.trace(user + "  deleted from share " + sharedNode.getPath());
                }
                catch (Exception e) {
                    logger.error("Error removing user from node Users ");
                }
            }
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public boolean isVreFolder() {
        return this.isVreFolder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getGroupIds(Node node) throws PathNotFoundException, RepositoryException {
        ArrayList<String> groupIdsList = null;
        try {
            groupIdsList = new ArrayList<String>();
            NodeIterator groups = node.getNode(GROUP_IDS).getNodes();
            while (groups.hasNext()) {
                groupIdsList.add(groups.nextNode().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return groupIdsList;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public ACLType getACLUser() throws InternalErrorException {
        return JCRPrivilegesInfo.getACLByUser(this.workspace.getOwner().getPortalLogin(), this.getAbsPath());
    }

    private String getAbsPath() {
        return this.absPath;
    }
}

