/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.Policies;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="policyManager")
public class PolicyManager {
    private static Logger log = LoggerFactory.getLogger(PolicyManager.class);
    @Inject
    TokenPersistence tokenPersistence;

    @POST
    @Consumes(value={"application/xml"})
    public Response setPolices(Policies policies) {
        try {
            log.info("adding policies: {}", (Object)policies.getPolicies());
            this.tokenPersistence.addPolicies(policies.getPolicies());
        }
        catch (Exception e) {
            log.error("error adding policies", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error adding policies: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @DELETE
    @Consumes(value={"application/xml"})
    @Path(value="{policy_id}")
    public Response remove(@Null @PathParam(value="policy_id") long policyId) {
        try {
            log.info("removing policy with id {}", (Object)policyId);
            this.tokenPersistence.removePolicy(policyId);
        }
        catch (Exception e) {
            log.error("error removing policies", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error removing policies: " + e.getMessage())).type("text/plain").build());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/xml"})
    public Policies getPoliciesPerContext(@NotNull @QueryParam(value="context") String context) {
        try {
            log.info("retrieving polices in context {}", (Object)context);
            Policies policies = new Policies(this.tokenPersistence.getPolices(context));
            log.info("returning {} policies from getPoliciesPerContext", (Object)policies.getPolicies().size());
            return policies;
        }
        catch (Exception e) {
            log.error("error retrieving policies per context {}", (Object)context, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error retrieving policies: " + e.getMessage())).type("text/plain").build());
        }
    }
}

