/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.consumer;

import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.gcube.accounting.usagetracker.configuration.Configuration;
import org.gcube.accounting.ut.UsageTrackerRestAPI;

public class UTConsumer
implements Runnable,
ServletContextListener {
    private static Logger logger = Logger.getLogger(UTConsumer.class);
    private QueueCouple queueCouple;

    public UTConsumer() {
    }

    public UTConsumer(QueueCouple queueCouple) {
        this.queueCouple = queueCouple;
    }

    @Override
    public void run() {
        UsageTrackerRestAPI ut = new UsageTrackerRestAPI("http://localhost:8080/usagetracker/rest");
        ResourceAccounting raFactory = null;
        try {
            raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
            logger.info((Object)"getting Resource Accounting factory");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (true) {
            RawUsageRecord ur = raFactory.receiveAccountingMessage(this.queueCouple);
            logger.info((Object)("new UR retrieved : " + ur.getId()));
            this.publishAccountingRecord(ut, ur);
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void publishAccountingRecord(UsageTrackerRestAPI ut, RawUsageRecord ur) {
        logger.info((Object)("publishing new record on the usage tracker : " + ur.getId()));
        ut.insertUsageRecord(ur);
    }

    public void contextInitialized(ServletContextEvent event) {
        List scopes = Configuration.getInstance().getScopes();
        String broker = Configuration.getInstance().getBroker();
        logger.info((Object)("starting UTConsumer on broker " + broker + " with scopes " + scopes));
        for (Object scope : scopes) {
            QueueCouple couple = new QueueCouple(broker, (String)scope);
            Thread t = new Thread((Runnable)new UTConsumer(couple));
            t.start();
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

