/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.rest.resources.network;

import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordResource;
import org.gcube.accounting.datamodel.NetworkUsageRecord;
import org.gcube.accounting.datamodel.StorageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

public class NetworkRecordResource extends
		AbstractRecordResource<NetworkUsageRecord> {

	public NetworkRecordResource(String id) {
		super(id);
	}

	protected NetworkUsageRecord createRecord(UsageRecord r) {
		return new NetworkUsageRecord(r);
	}
	
	protected void validate(NetworkUsageRecord record) throws InvalidValueException {
		record.validate();
	}

	protected boolean isCorrectType(UsageRecord r) {
		return NetworkUsageRecord.TYPE_NETWORK.toString().equals(r.getResourceType());
	}

	
}
