/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.net.URI;
import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmartExecutorPersistenceConfiguration {
    public final String SERVICE_ENDPOINT_CATEGORY = "VREManagement";
    public final String SERVICE_ENDPOINT_NAME = "SmartExecutorPersistenceConfiguration";
    protected static final String PERSISTENCE_CLASS_NAME = "persistenceClassName";
    protected static final String TARGET_SCOPE = "targetScope";
    protected URI uri;
    protected String username;
    protected String password;
    protected Map<String, ServiceEndpoint.Property> propertyMap;

    protected void init() {
        this.propertyMap = new HashMap();
    }

    public SmartExecutorPersistenceConfiguration() {
        this.init();
    }

    public SmartExecutorPersistenceConfiguration(URI uri, String username, String password) {
        this.init();
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public SmartExecutorPersistenceConfiguration(String persistenceClassName) throws Exception {
        this.init();
        ServiceEndpoint serviceEndpoint = this.getServiceEndpoint("VREManagement", "SmartExecutorPersistenceConfiguration", persistenceClassName);
        this.setValues(serviceEndpoint, persistenceClassName);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProperty(String propertyKey) throws Exception {
        ServiceEndpoint.Property propertyValue = (ServiceEndpoint.Property)this.propertyMap.get(propertyKey);
        String value = propertyValue.value();
        if (propertyValue.isEncrypted()) {
            value = SmartExecutorPersistenceConfiguration.decrypt((String)value, (Key[])new Key[0]);
        }
        return value;
    }

    protected ServiceEndpoint getServiceEndpoint(String serviceEndpointCategory, String serviceEndpointName, String persistenceClassName) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", serviceEndpointCategory));
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", serviceEndpointName));
        query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Name/text() eq '%s'", "persistenceClassName"));
        query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Value/text() eq '%s'", persistenceClassName));
        query.setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        if (serviceEndpoints.size() > 1) {
            query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Name/text() eq '%s'", "targetScope"));
            query.addCondition(String.format("$resource/Profile/AccessPoint/Properties/Property/Value/text() eq '%s'", SmartExecutorInitializator.getScopeFromToken()));
            serviceEndpoints = client.submit((Query)query);
        }
        return (ServiceEndpoint)serviceEndpoints.get(0);
    }

    private static String decrypt(String encrypted, Key ... key) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(encrypted, new Key[0]);
    }

    protected void setValues(ServiceEndpoint serviceEndpoint, String persistenceClassName) throws Exception {
        Group accessPoints = serviceEndpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            String password;
            Collection properties = accessPoint.propertyMap().values();
            if (!properties.contains(new ServiceEndpoint.Property().nameAndValue("persistenceClassName", persistenceClassName))) continue;
            this.uri = new URI(accessPoint.address());
            this.username = accessPoint.username();
            String encryptedPassword = accessPoint.password();
            this.password = password = SmartExecutorPersistenceConfiguration.decrypt((String)encryptedPassword, (Key[])new Key[0]);
            this.propertyMap = accessPoint.propertyMap();
        }
    }
}

