/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceException;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.LockNotOwnedException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceLockedException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.SyncFolderDescriptor;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceFolderManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceFolderManager.class);
    private static final Map<String, String> cleanedPropertiesMap = new HashMap<String, String>();
    private WorkspaceFolder theFolder;
    private String folderId;
    private SynchFolderConfiguration config = null;
    private ThreddsController threddsController = null;

    public WorkspaceFolderManager(String folderId) throws WorkspaceInteractionException {
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            this.theFolder = (WorkspaceFolder)ws.getItem(folderId);
            this.folderId = folderId;
        }
        catch (HomeNotFoundException | InternalErrorException | UserNotFoundException | WorkspaceException e) {
            throw new WorkspaceInteractionException("Unable to access folder id " + folderId, e);
        }
    }

    public ThreddsController getThreddsController() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        if (this.threddsController == null) {
            SynchFolderConfiguration config = this.getSynchConfiguration();
            this.threddsController = new ThreddsController(config.getRemotePath(), config.getTargetToken());
        }
        return this.threddsController;
    }

    public SynchFolderConfiguration getSynchConfiguration() throws WorkspaceInteractionException, WorkspaceNotSynchedException {
        if (this.config == null) {
            try {
                if (!this.isSynched()) {
                    throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
                }
                log.debug("Loading properties for ");
                Properties props = this.theFolder.getProperties();
                SynchFolderConfiguration config = new SynchFolderConfiguration();
                config.setFilter(props.getPropertyValue("WS-SYNCH.SYNCHRONIZATION-FILTER"));
                config.setRemotePath(props.getPropertyValue("WS-SYNCH.REMOTE-PATH"));
                config.setRemotePersistence(props.getPropertyValue("WS-SYNCH.REMOTE-PERSISTENCE"));
                config.setTargetToken(props.getPropertyValue("WS-SYNCH.TARGET-TOKEN"));
                this.config = config;
            }
            catch (InternalErrorException e) {
                throw new WorkspaceInteractionException("Unable to load synch configuration in " + this.folderId, e);
            }
        }
        return this.config;
    }

    public boolean isSynched() throws WorkspaceInteractionException {
        try {
            Map props = this.theFolder.getProperties().getProperties();
            return props.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED") && props.get("WS-SYNCH.TO-BE-SYNCHRONIZED") != null;
        }
        catch (InternalErrorException e) {
            throw new WorkspaceInteractionException("Unable to check Synch flag on " + this.folderId, e);
        }
    }

    public SyncFolderDescriptor check(boolean recursively) throws WorkspaceInteractionException, InternalException {
        if (!this.isSynched()) {
            throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
        }
        if (this.isLocked()) {
            throw new WorkspaceLockedException("Workspace " + this.folderId + " is locked.");
        }
        return null;
    }

    public String getLockId() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        return this.getThreddsController().readThreddsFile("~WS-LOCK.lock");
    }

    public boolean isLocked() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        return this.getThreddsController().existsThreddsFile("~WS-LOCK.lock");
    }

    public void configure(SynchFolderConfiguration toSet) throws WorkspaceInteractionException, InternalException {
        if (this.isSynched()) {
            throw new WorkspaceInteractionException("Folder " + this.folderId + " is already configured for synchronization.");
        }
        log.info("Configuring folder {} as {} ", (Object)this.folderId, (Object)toSet);
        HashMap<String, String> toSetValues = new HashMap<String, String>();
        toSetValues.put("WS-SYNCH.TO-BE-SYNCHRONIZED", "true");
        toSetValues.put("WS-SYNCH.SYNCHRONIZATION-FILTER", toSet.getFilter());
        toSetValues.put("WS-SYNCH.REMOTE-PATH", toSet.getRemotePath());
        toSetValues.put("WS-SYNCH.REMOTE-PERSISTENCE", "thredds");
        toSetValues.put("WS-SYNCH.TARGET-TOKEN", toSet.getTargetToken());
        try {
            Properties props = this.theFolder.getProperties();
            props.addProperties(toSetValues);
        }
        catch (InternalErrorException e) {
            throw new WorkspaceInteractionException("Unable to set Properties to " + this.folderId, e);
        }
        log.debug("Checking remote folder existence .. ");
        boolean createCatalog = false;
        try {
            ThreddsController controller = this.getThreddsController();
            if (!controller.existsThreddsFile(null)) {
                log.info("Folder not found, creating it..");
                controller.cleanupFolder(null);
                createCatalog = true;
            } else {
                ThreddsCatalog catalog = controller.getCatalog();
                if (catalog == null) {
                    createCatalog = true;
                }
            }
            if (createCatalog) {
                log.info("Creating catalog...");
                controller.getCatalog();
            }
        }
        catch (InternalException e) {
            throw new InternalException("Unable to check/initialize remote folder", e);
        }
    }

    public void dismiss(boolean deleteRemote) throws WorkspaceInteractionException, InternalException {
        if (!this.isSynched()) {
            throw new WorkspaceNotSynchedException("Folder " + this.folderId + " is not synched.");
        }
        if (this.isLocked()) {
            throw new WorkspaceLockedException("Unable to dismiss locked folder " + this.folderId);
        }
        try {
            this.cleanCache();
            WorkspaceFolderManager.cleanItem((WorkspaceItem)this.theFolder);
            if (deleteRemote) {
                this.getThreddsController().cleanupFolder(null);
            }
        }
        catch (InternalErrorException e) {
            throw new WorkspaceInteractionException("Unable to cleanup " + this.folderId, e);
        }
    }

    public void lock(String processId) throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        this.getThreddsController().lockFolder(processId);
    }

    public void unlock(String processId) throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        String currentLock = this.getLockId();
        if (!processId.equals(currentLock)) {
            throw new LockNotOwnedException("Process " + processId + " can't remove lock owned by " + currentLock);
        }
        this.getThreddsController().deleteThreddsFile("~WS-LOCK.lock");
    }

    private void cleanCache() {
        this.config = null;
        this.threddsController = null;
    }

    private static void cleanItem(WorkspaceItem item) throws InternalErrorException {
        Properties props = item.getProperties();
        if (props.hasProperty("WS-SYNCH.TO-BE-SYNCHRONIZED")) {
            props.addProperties(cleanedPropertiesMap);
            if (item.isFolder()) {
                for (WorkspaceItem child : ((WorkspaceFolder)item).getChildren()) {
                    WorkspaceFolderManager.cleanItem(child);
                }
            }
        }
    }

    private static void checkItem(WorkspaceItem item, boolean recursive) {
    }

    static {
        cleanedPropertiesMap.put("WS-SYNCH.TO-BE-SYNCHRONIZED", null);
        cleanedPropertiesMap.put("WS-SYNCH.SYNCHRONIZATION-FILTER", null);
        cleanedPropertiesMap.put("WS-SYNCH.REMOTE-PATH", null);
        cleanedPropertiesMap.put("WS-SYNCH.REMOTE-PERSISTENCE", null);
    }
}

