/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.tika.io.IOUtils;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.sdi.utils.ScopeUtils;
import org.gcube.usecases.ws.thredds.TokenSetter;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.faults.UnableToLockException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsController {
    private static final Logger log = LoggerFactory.getLogger(ThreddsController.class);
    private String hostname;
    private String operatingPath;
    private String targetToken;
    private String callerToken = null;

    public ThreddsController(String path, String targetToken) throws InternalException {
        this.operatingPath = path;
        this.targetToken = targetToken;
        this.setTargetToken();
        this.hostname = ThreddsController.getThreddsHost();
        if (this.hostname == null) {
            throw new InternalException("Unable to find a thredds instance in target scope " + ScopeUtils.getCurrentScope());
        }
        this.resetCallerToken();
    }

    private void setTargetToken() {
        this.callerToken = TokenSetter.getCurrentToken();
        TokenSetter.setToken(this.targetToken);
    }

    private void resetCallerToken() {
        TokenSetter.setToken(this.callerToken);
        this.callerToken = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreddsInfo getThreddsInfo() {
        this.setTargetToken();
        try {
            String infoPath = "https://" + this.hostname + "/data-transfer-service/gcube/service/Capabilities/pluginInfo/REGISTER_CATALOG";
            log.info("Loading thredds info from {} ", (Object)infoPath);
            WebTarget target = ThreddsController.getWebClient().target(infoPath);
            ThreddsInfo threddsInfo = (ThreddsInfo)target.request(new String[]{"application/json"}).get(ThreddsInfo.class);
            return threddsInfo;
        }
        finally {
            this.resetCallerToken();
        }
    }

    public void lockFolder(String processId) throws UnableToLockException {
        File temp;
        block11: {
            this.setTargetToken();
            PrintWriter writer = null;
            temp = null;
            try {
                log.info("Locking remote path {} to processId {} ", (Object)this.operatingPath, (Object)processId);
                DataTransferClient cl = ThreddsController.getDTClient(this.hostname);
                Destination dest = new Destination();
                dest.setCreateSubfolders(Boolean.valueOf(false));
                dest.setOnExistingFileName(DestinationClashPolicy.FAIL);
                dest.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
                dest.setPersistenceId("thredds");
                dest.setSubFolder(this.operatingPath);
                dest.setDestinationFileName("~WS-LOCK.lock");
                temp = File.createTempFile("tmp_lock", ".tmp");
                writer = new PrintWriter(temp);
                writer.write(processId);
                writer.flush();
                writer.close();
                cl.localFile(temp, dest);
                if (writer == null) break block11;
            }
            catch (Throwable t) {
                try {
                    throw new UnableToLockException("Unable to lock " + this.operatingPath, t);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        IOUtils.closeQuietly(writer);
                    }
                    if (temp != null) {
                        try {
                            Files.deleteIfExists(temp.toPath());
                        }
                        catch (IOException e) {
                            log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
                        }
                    }
                    this.resetCallerToken();
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        if (temp != null) {
            try {
                Files.deleteIfExists(temp.toPath());
            }
            catch (IOException e) {
                log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
            }
        }
        this.resetCallerToken();
    }

    public void deleteThreddsFile(String location) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "http://" + this.hostname + ":80/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(location);
        log.info("Deleting file at {} ", (Object)urlString);
        try {
            ThreddsController.getWebClient().target(urlString).request().delete();
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsThreddsFile(String location) {
        this.setTargetToken();
        String urlString = "http://" + this.hostname + ":80/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(location);
        log.info("Checking file at {} ", (Object)urlString);
        try {
            Response resp = ThreddsController.getWebClient().target(urlString).request().head();
            boolean bl = resp.getStatus() >= 200 && resp.getStatus() < 300;
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.resetCallerToken();
        }
    }

    public String readThreddsFile(String location) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "http://" + this.hostname + ":80/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(location);
        log.info("Reading file at {} ", (Object)urlString);
        try {
            String string = (String)ThreddsController.getWebClient().target(urlString).request().get().readEntity(String.class);
            return string;
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    public void cleanupFolder(String targetPath) throws InternalException {
        this.setTargetToken();
        String toCleanPath = this.getPathFromStartingLocation(targetPath);
        try {
            log.info("Cleaning up {} on {} ", (Object)toCleanPath, (Object)this.hostname);
            DataTransferClient client = ThreddsController.getDTClient(this.hostname);
            File toTransfer = File.createTempFile("clean", ".dt_temp");
            toTransfer.createNewFile();
            Destination dest = new Destination();
            dest.setCreateSubfolders(Boolean.valueOf(true));
            dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            dest.setOnExistingSubFolder(DestinationClashPolicy.REWRITE);
            dest.setPersistenceId("thredds");
            dest.setSubFolder(toCleanPath);
            log.info("Going to cleanup remote folder {} on {} ", (Object)dest.getSubFolder(), (Object)this.hostname);
            client.localFile(toTransfer, dest);
            log.info("Done");
        }
        catch (Exception e) {
            log.error("Unable to delete remote folder " + toCleanPath, (Throwable)e);
            throw new InternalException("Unable to cleanup remote folder.");
        }
        finally {
            this.resetCallerToken();
        }
    }

    public ThreddsCatalog createCatalog() {
        return null;
    }

    public ThreddsCatalog getCatalog() {
        return null;
    }

    public RemoteFileDescriptor getFileDescriptor(String path) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "http://" + this.hostname + ":80/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(path);
        log.info("Reading file at {} ", (Object)urlString);
        try {
            RemoteFileDescriptor remoteFileDescriptor = (RemoteFileDescriptor)ThreddsController.getWebClient().target(urlString).queryParam("descriptor", new Object[]{true}).request().get().readEntity(RemoteFileDescriptor.class);
            return remoteFileDescriptor;
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    private String getPathFromStartingLocation(String location) {
        if (location != null && location.length() > 0) {
            return this.operatingPath + "/" + location;
        }
        return this.operatingPath;
    }

    private static String getThreddsHost() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'SDI'").addCondition("$resource/Profile/ServiceName/text() eq 'Thredds'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        GCoreEndpoint endpoint = (GCoreEndpoint)client.submit((Query)query).get(0);
        return ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().iterator().next()).uri().getHost();
    }

    private static Client getWebClient() {
        return ClientBuilder.newClient((Configuration)new ClientConfig().register(AuthorizationFilter.class));
    }

    private static DataTransferClient getDTClient(String threddsHostName) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting DT Client for {} ", (Object)threddsHostName);
        return DataTransferClient.getInstanceByEndpoint((String)("http://" + threddsHostName + ":80"));
    }
}

